/*
 * Decompiled with CFR 0.152.
 */
package com.quintonc.vs_sails.ship;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.quintonc.vs_sails.ServerWindManager;
import com.quintonc.vs_sails.config.ConfigUtils;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ServerTickListener;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SailsShipControl
implements ShipForcesInducer,
ServerTickListener {
    @JsonIgnore
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ship_control");
    private ConcurrentLinkedQueue<Vector3dc> invForces = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Vector3dc> rotForces = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<ForceAtPos> invPosForces = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<ForceAtPos> rotPosForces = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Double> buoyForces = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Double> rotTorques = new ConcurrentLinkedQueue();
    @JsonIgnore
    private static final int sailSpeed = Integer.parseInt(ConfigUtils.config.getOrDefault("sail-power", "25000"));
    @JsonIgnore
    private static final boolean forgivingSails = Boolean.parseBoolean(ConfigUtils.config.getOrDefault("forgiving-sails", "false"));
    @JsonIgnore
    private static final double noSailZone = Math.toRadians((double)Integer.parseInt(ConfigUtils.config.getOrDefault("no-sail-zone", "90")) / 2.0);
    @JsonIgnore
    private static final double keelStrength = Double.parseDouble(ConfigUtils.config.getOrDefault("keel-power", "4.0"));
    @JsonIgnore
    private static final double magicBallastForce = Double.parseDouble(ConfigUtils.config.getOrDefault("magic-ballast-righting-force", "0.25"));
    @JsonIgnore
    private static final double ballastStrength = Double.parseDouble(ConfigUtils.config.getOrDefault("ballast-float-strength", "0.0625"));
    @JsonIgnore
    private static final double buoyStrength = Double.parseDouble(ConfigUtils.config.getOrDefault("buoy-float-strength", "0.125"));
    public double rudderMod = 0.0;
    public int numSails = 0;
    public int numFnASails = 0;
    public int numSquareSails = 0;
    public int numBallast = 0;
    public int numMagicBallast = 0;
    public int numBuoys = 0;
    public int numHelms = 0;
    public int boundx = 1;
    public int boundz = 1;
    @JsonIgnore
    public Level world = null;
    @JsonIgnore
    public Component message;
    public Direction shipDirection = Direction.NORTH;
    @JsonIgnore
    public ServerShip ship = null;

    @JsonIgnore
    public static SailsShipControl getOrCreate(ServerShip ship, Level world) {
        if (ship != null) {
            if (ship.getAttachment(SailsShipControl.class) == null) {
                ship.saveAttachment(SailsShipControl.class, (Object)new SailsShipControl());
            }
            SailsShipControl controller = (SailsShipControl)ship.getAttachment(SailsShipControl.class);
            assert (controller != null);
            if (world != null) {
                controller.world = world;
            }
            if (ship.getShipAABB() != null) {
                controller.boundx = ship.getShipAABB().maxX() - ship.getShipAABB().minX();
                controller.boundz = ship.getShipAABB().maxZ() - ship.getShipAABB().minZ();
            } else {
                controller.boundx = 0;
                controller.boundz = 0;
            }
            if (controller.boundx > controller.boundz) {
                if (controller.shipDirection != Direction.WEST && controller.shipDirection != Direction.EAST) {
                    controller.shipDirection = Direction.EAST;
                    int x = controller.numSquareSails;
                    controller.numSquareSails = controller.numFnASails;
                    controller.numFnASails = x;
                    LOGGER.info("Sail types swapped! New ship dir: " + String.valueOf(controller.shipDirection));
                }
            } else if (controller.shipDirection != Direction.SOUTH && controller.shipDirection != Direction.NORTH) {
                controller.shipDirection = Direction.NORTH;
                int x = controller.numSquareSails;
                controller.numSquareSails = controller.numFnASails;
                controller.numFnASails = x;
                LOGGER.info("Sail types swapped! New ship dir: " + String.valueOf(controller.shipDirection));
            }
            return controller;
        }
        return null;
    }

    public static SailsShipControl getOrCreate(ServerShip ship) {
        return SailsShipControl.getOrCreate(ship, null);
    }

    public void applyForces(@NotNull PhysShip physShip) {
        PhysShipImpl physShip1 = (PhysShipImpl)physShip;
        physShip1.setDoFluidDrag(true);
        while (!this.invForces.isEmpty()) {
            physShip1.applyInvariantForce(Objects.requireNonNull(this.invForces.poll()));
        }
        while (!this.rotForces.isEmpty()) {
            physShip1.applyRotDependentForce(Objects.requireNonNull(this.rotForces.poll()));
        }
        while (!this.invPosForces.isEmpty()) {
            ForceAtPos invData = this.invPosForces.poll();
            if (invData == null) continue;
            physShip1.applyInvariantForceToPos(invData.force, invData.pos);
        }
        while (!this.rotPosForces.isEmpty()) {
            ForceAtPos rotData = this.rotPosForces.poll();
            if (rotData == null || rotData.force == null || rotData.pos == null) continue;
            physShip1.applyRotDependentForceToPos(rotData.force, rotData.pos);
        }
        Vector3dc linearVelocity = physShip1.getPoseVel().getVel();
        Vector3d acceleration = linearVelocity.negate(new Vector3d());
        Vector3d force = acceleration.mul(physShip1.getInertia().getShipMass());
        force = physShip1.getTransform().getWorldToShip().transformDirection(force);
        Vector3d keelForce = this.shipDirection == Direction.NORTH || this.shipDirection == Direction.SOUTH ? new Vector3d(force.x() * keelStrength, 0.0, 0.0) : new Vector3d(0.0, 0.0, force.z() * 4.0);
        physShip.applyRotDependentForce((Vector3dc)keelForce);
        if (this.numMagicBallast > 0) {
            Vector3d shipUp = new Vector3d(0.0, 1.0, 0.0);
            Vector3d worldUp = new Vector3d(0.0, 1.0, 0.0);
            physShip1.getTransform().getShipToWorldRotation().transform(shipUp);
            double angleBetween = shipUp.angle((Vector3dc)worldUp);
            Vector3d idealAngularAcceleration = new Vector3d(0.0, 0.0, 0.0);
            if (angleBetween > 0.01) {
                Vector3d stabilizationRotationAxisNormalized = shipUp.cross((Vector3dc)worldUp, new Vector3d()).normalize();
                idealAngularAcceleration.add((Vector3dc)stabilizationRotationAxisNormalized.mul(angleBetween, stabilizationRotationAxisNormalized));
            }
            Vector3dc omega = physShip1.getPoseVel().getOmega();
            idealAngularAcceleration.sub(omega.x(), omega.y(), omega.z());
            Vector3d stabilizationTorque = physShip1.getTransform().getShipToWorldRotation().transform(physShip1.getInertia().getMomentOfInertiaTensor().transform(physShip1.getTransform().getShipToWorldRotation().transformInverse(idealAngularAcceleration)));
            stabilizationTorque.mul((double)this.numMagicBallast * magicBallastForce);
            physShip1.applyInvariantTorque((Vector3dc)stabilizationTorque);
        }
        if (this.numBallast > 0 || this.numBuoys > 0) {
            physShip1.setBuoyantFactor(1.0 + (double)this.numBuoys * buoyStrength + (double)this.numBallast * ballastStrength);
        }
        if (this.numSails > 0) {
            Vector3d sailForce = new Vector3d((double)this.shipDirection.m_122436_().m_123341_(), (double)this.shipDirection.m_122436_().m_123342_(), (double)this.shipDirection.m_122436_().m_123343_());
            if (Boolean.parseBoolean(ConfigUtils.config.getOrDefault("enable-wind", "true"))) {
                Vector3dc shipPos = physShip1.getTransform().getPositionInWorld();
                Vec3 shipPos2 = new Vec3(shipPos.x(), shipPos.y(), shipPos.z());
                BlockPos shipPos3 = new BlockPos((int)shipPos.x(), (int)shipPos.y(), (int)shipPos.z());
                double windDirection = ServerWindManager.getWindDirection(this.world, shipPos2);
                double windStrength = ServerWindManager.getWindStrength(this.world, shipPos3);
                double shipAngle = SailsShipControl.getShipYaw(physShip1.getTransform().getShipToWorldRotation());
                double windAngle = windStrength > 0.0 ? windDirection + 90.0 : windDirection + 270.0;
                if (this.shipDirection == Direction.WEST) {
                    windAngle = (windAngle - 90.0) % 360.0;
                } else if (this.shipDirection == Direction.NORTH) {
                    windAngle = (windAngle + 180.0) % 360.0;
                } else if (this.shipDirection == Direction.EAST) {
                    windAngle = (windAngle + 90.0) % 360.0;
                }
                windAngle = Math.toRadians(windAngle);
                double squareAngleBetween = Math.abs(Math.min(Math.abs(shipAngle - windAngle), Math.PI * 2 - Math.abs(shipAngle - windAngle)));
                double fnaAngle1 = Math.abs(shipAngle + 1.5707963267948966 - windAngle);
                double fnaAngle2 = Math.abs(shipAngle - 1.5707963267948966 - windAngle);
                double fnaAngleBetween = Math.abs(Math.min(Math.min(fnaAngle1, Math.PI * 2 - fnaAngle1), Math.min(fnaAngle2, Math.PI * 2 - fnaAngle2)));
                if (squareAngleBetween > 1.5707963267948966) {
                    fnaAngleBetween *= 2.0;
                }
                double squareWindModifier = (double)this.numSquareSails / this.calculateWindAngleModifier(squareAngleBetween, Math.PI - noSailZone);
                double fnAWindModifier = (double)this.numFnASails / this.calculateWindAngleModifier(fnaAngleBetween, Math.PI - noSailZone);
                sailForce.mul(-(squareWindModifier + fnAWindModifier) * (double)sailSpeed * (windStrength * windStrength));
            } else {
                sailForce.mul((double)(-(this.numSquareSails + this.numFnASails) * sailSpeed));
            }
            if (sailForce.x > 0.0) {
                sailForce.x -= this.rudderMod;
            } else if (sailForce.x < 0.0) {
                sailForce.x += this.rudderMod;
            }
            physShip1.applyRotDependentForce((Vector3dc)sailForce);
        } else if (this.numSails < 0) {
            this.numSails = 0;
            LOGGER.info("forced numSails = 0");
        }
        if (this.numSquareSails < 0) {
            this.numSquareSails = 0;
            LOGGER.info("forced numSquareSails = 0");
        }
        if (this.numFnASails < 0) {
            this.numFnASails = 0;
            LOGGER.info("forced numFnASails = 0");
        }
        if (this.numBallast < 0) {
            this.numBallast = 0;
            LOGGER.info("forced numBallast = 0");
        }
        if (this.numMagicBallast < 0) {
            this.numMagicBallast = 0;
            LOGGER.info("forced numMagicBallast = 0");
        }
        if (this.numBuoys < 0) {
            this.numBuoys = 0;
            LOGGER.info("forced numBuoys = 0");
        }
        if (this.numHelms < 0) {
            this.numHelms = 0;
            LOGGER.info("forced numHelms = 0");
        }
    }

    public void applyInvariantForce(Vector3dc force) {
        this.invForces.add(force);
    }

    public void applyRotDependentForce(Vector3dc force) {
        this.rotForces.add(force);
    }

    public void applyInvariantForceToPos(Vector3dc force, Vector3dc pos) {
        ForceAtPos data = new ForceAtPos();
        data.force = force;
        data.pos = pos;
        this.invPosForces.add(data);
    }

    public void applyRotDependentForceToPos(Vector3dc force, Vector3dc pos) {
        ForceAtPos data = new ForceAtPos();
        data.force = force;
        data.pos = pos;
        this.rotPosForces.add(data);
    }

    public void updateRudderAngle(double angle) {
    }

    private double calculateWindAngleModifier(double windAngle, double noSail) {
        if (forgivingSails) {
            return Math.pow(2.0, windAngle / noSail) + Math.pow(2.0, -windAngle / noSail);
        }
        return Math.pow(2.0, Math.pow(windAngle, 2.0) / noSail) + Math.pow(2.0, -Math.pow(windAngle, 2.0) / noSail);
    }

    public static double getShipYaw(Quaterniondc shipRotation) {
        Vector3d worldForwardDirection = new Vector3d();
        Vector3d LOCAL_SHIP_FORWARD_NEGATIVE_Z = new Vector3d(0.0, 0.0, -1.0);
        shipRotation.transform((Vector3dc)LOCAL_SHIP_FORWARD_NEGATIVE_Z, worldForwardDirection);
        if (worldForwardDirection.lengthSquared() < 1.0E-12) {
            return 0.0;
        }
        double horizontalDistance = Math.sqrt(worldForwardDirection.x * worldForwardDirection.x + worldForwardDirection.z * worldForwardDirection.z);
        double yaw = horizontalDistance < 1.0E-9 ? 0.0 : Math.atan2(worldForwardDirection.x, -worldForwardDirection.z);
        if (yaw < 0.0) {
            yaw = Math.PI * 2 + yaw;
        }
        return yaw;
    }

    public void addBuoyancy(double buoyancy) {
        this.buoyForces.add(buoyancy);
    }

    public int getNumSails() {
        return this.numSails;
    }

    public int getNumBallast() {
        return this.numBallast;
    }

    private void deleteIfEmpty() {
        if (this.numBallast <= 0 && this.numSails <= 0 && this.numMagicBallast <= 0 && this.numBuoys <= 0 && this.numHelms == 0) {
            this.ship.saveAttachment(SailsShipControl.class, null);
        }
    }

    public void onServerTick() {
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ForceAtPos {
        Vector3dc force;
        Vector3dc pos;

        private ForceAtPos() {
        }
    }
}

