/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem.tornado;

import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.entity.ParticleTexFX;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import weather2.weathersystem.tornado.CubicBezierCurve;
import weather2.weathersystem.tornado.TornadoFunnel;
import weather2.weathersystem.tornado.simple.TornadoFunnelSimple;

public class TornadoManagerTodoRenameMe {
    private Class lastScreenClass = null;
    private ParticleTexFX particleTest = null;
    private List<ParticleTexFX> particles = new ArrayList<ParticleTexFX>();
    private TornadoFunnel funnel;
    private TornadoFunnelSimple funnelSimple;
    public List<CubicBezierCurve> curves = new ArrayList<CubicBezierCurve>();
    public Vector3f[] vecSpeeds = new Vector3f[10];

    public void tick(Level world) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        if (mc.f_91073_.m_46467_() % 1L == 0L) {
            for (Player playerEntity : mc.f_91073_.m_6907_()) {
                int particleCountCircle = 20;
                int particleCountLayers = 40;
                while (this.particles.size() < particleCountCircle * particleCountLayers) {
                    this.particleTest = new ParticleTexFX(mc.f_91073_, playerEntity.m_20185_(), playerEntity.m_20186_() + 2.2, playerEntity.m_20189_(), 0.0, 0.0, 0.0, ParticleRegistry.square16);
                    this.particleTest.setMaxAge(250);
                    this.particleTest.setScale(0.2f);
                    this.particleTest.m_107253_(world.f_46441_.m_188501_(), world.f_46441_.m_188501_(), world.f_46441_.m_188501_());
                    if (this.particles.size() < particleCountCircle * 5) {
                        this.particleTest.m_107253_(1.0f, 1.0f, 1.0f);
                    }
                    float randGrey = 0.4f + world.f_46441_.m_188501_() * 0.4f;
                    this.particleTest.m_107253_(randGrey, randGrey, randGrey);
                    mc.f_91061_.m_107344_((Particle)this.particleTest);
                    this.particles.add(this.particleTest);
                }
                int testY = 100;
                Vector3f pos1 = new Vector3f(0.5f, 70.0f, 0.5f);
                Vector3f pos2 = new Vector3f(0.5f, 120.0f, 0.5f);
                float dist = this.getDistance(pos1, pos2);
                Vector3f vecDiff = new Vector3f((pos1.x() - pos2.x()) / dist, (pos1.y() - pos2.y()) / dist, (pos1.z() - pos2.z()) / dist);
                Vector3f vecAngles = new Vector3f((float)Math.atan2(vecDiff.y(), vecDiff.z()), (float)Math.atan2(vecDiff.z(), vecDiff.x()), (float)Math.atan2(vecDiff.x(), vecDiff.y()));
                vecAngles = new Vector3f((float)Math.toDegrees(vecAngles.x()), (float)Math.toDegrees(vecAngles.y()), (float)Math.toDegrees(vecAngles.z()));
                double xx = pos1.x() - pos2.x();
                double zz = pos1.z() - pos2.z();
                double xzDist = Math.sqrt(xx * xx + zz * zz);
                float pitchAngle = (float)Math.toDegrees(Math.atan2(vecDiff.y(), xzDist / (double)dist));
                pitchAngle += 90.0f;
                while (this.curves.size() < 2) {
                    Vector3f[] vecs = new Vector3f[10];
                    for (int i = 0; i < vecs.length; ++i) {
                        vecs[i] = new Vector3f(world.f_46441_.m_188501_(), world.f_46441_.m_188501_(), world.f_46441_.m_188501_());
                    }
                    this.curves.add(new CubicBezierCurve(vecs));
                }
                CubicBezierCurve bezierCurve = this.curves.get(0);
                if (bezierCurve != null) {
                    float randScale = 0.1f;
                    for (int i = 0; i < bezierCurve.P.length; ++i) {
                        if (this.vecSpeeds[i] == null) {
                            this.vecSpeeds[i] = new Vector3f(world.f_46441_.m_188501_(), world.f_46441_.m_188501_(), world.f_46441_.m_188501_());
                        }
                        bezierCurve.P[i].add(this.vecSpeeds[i].x() * 0.01f, this.vecSpeeds[i].y() * 0.01f, this.vecSpeeds[i].z() * 0.01f);
                        float maxY = 1.0f;
                        float minY = 0.0f;
                        float minXZ = 0.0f;
                        float maxXZ = 1.0f;
                        float randSpeed = 1.5f;
                        if (bezierCurve.P[i].x() > maxXZ) {
                            this.vecSpeeds[i].set(world.f_46441_.m_188501_() * -1.0f * randSpeed, this.vecSpeeds[i].y(), this.vecSpeeds[i].z());
                        } else if (bezierCurve.P[i].x() < minXZ) {
                            this.vecSpeeds[i].set(world.f_46441_.m_188501_() * randSpeed, this.vecSpeeds[i].y(), this.vecSpeeds[i].z());
                        }
                        if (bezierCurve.P[i].y() > maxY) {
                            this.vecSpeeds[i].set(this.vecSpeeds[i].x(), world.f_46441_.m_188501_() * -1.0f * randSpeed, this.vecSpeeds[i].z());
                        } else if (bezierCurve.P[i].y() < minY) {
                            this.vecSpeeds[i].set(this.vecSpeeds[i].x(), world.f_46441_.m_188501_() * randSpeed, this.vecSpeeds[i].z());
                        }
                        if (bezierCurve.P[i].z() > maxXZ) {
                            this.vecSpeeds[i].set(this.vecSpeeds[i].x(), this.vecSpeeds[i].y(), world.f_46441_.m_188501_() * -1.0f * randSpeed);
                            continue;
                        }
                        if (!(bezierCurve.P[i].z() < minXZ)) continue;
                        this.vecSpeeds[i].set(this.vecSpeeds[i].x(), this.vecSpeeds[i].y(), world.f_46441_.m_188501_() * randSpeed);
                    }
                    if (bezierCurve.P.length == 6) {
                        // empty if block
                    }
                }
                Iterator<ParticleTexFX> it = this.particles.iterator();
                int index = 0;
                float adjustedCurvePos = 0.0f;
                while (it.hasNext()) {
                    ParticleTexFX particle = it.next();
                    if (!particle.m_107276_()) {
                        it.remove();
                    } else {
                        float x = 0.0f;
                        float y2 = world.m_46467_() * 2L % 360L + (long)(index % particleCountCircle * (360 / particleCountCircle));
                        float y = index % particleCountCircle * (360 / particleCountCircle);
                        float z = 0.0f;
                        y = vecAngles.y() - 90.0f;
                        int yDiff = index / particleCountCircle - particleCountLayers / 2;
                        float yDiffDist = 0.01f;
                        int curLayer = index / particleCountCircle;
                        float curvePoint = (float)curLayer / (float)particleCountLayers * 1.0f;
                        float curvePoint2 = (float)Math.min(1.0, (double)((float)(curLayer + 1) / (float)particleCountLayers)) * 1.0f;
                        float stretchCurveY = 4.0f;
                        float curveAmp = 2.0f;
                        y2 = (float)world.m_46467_() * (7.0f + (float)((particleCountLayers - curLayer) * (particleCountLayers - curLayer)) * 0.02f) % 360.0f + (float)(index % particleCountCircle * (360 / particleCountCircle));
                        float distFinal = dist / 2.0f;
                        Vector3f vecCurve1 = this.getCurveValue(curvePoint);
                        Vector3f vecCurve2 = this.getCurveValue(curvePoint2);
                        Vec2 curvePointYawPitch = this.yawPitch(vecCurve2, vecCurve1);
                        float curveDist = this.getDistance(vecCurve1, vecCurve2);
                        if (index % particleCountCircle == 0) {
                            adjustedCurvePos += curveDist;
                        }
                        Quaternionf quaternionY = new Quaternionf(0.0, 1.0, 0.0, Math.toRadians(-curvePointYawPitch.f_82470_ - 90.0f));
                        Quaternionf quaternionYCircle = new Quaternionf(0.0, 1.0, 0.0, Math.toRadians(-y2 + (curvePointYawPitch.f_82470_ - 90.0f)));
                        Quaternionf quatPitch = new Quaternionf(1.0, 0.0, 0.0, Math.toRadians(curvePointYawPitch.f_82471_));
                        Vector3f vecCurve = this.getCurveValue(curvePoint);
                        Vector3f vecNew = new Vector3f(1.0f, 0.0f, 0.0f);
                        float rotAroundPosX = 0.0f;
                        float rotAroundPosY = 0.0f;
                        float rotAroundPosZ = 0.0f;
                        Matrix3f matrix = new Matrix3f();
                        matrix.rotation((Quaternionfc)quaternionY);
                        matrix.rotation((Quaternionfc)quatPitch);
                        matrix.rotation((Quaternionfc)quaternionYCircle);
                        vecNew.mulTranspose((Matrix3fc)matrix);
                        rotAroundPosX = vecNew.x();
                        rotAroundPosY = vecNew.y();
                        rotAroundPosZ = vecNew.z();
                        float tiltAdj = 1.0f;
                        particle.setPosition(pos1.x() + vecCurve1.x() * distFinal + rotAroundPosX, pos1.y() + vecCurve1.y() * distFinal + rotAroundPosY * tiltAdj, pos1.z() + vecCurve1.z() * distFinal + rotAroundPosZ);
                        particle.setMotionX(0.0);
                        particle.setMotionY(0.0);
                        particle.setMotionZ(0.0);
                    }
                    ++index;
                }
            }
        }
        if (this.funnel == null) {
            this.funnel = new TornadoFunnel();
            this.funnel.pos = new Vector3d(mc.f_91074_.m_20185_(), mc.f_91074_.m_20186_(), mc.f_91074_.m_20189_());
        }
    }

    public float getDistance(Vector3f vec1, Vector3f vec2) {
        float f = vec1.x() - vec2.x();
        float f1 = vec1.y() - vec2.y();
        float f2 = vec1.z() - vec2.z();
        return Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
    }

    public Vec2 yawPitch(Vector3f pos2, Vector3f pos1) {
        float dist = this.getDistance(pos1, pos2);
        Vector3f vecDiff = new Vector3f((pos1.x() - pos2.x()) / dist, (pos1.y() - pos2.y()) / dist, (pos1.z() - pos2.z()) / dist);
        Vector3f vecAngles = new Vector3f((float)Math.atan2(vecDiff.y(), vecDiff.z()), (float)Math.atan2(vecDiff.z(), vecDiff.x()), (float)Math.atan2(vecDiff.x(), vecDiff.y()));
        double xx = pos1.x() - pos2.x();
        double zz = pos1.z() - pos2.z();
        double xzDist = Math.sqrt(xx * xx + zz * zz);
        double wat = xzDist / (double)dist;
        float pitchAngle = (float)Math.toDegrees(Math.atan2(vecDiff.y(), xzDist / (double)dist));
        vecAngles = new Vector3f((float)Math.toDegrees(vecAngles.x()), (float)Math.toDegrees(vecAngles.y()), (float)Math.toDegrees(vecAngles.z()));
        return new Vec2(vecAngles.y(), pitchAngle += 90.0f);
    }

    public Vector3f getCurveValue(float val) {
        int arrayEntry = (int)Math.floor(val);
        if (arrayEntry > this.curves.size() - 1) {
            System.out.println("out of bounds on curve lookup, val: " + val + " curves: - " + this.curves.size());
            return new Vector3f(1.0f, 1.0f, 1.0f);
        }
        CubicBezierCurve curve = this.curves.get(arrayEntry);
        return curve.getValue(val % 1.0f);
    }
}

