/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings;

import java.util.function.BiConsumer;
import me.paulf.wings.server.dreamcatcher.InSomniable;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.item.WingsItems;
import me.paulf.wings.server.net.Network;
import me.paulf.wings.server.net.clientbound.MessageSyncFlight;
import me.paulf.wings.server.potion.PotionMix;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegistryObject;

public abstract class Proxy {
    protected final Network network = new Network();

    public void init(IEventBus modBus) {
        modBus.addListener(this::setup);
        modBus.addListener(this::registerCapability);
    }

    protected void registerCapability(RegisterCapabilitiesEvent event) {
        event.register(Flight.class);
        event.register(InSomniable.class);
    }

    protected void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            BiConsumer<ItemLike, RegistryObject> reg = (item, obj) -> {
                BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new PotionMix(Potions.f_43596_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), new ItemStack((ItemLike)obj.get())));
                BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new PotionMix(Potions.f_43597_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), new ItemStack((ItemLike)obj.get())));
            };
            reg.accept((ItemLike)Items.f_42402_, WingsItems.ANGEL_WINGS_BOTTLE);
            reg.accept((ItemLike)Items.f_42497_, WingsItems.PARROT_WINGS_BOTTLE);
            reg.accept((ItemLike)WingsItems.BAT_BLOOD_BOTTLE.get(), WingsItems.BAT_WINGS_BOTTLE);
            reg.accept((ItemLike)Items.f_42494_, WingsItems.BLUE_BUTTERFLY_WINGS_BOTTLE);
            reg.accept((ItemLike)Items.f_42454_, WingsItems.DRAGON_WINGS_BOTTLE);
            reg.accept((ItemLike)Items.f_42500_, WingsItems.EVIL_WINGS_BOTTLE);
            reg.accept((ItemLike)Items.f_41948_, WingsItems.FAIRY_WINGS_BOTTLE);
            reg.accept((ItemLike)Items.f_42593_, WingsItems.FIRE_WINGS_BOTTLE);
            reg.accept((ItemLike)Items.f_42536_, WingsItems.MONARCH_BUTTERFLY_WINGS_BOTTLE);
            reg.accept((ItemLike)Items.f_42518_, WingsItems.SLIME_WINGS_BOTTLE);
        });
    }

    public void addFlightListeners(Player player, Flight instance) {
        if (player instanceof ServerPlayer) {
            instance.registerFlyingListener(isFlying -> {
                player.m_150110_().f_35936_ = isFlying;
            });
            instance.registerFlyingListener(isFlying -> {
                if (isFlying) {
                    player.m_6038_();
                }
            });
            Flight.Notifier notifier = Flight.Notifier.of(() -> this.network.sendToPlayer(new MessageSyncFlight(player, instance), (ServerPlayer)player), p -> this.network.sendToPlayer(new MessageSyncFlight(player, instance), (ServerPlayer)p), () -> this.network.sendToAllTracking(new MessageSyncFlight(player, instance), (Entity)player));
            instance.registerSyncListener(players -> players.notify(notifier));
        }
    }
}

