/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings;

import java.util.List;
import me.paulf.wings.Proxy;
import me.paulf.wings.Registries;
import me.paulf.wings.client.ClientProxy;
import me.paulf.wings.server.ServerProxy;
import me.paulf.wings.server.effect.WingsEffects;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.item.WingsItems;
import me.paulf.wings.server.sound.WingsSounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="wings")
public final class WingsMod {
    public static final String ID = "wings";
    private static WingsMod INSTANCE;
    public static final Logger logger;
    private Proxy proxy;

    public WingsMod() {
        if (INSTANCE != null) {
            throw new IllegalStateException("Already constructed!");
        }
        INSTANCE = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        Registries.FlightApparatusRegistry.WINGS.register(bus);
        Registries.ArgumentTypesRegistry.ARGUMENT_TYPES.register(bus);
        WingsItems.REG.register(bus);
        WingsSounds.REG.register(bus);
        WingsEffects.REG.register(bus);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            bus.addListener(this::fillCreativeTabs);
        }
        this.proxy = (Proxy)DistExecutor.safeRunForDist(() -> ProxyInit::createClient, () -> ProxyInit::createServer);
        this.proxy.init(bus);
    }

    public void addFlightListeners(Player player, Flight instance) {
        this.requireProxy().addFlightListeners(player, instance);
    }

    public static WingsMod instance() {
        return INSTANCE;
    }

    private void fillCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256839_) {
            event.accept(WingsItems.BAT_BLOOD_BOTTLE);
        } else if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.m_246601_(List.of(new ItemStack((ItemLike)WingsItems.ANGEL_WINGS_BOTTLE.get()), new ItemStack((ItemLike)WingsItems.PARROT_WINGS_BOTTLE.get()), new ItemStack((ItemLike)WingsItems.SLIME_WINGS_BOTTLE.get()), new ItemStack((ItemLike)WingsItems.BLUE_BUTTERFLY_WINGS_BOTTLE.get()), new ItemStack((ItemLike)WingsItems.MONARCH_BUTTERFLY_WINGS_BOTTLE.get()), new ItemStack((ItemLike)WingsItems.FIRE_WINGS_BOTTLE.get()), new ItemStack((ItemLike)WingsItems.BAT_WINGS_BOTTLE.get()), new ItemStack((ItemLike)WingsItems.FAIRY_WINGS_BOTTLE.get()), new ItemStack((ItemLike)WingsItems.EVIL_WINGS_BOTTLE.get()), new ItemStack((ItemLike)WingsItems.DRAGON_WINGS_BOTTLE.get())));
        }
    }

    private Proxy requireProxy() {
        if (this.proxy == null) {
            throw new IllegalStateException("Proxy not initialized");
        }
        return this.proxy;
    }

    static {
        logger = LogManager.getLogger((String)ID);
    }

    public static final class Names {
        public static final ResourceLocation NONE = Names.create("none");
        public static final ResourceLocation ANGEL = Names.create("angel_wings");
        public static final ResourceLocation PARROT = Names.create("parrot_wings");
        public static final ResourceLocation SLIME = Names.create("slime_wings");
        public static final ResourceLocation BLUE_BUTTERFLY = Names.create("blue_butterfly_wings");
        public static final ResourceLocation MONARCH_BUTTERFLY = Names.create("monarch_butterfly_wings");
        public static final ResourceLocation FIRE = Names.create("fire_wings");
        public static final ResourceLocation BAT = Names.create("bat_wings");
        public static final ResourceLocation FAIRY = Names.create("fairy_wings");
        public static final ResourceLocation EVIL = Names.create("evil_wings");
        public static final ResourceLocation DRAGON = Names.create("dragon_wings");

        private Names() {
        }

        private static ResourceLocation create(String path) {
            return new ResourceLocation(WingsMod.ID, path);
        }
    }

    static class ProxyInit {
        ProxyInit() {
        }

        static Proxy createClient() {
            return new ClientProxy();
        }

        static Proxy createServer() {
            return new ServerProxy();
        }
    }
}

