/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.client;

import java.util.function.Supplier;
import me.paulf.wings.Proxy;
import me.paulf.wings.Registries;
import me.paulf.wings.client.apparatus.WingForm;
import me.paulf.wings.client.flight.Animator;
import me.paulf.wings.client.flight.AnimatorAvian;
import me.paulf.wings.client.flight.AnimatorInsectoid;
import me.paulf.wings.client.flight.FlightView;
import me.paulf.wings.client.model.ModelWings;
import me.paulf.wings.client.model.ModelWingsAvian;
import me.paulf.wings.client.model.ModelWingsInsectoid;
import me.paulf.wings.client.renderer.LayerWings;
import me.paulf.wings.server.apparatus.FlightApparatus;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.flight.Flights;
import me.paulf.wings.server.item.WingsItems;
import me.paulf.wings.server.net.serverbound.MessageControlFlying;
import me.paulf.wings.util.KeyInputListener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public final class ClientProxy
extends Proxy {
    private ModelWings<AnimatorAvian> avianWings;
    private ModelWings<AnimatorInsectoid> insectoidWings;

    @Override
    public void init(IEventBus modBus) {
        super.init(modBus);
        MinecraftForge.EVENT_BUS.register((Object)KeyInputListener.builder().category("key.categories.wings").key("key.wings.fly", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 82).onPress(() -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            Flights.get((Player)player).filter(arg_0 -> ClientProxy.lambda$init$0((Player)player, arg_0)).ifPresent(flight -> flight.toggleIsFlying(Flight.PlayerSet.ofOthers()));
        }).build());
        modBus.addListener(this::registerModelLayers);
        modBus.addListener(this::addCustomLayer);
        modBus.addListener(e -> e.getItemColors().m_92689_((stack, pass) -> pass == 0 ? 10164013 : 0xFFFFFF, new ItemLike[]{(ItemLike)WingsItems.BAT_BLOOD_BOTTLE.get()}));
    }

    private void registerModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModelWingsAvian.AVIAN_LOCATION, ModelWingsAvian::createBodyLayer);
        event.registerLayerDefinition(ModelWingsInsectoid.INSECTOID_LOCATION, ModelWingsInsectoid::createLayerDefinishion);
    }

    private void addCustomLayer(EntityRenderersEvent.AddLayers event) {
        this.avianWings = new ModelWingsAvian(event.getContext().m_174023_(ModelWingsAvian.AVIAN_LOCATION));
        this.insectoidWings = new ModelWingsInsectoid(event.getContext().m_174023_(ModelWingsInsectoid.INSECTOID_LOCATION));
        for (String s : event.getSkins()) {
            LivingEntityRenderer renderer = event.getSkin(s);
            ModelPart body = ((HumanoidModel)renderer.m_7200_()).f_102810_;
            renderer.m_115326_((RenderLayer)new LayerWings((LivingEntityRenderer<Player, HumanoidModel<Player>>)renderer, (player, stack) -> {
                if (player.m_6047_()) {
                    stack.m_85837_(0.0, 0.2, 0.0);
                }
                body.m_104299_(stack);
            }));
        }
        WingForm.register((FlightApparatus)Registries.FlightApparatusRegistry.ANGEL_WINGS.get(), this.createAvianWings(Registries.FlightApparatusRegistry.WINGS_BUILTIN.get().getKey((Object)((FlightApparatus)Registries.FlightApparatusRegistry.ANGEL_WINGS.get()))));
        WingForm.register((FlightApparatus)Registries.FlightApparatusRegistry.PARROT_WINGS.get(), this.createAvianWings(Registries.FlightApparatusRegistry.WINGS_BUILTIN.get().getKey((Object)((FlightApparatus)Registries.FlightApparatusRegistry.PARROT_WINGS.get()))));
        WingForm.register((FlightApparatus)Registries.FlightApparatusRegistry.BAT_WINGS.get(), this.createAvianWings(Registries.FlightApparatusRegistry.WINGS_BUILTIN.get().getKey((Object)((FlightApparatus)Registries.FlightApparatusRegistry.BAT_WINGS.get()))));
        WingForm.register((FlightApparatus)Registries.FlightApparatusRegistry.BLUE_BUTTERFLY_WINGS.get(), this.createInsectoidWings(Registries.FlightApparatusRegistry.WINGS_BUILTIN.get().getKey((Object)((FlightApparatus)Registries.FlightApparatusRegistry.BLUE_BUTTERFLY_WINGS.get()))));
        WingForm.register((FlightApparatus)Registries.FlightApparatusRegistry.DRAGON_WINGS.get(), this.createAvianWings(Registries.FlightApparatusRegistry.WINGS_BUILTIN.get().getKey((Object)((FlightApparatus)Registries.FlightApparatusRegistry.DRAGON_WINGS.get()))));
        WingForm.register((FlightApparatus)Registries.FlightApparatusRegistry.EVIL_WINGS.get(), this.createAvianWings(Registries.FlightApparatusRegistry.WINGS_BUILTIN.get().getKey((Object)((FlightApparatus)Registries.FlightApparatusRegistry.EVIL_WINGS.get()))));
        WingForm.register((FlightApparatus)Registries.FlightApparatusRegistry.FAIRY_WINGS.get(), this.createInsectoidWings(Registries.FlightApparatusRegistry.WINGS_BUILTIN.get().getKey((Object)((FlightApparatus)Registries.FlightApparatusRegistry.FAIRY_WINGS.get()))));
        WingForm.register((FlightApparatus)Registries.FlightApparatusRegistry.FIRE_WINGS.get(), this.createAvianWings(Registries.FlightApparatusRegistry.WINGS_BUILTIN.get().getKey((Object)((FlightApparatus)Registries.FlightApparatusRegistry.FIRE_WINGS.get()))));
        WingForm.register((FlightApparatus)Registries.FlightApparatusRegistry.MONARCH_BUTTERFLY_WINGS.get(), this.createInsectoidWings(Registries.FlightApparatusRegistry.WINGS_BUILTIN.get().getKey((Object)((FlightApparatus)Registries.FlightApparatusRegistry.MONARCH_BUTTERFLY_WINGS.get()))));
        WingForm.register((FlightApparatus)Registries.FlightApparatusRegistry.SLIME_WINGS.get(), this.createInsectoidWings(Registries.FlightApparatusRegistry.WINGS_BUILTIN.get().getKey((Object)((FlightApparatus)Registries.FlightApparatusRegistry.SLIME_WINGS.get()))));
    }

    @Override
    protected void setup(FMLCommonSetupEvent event) {
        super.setup(event);
    }

    @Override
    protected void registerCapability(RegisterCapabilitiesEvent event) {
        super.registerCapability(event);
        event.register(FlightView.class);
    }

    @Override
    public void addFlightListeners(Player player, Flight flight) {
        super.addFlightListeners(player, flight);
        if (player.m_7578_()) {
            Flight.Notifier notifier = Flight.Notifier.of(() -> {}, p -> {}, () -> this.network.sendToServer(new MessageControlFlying(flight.isFlying())));
            flight.registerSyncListener(players -> players.notify(notifier));
        }
    }

    private WingForm<AnimatorAvian> createAvianWings(ResourceLocation name) {
        return this.createWings(name, AnimatorAvian::new, this.avianWings);
    }

    private WingForm<AnimatorInsectoid> createInsectoidWings(ResourceLocation name) {
        return this.createWings(name, AnimatorInsectoid::new, this.insectoidWings);
    }

    private <A extends Animator> WingForm<A> createWings(ResourceLocation name, Supplier<A> animator, ModelWings<A> model) {
        return WingForm.of(animator, model, new ResourceLocation(name.m_135827_(), String.format("textures/entity/%s.png", name.m_135815_())));
    }

    private static /* synthetic */ boolean lambda$init$0(Player player, Flight flight) {
        return flight.canFly(player);
    }
}

