/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.client.debug;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import me.paulf.wings.server.effect.WingsEffects;
import me.paulf.wings.server.flight.Flights;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="wings")
public final class DebugFlightAnimation {
    private static State state = new DisabledState();

    private DebugFlightAnimation() {
    }

    @SubscribeEvent
    public static void init(EntityRenderersEvent.RegisterRenderers event) {
        state = state.init();
    }

    private static interface State {
        public State init();
    }

    protected static final class DisabledState
    implements State {
        protected DisabledState() {
        }

        @Override
        public State init() {
            return this;
        }
    }

    private static final class Handler {
        private static final GameProfile PROFILE = new GameProfile(UUID.fromString("617ab577-0da7-4d6a-a80d-0b516544369d"), "ModDeveloper");
        private Player player;

        private Handler() {
        }

        @SubscribeEvent
        public void tick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                Minecraft mc = Minecraft.m_91087_();
                ClientLevel world = mc.f_91073_;
                if (world != null && (this.player == null || this.player.m_9236_() != world)) {
                    this.player = new RemotePlayer(world, PROFILE){
                        {
                            super(p_252213_, p_250471_);
                            this.m_20088_().m_135381_(f_36089_, (Object)-1);
                        }
                    };
                    this.player.m_20234_(-this.player.m_19879_());
                    this.player.m_6034_(0.0, 62.0, 0.0);
                    this.player.f_19856_ = -1.0;
                    this.player.f_19855_ = 63.0;
                    this.player.m_7292_(new MobEffectInstance((MobEffect)WingsEffects.WINGS.get()));
                    Flights.get(this.player).ifPresent(flight -> flight.setIsFlying(true));
                    world.m_104630_(this.player.m_19879_(), (AbstractClientPlayer)((RemotePlayer)this.player));
                }
                if (this.player != null && mc.m_91403_() != null) {
                    ++this.player.f_19797_;
                    this.player.m_8119_();
                }
            }
        }

        @SubscribeEvent
        public void render(RenderLevelStageEvent event) {
            if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_LEVEL) {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91073_ != null && mc.f_91074_ != null && mc.f_91075_ != null) {
                    EntityRenderDispatcher manager = mc.m_91290_();
                    Vec3 projectedView = mc.f_91063_.m_109153_().m_90583_();
                    manager.m_114384_((Entity)this.player, this.player.m_20185_() - projectedView.m_7096_(), this.player.m_20186_() - projectedView.m_7098_(), this.player.m_20189_() - projectedView.m_7094_(), 0.0f, event.getPartialTick(), event.getPoseStack(), (MultiBufferSource)mc.m_91269_().m_110104_(), manager.m_114394_((Entity)this.player, event.getPartialTick()));
                }
            }
        }
    }

    private static final class EnableState
    implements State {
        private EnableState() {
        }

        @Override
        public State init() {
            MinecraftForge.EVENT_BUS.register((Object)new Handler());
            return new EnabledState();
        }
    }

    private static final class EnabledState
    implements State {
        private EnabledState() {
        }

        @Override
        public State init() {
            return this;
        }
    }
}

