/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.client.flight;

import me.paulf.wings.client.flight.FlightView;
import me.paulf.wings.client.flight.FlightViewDefault;
import me.paulf.wings.server.flight.AttachFlightCapabilityEvent;
import me.paulf.wings.util.CapabilityHolder;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wings", value={Dist.CLIENT})
public final class FlightViews {
    private static final CapabilityHolder<LivingEntity, FlightView, CapabilityHolder.State<LivingEntity, FlightView>> HOLDER = CapabilityHolder.create();
    public static final Capability<FlightView> CAP_FLIGHT_VIEW = FlightViews.injectView();

    private FlightViews() {
    }

    public static boolean has(LivingEntity player) {
        return HOLDER.state().has(player, null);
    }

    public static LazyOptional<FlightView> get(LivingEntity player) {
        return HOLDER.state().get(player, null);
    }

    static Capability<FlightView> injectView() {
        Capability cap = CapabilityManager.get((CapabilityToken)new CapabilityToken<FlightView>(){});
        HOLDER.inject((Capability<FlightView>)cap);
        return cap;
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachFlightCapabilityEvent event) {
        Entity entity = event.getObject();
        if (entity instanceof AbstractClientPlayer) {
            event.addCapability(new ResourceLocation("wings", "flight_view"), HOLDER.state().providerBuilder(new FlightViewDefault((Player)entity, event.getInstance())).build());
        }
    }
}

