/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.client.model;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Direction;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public final class Model3DTexture
extends ModelPart.Cube {
    private static final Set<Direction> ALL_VISIBLE = EnumSet.allOf(Direction.class);
    private final int width;
    private final int height;
    private final float u1;
    private final float v1;
    private final float u2;
    private final float v2;

    private Model3DTexture(float posX, float posY, float posZ, int width, int height, float u1, float v1, float u2, float v2) {
        super(0, 0, posX, posY, posZ, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, 64.0f, 64.0f, ALL_VISIBLE);
        float f9;
        float f8;
        float f82;
        float f7;
        int k;
        this.width = width;
        this.height = height;
        this.u1 = u1;
        this.v1 = v1;
        this.u2 = u2;
        this.v2 = v2;
        int faceCount = 2 + 2 * width + 2 * height;
        ModelPart.Polygon[] quads = new ModelPart.Polygon[faceCount];
        int[] quadIndex = new int[]{0};
        float x0 = this.f_104335_;
        float x1 = this.f_104335_ + (float)this.width;
        float y0 = this.f_104336_;
        float y1 = this.f_104336_ + (float)this.height;
        float z0 = this.f_104337_;
        float z1 = this.f_104337_ + 1.0f;
        FaceAdder faces = (fx0, fy0, fz0, fx1, fy1, fz1, fu1, fv1, fu2, fv2, normal) -> {
            ModelPart.Vertex[] vertices = new ModelPart.Vertex[4];
            boolean v = normal.m_122434_().m_122478_();
            vertices[0] = new ModelPart.Vertex(fx1, fy0, fz0, 0.0f, 0.0f);
            vertices[1] = new ModelPart.Vertex(fx0, fy0, v ? fz0 : fz1, 0.0f, 0.0f);
            vertices[2] = new ModelPart.Vertex(fx0, fy1, fz1, 0.0f, 0.0f);
            vertices[3] = new ModelPart.Vertex(fx1, fy1, v ? fz1 : fz0, 0.0f, 0.0f);
            int n = quadIndex[0];
            quadIndex[0] = n + 1;
            quads[n] = new ModelPart.Polygon(vertices, fu1, fv1, fu2, fv2, 64.0f, 64.0f, false, normal);
        };
        faces.add(x0, y0, z0, x1, y1, z0, this.u1, this.v1, this.u2, this.v2, Direction.NORTH);
        faces.add(x0, y1, z1, x1, y0, z1, this.u1, this.v2, this.u2, this.v1, Direction.SOUTH);
        float f5 = 0.5f * (this.u1 - this.u2) / (float)this.width;
        float f6 = 0.5f * (this.v1 - this.v2) / (float)this.height;
        for (k = 0; k < this.width; ++k) {
            f7 = x0 + (float)k;
            f82 = this.u1 + (this.u2 - this.u1) * ((float)k / (float)this.width) - f5;
            faces.add(f7, y0, z0, f7, y1, z1, f82, this.v1, f82, this.v2, Direction.WEST);
        }
        for (k = 0; k < this.width; ++k) {
            f8 = this.u1 + (this.u2 - this.u1) * ((float)k / (float)this.width) - f5;
            f9 = x0 + (float)(k + 1);
            faces.add(f9, y1, z0, f9, y0, z1, f8, this.v2, f8, this.v1, Direction.EAST);
        }
        for (k = 0; k < this.height; ++k) {
            f8 = this.v1 + (this.v2 - this.v1) * ((float)k / (float)this.height) - f6;
            f9 = y0 + (float)(k + 1);
            faces.add(x0, f9, z0, x1, f9, z1, this.u1, f8, this.u2, f8, Direction.UP);
        }
        for (k = 0; k < this.height; ++k) {
            f7 = y0 + (float)k;
            f82 = this.v1 + (this.v2 - this.v1) * ((float)k / (float)this.height) - f6;
            faces.add(x1, f7, z0, x0, f7, z1, this.u2, f82, this.u1, f82, Direction.DOWN);
        }
        this.f_104341_ = quads;
    }

    private static <E, T> T getPrivateValue(E object, String fieldName) {
        return (T)Objects.requireNonNull(ObfuscationReflectionHelper.getPrivateValue(object.getClass(), object, (String)fieldName));
    }

    public static Model3DTexture create(float posX, float posY, float posZ, int width, int height, int u, int v, int textureWidth, int textureHeight) {
        return new Model3DTexture(posX, posY, posZ, width, height, u, v, u + width, v + height);
    }

    static interface FaceAdder {
        public void add(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, Direction var11);
    }
}

