/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import me.paulf.wings.client.flight.AnimatorAvian;
import me.paulf.wings.client.model.Model3DTexture;
import me.paulf.wings.client.model.ModelWings;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public final class ModelWingsAvian
extends ModelWings<AnimatorAvian> {
    public static final ModelLayerLocation AVIAN_LOCATION = new ModelLayerLocation(new ResourceLocation("wings", "avian_wings"), "main");
    private final ModelPart root;
    private static final Function<String, String> NAME_LEFT = s -> s + "_left";
    private static final Function<String, String> NAME_RIGHT = s -> s + "_right";
    private static final Function<String, String> FEATHERS = s -> "feathers_" + s;
    private static final String CORACOID_LEFT = NAME_LEFT.apply("coracoid");
    private static final String CORACOID_RIGHT = NAME_RIGHT.apply("coracoid_right");
    private static final String HUMERUS_LEFT = NAME_LEFT.apply("humerus");
    private static final String HUMERUS_RIGHT = NAME_RIGHT.apply("humerus");
    private static final String ULNA_LEFT = NAME_LEFT.apply("ulna");
    private static final String ULNA_RIGHT = NAME_RIGHT.apply("ulna");
    private static final String CARPALS_LEFT = NAME_LEFT.apply("carpals");
    private static final String CARPALS_RIGHT = NAME_RIGHT.apply("carpals");
    private static final String FEATHERS_CORACOID_LEFT = FEATHERS.apply(CORACOID_LEFT);
    private static final String FEATHERS_CORACOID_RIGHT = FEATHERS.apply(CORACOID_RIGHT);
    private static final String FEATHERS_TERTIARY_LEFT = FEATHERS.apply(NAME_LEFT.apply("tertiary"));
    private static final String FEATHERS_TERTIARY_RIGHT = FEATHERS.apply(NAME_RIGHT.apply("tertiary"));
    private static final String FEATHERS_SECONDARY_LEFT = FEATHERS.apply(NAME_LEFT.apply("secondary"));
    private static final String FEATHERS_SECONDARY_RIGHT = FEATHERS.apply(NAME_RIGHT.apply("secondary"));
    private static final String FEATHERS_PRIMARY_LEFT = FEATHERS.apply(NAME_LEFT.apply("primary"));
    private static final String FEATHERS_PRIMARY_RIGHT = FEATHERS.apply(NAME_RIGHT.apply("primary"));
    private final ImmutableList<ModelPart> bonesLeft;
    private final ImmutableList<ModelPart> bonesRight;
    private final ImmutableList<ModelPart> feathersLeft;
    private final ImmutableList<ModelPart> feathersRight;

    public ModelWingsAvian(ModelPart root) {
        this.root = root;
        ModelPart coracoidLeft = root.m_171324_(CORACOID_LEFT);
        ModelPart coracoidRight = root.m_171324_(CORACOID_RIGHT);
        ModelPart humerusLeft = coracoidLeft.m_171324_(HUMERUS_LEFT);
        ModelPart humerusRight = coracoidRight.m_171324_(HUMERUS_RIGHT);
        ModelPart ulnaLeft = humerusLeft.m_171324_(ULNA_LEFT);
        ModelPart ulnaRight = humerusRight.m_171324_(ULNA_RIGHT);
        ModelPart carpalsLeft = ulnaLeft.m_171324_(CARPALS_LEFT);
        ModelPart carpalsRight = ulnaRight.m_171324_(CARPALS_RIGHT);
        ModelPart feathersCoracoidLeft = coracoidLeft.m_171324_(FEATHERS_CORACOID_LEFT);
        ModelWingsAvian.add3DTexture(feathersCoracoidLeft, 6, 40, 0.0f, 0.0f, -1.0f, 6, 8);
        ModelPart feathersCoracoidRight = coracoidRight.m_171324_(FEATHERS_CORACOID_RIGHT);
        ModelWingsAvian.add3DTexture(feathersCoracoidRight, 0, 40, -6.0f, 0.0f, -1.0f, 6, 8);
        ModelPart feathersTertiaryLeft = humerusLeft.m_171324_(FEATHERS_TERTIARY_LEFT);
        ModelWingsAvian.add3DTexture(feathersTertiaryLeft, 10, 14, 0.0f, 0.0f, -0.5f, 10, 14);
        ModelPart feathersTertiaryRight = humerusRight.m_171324_(FEATHERS_TERTIARY_RIGHT);
        ModelWingsAvian.add3DTexture(feathersTertiaryRight, 0, 14, -10.0f, 0.0f, -0.5f, 10, 14);
        ModelPart feathersSecondaryLeft = ulnaLeft.m_171324_(FEATHERS_SECONDARY_LEFT);
        ModelWingsAvian.add3DTexture(feathersSecondaryLeft, 31, 14, -2.0f, 0.0f, -0.5f, 11, 12);
        ModelPart feathersSecondaryRight = ulnaRight.m_171324_(FEATHERS_SECONDARY_RIGHT);
        ModelWingsAvian.add3DTexture(feathersSecondaryRight, 20, 14, -9.0f, 0.0f, -0.5f, 11, 12);
        ModelPart feathersPrimaryLeft = carpalsLeft.m_171324_(FEATHERS_PRIMARY_LEFT);
        ModelWingsAvian.add3DTexture(feathersPrimaryLeft, 53, 14, 0.0f, -2.1f, -0.5f, 11, 11);
        ModelPart feathersPrimaryRight = carpalsRight.m_171324_(FEATHERS_PRIMARY_RIGHT);
        ModelWingsAvian.add3DTexture(feathersPrimaryRight, 42, 14, -11.0f, -2.1f, -0.5f, 11, 11);
        this.bonesLeft = ImmutableList.of((Object)coracoidLeft, (Object)humerusLeft, (Object)ulnaLeft, (Object)carpalsLeft);
        this.bonesRight = ImmutableList.of((Object)coracoidRight, (Object)humerusRight, (Object)ulnaRight, (Object)carpalsRight);
        this.feathersLeft = ImmutableList.of((Object)feathersCoracoidLeft, (Object)feathersTertiaryLeft, (Object)feathersSecondaryLeft, (Object)feathersPrimaryLeft);
        this.feathersRight = ImmutableList.of((Object)feathersCoracoidRight, (Object)feathersTertiaryRight, (Object)feathersSecondaryRight, (Object)feathersPrimaryRight);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition coracoidLeft = partDefinition.m_171599_(CORACOID_LEFT, CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(0.0f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)5.5f, (float)2.5f));
        PartDefinition coracoidRight = partDefinition.m_171599_(CORACOID_RIGHT, CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(-5.0f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)5.5f, (float)2.5f));
        PartDefinition humerusLeft = coracoidLeft.m_171599_(HUMERUS_LEFT, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.1f, -1.1f, -2.0f, 7.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.7f, (float)-0.6f, (float)0.1f));
        PartDefinition humerusRight = coracoidRight.m_171599_(HUMERUS_RIGHT, CubeListBuilder.m_171558_().m_171514_(0, 7).m_171488_(-6.9f, -1.1f, -2.0f, 7.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.7f, (float)-0.6f, (float)0.1f));
        PartDefinition ulnaLeft = humerusLeft.m_171599_(ULNA_LEFT, CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(0.0f, -1.5f, -1.5f, 9.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.5f, (float)0.2f, (float)0.1f));
        PartDefinition ulnaRight = humerusRight.m_171599_(ULNA_RIGHT, CubeListBuilder.m_171558_().m_171514_(22, 6).m_171488_(-9.0f, -1.5f, -1.5f, 9.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.5f, (float)0.2f, (float)0.1f));
        PartDefinition carpalsLeft = ulnaLeft.m_171599_(CARPALS_LEFT, CubeListBuilder.m_171558_().m_171514_(46, 0).m_171488_(0.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.5f, (float)0.0f, (float)0.0f));
        PartDefinition carpalsRight = ulnaRight.m_171599_(CARPALS_RIGHT, CubeListBuilder.m_171558_().m_171514_(46, 4).m_171488_(-5.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-8.5f, (float)0.0f, (float)0.0f));
        PartDefinition feathersCoracoidLeft = coracoidLeft.m_171599_(FEATHERS_CORACOID_LEFT, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.4f, (float)0.0f, (float)1.0f));
        PartDefinition feathersCoracoidRight = coracoidRight.m_171599_(FEATHERS_CORACOID_RIGHT, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.4f, (float)0.0f, (float)1.0f));
        PartDefinition feathersTretiaryLeft = humerusLeft.m_171599_(FEATHERS_TERTIARY_LEFT, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)1.0f));
        PartDefinition feathersTretiaryRight = humerusRight.m_171599_(FEATHERS_TERTIARY_RIGHT, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)1.0f));
        PartDefinition feathersSecondaryLeft = ulnaLeft.m_171599_(FEATHERS_SECONDARY_LEFT, CubeListBuilder.m_171558_().m_171514_(22, 12).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition feathersSecondaryRight = ulnaRight.m_171599_(FEATHERS_SECONDARY_RIGHT, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition feathersPrimaryLeft = carpalsLeft.m_171599_(FEATHERS_PRIMARY_LEFT, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition feathersPrimaryRight = carpalsRight.m_171599_(FEATHERS_PRIMARY_RIGHT, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    @Override
    public void render(AnimatorAvian animator, float delta, PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        ModelPart right;
        ModelPart left;
        int i;
        for (i = 0; i < this.bonesLeft.size(); ++i) {
            left = (ModelPart)this.bonesLeft.get(i);
            right = (ModelPart)this.bonesRight.get(i);
            ModelWingsAvian.setAngles(left, right, animator.getWingRotation(i, delta));
        }
        for (i = 0; i < this.feathersLeft.size(); ++i) {
            left = (ModelPart)this.feathersLeft.get(i);
            right = (ModelPart)this.feathersRight.get(i);
            ModelWingsAvian.setAngles(left, right, animator.getFeatherRotation(i, delta));
        }
        this.root.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    private static void add3DTexture(ModelPart model, int u, int v, float offX, float offY, float offZ, int width, int height) {
        List cubes = model.f_104212_;
        ArrayList<Model3DTexture> newList = new ArrayList<Model3DTexture>(cubes);
        newList.add(Model3DTexture.create(offX, offY, offZ, width, height, u, v, 64, 64));
        model.f_104212_ = newList;
    }
}

