/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.apparatus;

import java.util.Objects;
import me.paulf.wings.server.apparatus.FlightApparatus;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.item.WingSettings;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public final class SimpleFlightApparatus
implements FlightApparatus {
    private final WingSettings settings;

    public SimpleFlightApparatus(WingSettings settings) {
        this.settings = Objects.requireNonNull(settings);
    }

    @Override
    public void onFlight(Player player, Vec3 direction) {
        int distance = Math.round((float)direction.m_82553_() * 100.0f);
        if (distance > 0) {
            player.m_36399_((float)distance * this.settings.getFlyingExertion());
        }
    }

    @Override
    public void onLanding(Player player, Vec3 direction) {
        player.m_36399_(this.settings.getLandingExertion());
    }

    @Override
    public boolean isUsable(Player player) {
        return player.m_36324_().m_38702_() >= this.settings.getRequiredFlightSatiation();
    }

    @Override
    public boolean isLandable(Player player) {
        return player.m_36324_().m_38702_() >= this.settings.getRequiredLandSatiation();
    }

    @Override
    public FlightApparatus.FlightState createState(Flight flight) {
        return player -> {};
    }
}

