/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.asm;

import me.paulf.wings.server.asm.GetCameraEyeHeightEvent;
import me.paulf.wings.server.asm.GetLivingHeadLimitEvent;
import me.paulf.wings.server.asm.PlayerFlightCheckEvent;
import me.paulf.wings.server.asm.PlayerFlownEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public final class WingsHooks {
    private WingsHooks() {
    }

    public static boolean onFlightCheck(LivingEntity living, boolean defaultValue) {
        Player player;
        return living instanceof Player && WingsHooks.onFlightCheck(player = (Player)living, defaultValue);
    }

    public static boolean onFlightCheck(Player player, boolean defaultValue) {
        if (defaultValue) {
            return true;
        }
        PlayerFlightCheckEvent ev = new PlayerFlightCheckEvent(player);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        return ev.isFlying();
    }

    public static float onGetCameraEyeHeight(Entity entity, float eyeHeight) {
        GetCameraEyeHeightEvent ev = GetCameraEyeHeightEvent.create(entity, eyeHeight);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        return ev.getValue();
    }

    public static boolean onUpdateBodyRotation(LivingEntity living, float movementYaw) {
        GetLivingHeadLimitEvent ev = GetLivingHeadLimitEvent.create(living);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        if (ev.isVanilla()) {
            return false;
        }
        living.f_20883_ += Mth.m_14177_((float)(movementYaw - living.f_20883_)) * 0.3f;
        float hLimit = ev.getHardLimit();
        float sLimit = ev.getSoftLimit();
        float theta = Mth.m_14036_((float)Mth.m_14177_((float)(living.m_146908_() - living.f_20883_)), (float)(-hLimit), (float)hLimit);
        living.f_20883_ = living.m_146908_() - theta;
        if (theta * theta > sLimit * sLimit) {
            living.f_20883_ += theta * 0.2f;
        }
        return true;
    }

    public static void onAddFlown(Player player, double x, double y, double z) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerFlownEvent(player, new Vec3(x, y, z)));
    }

    public static boolean onReplaceItemSlotCheck(Item item, ItemStack stack) {
        return item instanceof ElytraItem || item.getEquipmentSlot(stack) != null;
    }
}

