/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.config;

import me.paulf.wings.server.item.ImmutableWingSettings;
import me.paulf.wings.server.item.WingSettings;
import net.minecraft.resources.ResourceLocation;

public final class ConfigWingSettings
implements WingSettings {
    private final ResourceLocation key;
    @Deprecated
    public int requiredFlightSatiation;
    @Deprecated
    public double flyingExertion;
    @Deprecated
    public int requiredLandSatiation;
    @Deprecated
    public double landingExertion;

    ConfigWingSettings(ResourceLocation key) {
        this(key, 5, 1.0E-4, 2, 0.005);
    }

    private ConfigWingSettings(ResourceLocation key, int requiredFlightSatiation, double flyingExertion, int requiredLandSatiation, double landingExertion) {
        this.key = key;
        this.requiredFlightSatiation = requiredFlightSatiation;
        this.flyingExertion = flyingExertion;
        this.requiredLandSatiation = requiredLandSatiation;
        this.landingExertion = landingExertion;
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    @Override
    public int getRequiredFlightSatiation() {
        return this.requiredFlightSatiation;
    }

    @Override
    public float getFlyingExertion() {
        return (float)this.flyingExertion;
    }

    @Override
    public int getRequiredLandSatiation() {
        return this.requiredLandSatiation;
    }

    @Override
    public float getLandingExertion() {
        return (float)this.landingExertion;
    }

    public WingSettings toImmutable() {
        return ImmutableWingSettings.of(this.getRequiredFlightSatiation(), this.getFlyingExertion(), this.getRequiredLandSatiation(), this.getLandingExertion());
    }
}

