/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.dreamcatcher;

import me.paulf.wings.server.dreamcatcher.InSomniable;
import me.paulf.wings.util.CapabilityHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wings")
public final class InSomniableCapability {
    private static final CapabilityHolder<Player, InSomniable, CapabilityHolder.State<Player, InSomniable>> INSOMNIABLE = CapabilityHolder.create();
    public static final Capability<InSomniable> CAP_INSOMNIABLE = InSomniableCapability.injectInSomniable();

    private InSomniableCapability() {
    }

    public static LazyOptional<InSomniable> getInSomniable(Player player) {
        return INSOMNIABLE.state().get(player, null);
    }

    static Capability<InSomniable> injectInSomniable() {
        Capability cap = CapabilityManager.get((CapabilityToken)new CapabilityToken<InSomniable>(){});
        INSOMNIABLE.inject((Capability<InSomniable>)cap);
        return cap;
    }

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Player) {
            event.addCapability(new ResourceLocation("wings", "insomniable"), INSOMNIABLE.state().providerBuilder(new InSomniable()).serializedBy(new InSomniable.Serializer()).build());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        InSomniableCapability.getInSomniable(event.getOriginal()).ifPresent(oldInstance -> InSomniableCapability.getInSomniable(event.getEntity()).ifPresent(newInstance -> newInstance.clone((InSomniable)oldInstance)));
    }
}

