/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.flight;

import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.paulf.wings.WingsMod;
import me.paulf.wings.server.flight.AttachFlightCapabilityEvent;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.flight.FlightDefault;
import me.paulf.wings.util.CapabilityHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wings")
public final class Flights {
    private static final CapabilityHolder<Player, Flight, CapabilityHolder.State<Player, Flight>> HOLDER = CapabilityHolder.create();
    public static final Capability<Flight> CAP_FLIGHT = Flights.injectFlights();

    private Flights() {
    }

    public static boolean has(Player player) {
        return HOLDER.state().has(player, null);
    }

    public static LazyOptional<Flight> get(Player player) {
        return HOLDER.state().get(player, null);
    }

    public static Capability<Flight> injectFlights() {
        Capability cap = CapabilityManager.get((CapabilityToken)new CapabilityToken<Flight>(){});
        HOLDER.inject((Capability<Flight>)cap);
        return cap;
    }

    public static void ifPlayer(Entity entity, BiConsumer<Player, Flight> action) {
        Flights.ifPlayer(entity, e -> true, action);
    }

    public static void ifPlayer(Entity entity, Predicate<Player> condition, BiConsumer<Player, Flight> action) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Flights.get(player).filter(f -> condition.test(player)).ifPresent(f -> action.accept(player, (Flight)f));
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Player) {
            Supplier<FlightDefault> factory = () -> {
                FlightDefault flight = new FlightDefault();
                WingsMod.instance().addFlightListeners((Player)entity, flight);
                return flight;
            };
            FlightDefault flight = factory.get();
            event.addCapability(new ResourceLocation("wings", "flight"), HOLDER.state().providerBuilder(flight).serializedBy(new FlightDefault.Serializer(factory)).build());
            MinecraftForge.EVENT_BUS.post((Event)AttachFlightCapabilityEvent.create(event, flight));
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            Flights.get(event.getOriginal()).ifPresent(oldInstance -> Flights.get(event.getEntity()).ifPresent(newInstance -> newInstance.clone((Flight)oldInstance)));
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Flights.get(event.getEntity()).ifPresent(flight -> flight.sync(Flight.PlayerSet.ofSelf()));
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Flights.get(event.getEntity()).ifPresent(flight -> flight.sync(Flight.PlayerSet.ofSelf()));
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Flights.get(event.getEntity()).ifPresent(flight -> flight.sync(Flight.PlayerSet.ofSelf()));
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        Flights.ifPlayer(event.getTarget(), (player, flight) -> flight.sync(Flight.PlayerSet.ofPlayer((ServerPlayer)event.getEntity())));
    }
}

