/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.item;

import java.util.function.Supplier;
import me.paulf.wings.server.apparatus.FlightApparatus;
import me.paulf.wings.server.effect.WingsEffects;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.flight.Flights;
import me.paulf.wings.server.sound.WingsSounds;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WingsBottleItem
extends Item {
    private final Supplier<FlightApparatus> wings;

    public WingsBottleItem(Item.Properties properties, Supplier<FlightApparatus> wings) {
        super(properties);
        this.wings = wings;
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity living) {
        ServerPlayer player;
        if (living instanceof ServerPlayer) {
            player = (ServerPlayer)living;
            CriteriaTriggers.f_10592_.m_23682_(player, stack);
            WingsBottleItem.giveWing(player, this.wings.get());
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)WingsSounds.ITEM_ARMOR_EQUIP_WINGS.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (living instanceof Player) {
            player = (Player)living;
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        }
        if (stack.m_41619_()) {
            return new ItemStack((ItemLike)Items.f_42590_);
        }
        if (living instanceof Player) {
            player = (Player)living;
            if (!player.m_150110_().f_35937_) {
                ItemStack emptyBottle = new ItemStack((ItemLike)Items.f_42590_);
                if (!player.m_150109_().m_36054_(emptyBottle)) {
                    player.m_36176_(emptyBottle, false);
                }
            }
        }
        return stack;
    }

    public static boolean giveWing(ServerPlayer player, FlightApparatus wings) {
        boolean changed = Flights.get((Player)player).filter(flight -> {
            if (flight.getWing() != wings) {
                flight.setWing(wings, Flight.PlayerSet.ofAll());
                return true;
            }
            return false;
        }).isPresent();
        player.m_7292_(new MobEffectInstance((MobEffect)WingsEffects.WINGS.get(), Integer.MAX_VALUE, 0, true, false));
        return changed;
    }

    public int m_8105_(ItemStack stack) {
        return 40;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        return ItemUtils.m_150959_((Level)world, (Player)player, (InteractionHand)hand);
    }
}

