/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.util;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.paulf.wings.util.CapabilityProviders;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public final class CapabilityHolder<T extends ICapabilityProvider, R, S extends State<T, R>> {
    private final Function<Capability<R>, S> presence;
    private S state;

    private CapabilityHolder(Function<Capability<R>, S> presence, S state) {
        this.presence = presence;
        this.state = state;
    }

    public S state() {
        return this.state;
    }

    public void inject(Capability<R> capability) {
        this.state = (State)this.presence.apply(capability);
    }

    public static <T extends ICapabilityProvider, R> CapabilityHolder<T, R, State<T, R>> create() {
        return CapabilityHolder.create(SimpleAbsentState::new, SimplePresentState::new);
    }

    public static <T extends ICapabilityProvider, R, S extends State<T, R>> CapabilityHolder<T, R, S> create(Supplier<S> absence, Function<Capability<R>, S> presence) {
        return new CapabilityHolder<T, R, State>(presence, (State)absence.get());
    }

    public static interface State<T extends ICapabilityProvider, R> {
        default public boolean has(T provider, @Nullable Direction side) {
            return this.get(provider, side).isPresent();
        }

        public LazyOptional<R> get(T var1, @Nullable Direction var2);

        public <U extends R> CapabilityProviders.NonSerializingSingleBuilder<U> providerBuilder(U var1);
    }

    private static final class SimplePresentState<T extends ICapabilityProvider, R>
    extends PresentState<T, R> {
        private SimplePresentState(Capability<R> capability) {
            super(capability);
        }
    }

    private static final class SimpleAbsentState<T extends ICapabilityProvider, R>
    extends AbsentState<T, R> {
        private SimpleAbsentState() {
        }
    }

    public static abstract class PresentState<T extends ICapabilityProvider, R>
    implements State<T, R> {
        protected final Capability<R> capability;

        protected PresentState(Capability<R> capability) {
            this.capability = capability;
        }

        @Override
        public final LazyOptional<R> get(T provider, @Nullable Direction side) {
            return provider.getCapability(this.capability, side);
        }

        @Override
        public final <U extends R> CapabilityProviders.NonSerializingSingleBuilder<U> providerBuilder(U instance) {
            return CapabilityProviders.builder(this.capability, instance);
        }
    }

    public static abstract class AbsentState<T extends ICapabilityProvider, R>
    implements State<T, R> {
        @Override
        public final boolean has(T provider, @Nullable Direction side) {
            return false;
        }

        @Override
        public final LazyOptional<R> get(T provider, @Nullable Direction side) {
            return LazyOptional.empty();
        }

        @Override
        public final <U extends R> CapabilityProviders.NonSerializingSingleBuilder<U> providerBuilder(U instance) {
            return CapabilityProviders.emptyBuilder();
        }
    }
}

