/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.paulf.wings.util.NBTSerializer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public final class CapabilityProviders {
    private CapabilityProviders() {
    }

    public static ICapabilityProvider empty() {
        return EmptyProvider.INSTANCE;
    }

    public static <T> NonSerializingSingleBuilder<T> emptyBuilder() {
        return EmptySingleBuilder.INSTANCE;
    }

    public static <T> NonSerializingSingleBuilder<T> builder(Capability<? super T> capability, T instance) {
        return new NonSerializingSingleBuilderImpl<T>(capability, instance);
    }

    public static CompositeBuilder builder() {
        return new CompositeBuilderImpl();
    }

    private static final class EmptyProvider
    implements ICapabilityProvider {
        private static final EmptyProvider INSTANCE = new EmptyProvider();

        private EmptyProvider() {
        }

        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            return LazyOptional.empty();
        }
    }

    private static final class EmptySingleBuilder<T>
    implements NonSerializingSingleBuilder<T> {
        private static final EmptySingleBuilder<?> INSTANCE = new EmptySingleBuilder();

        private EmptySingleBuilder() {
        }

        @Override
        public <N extends Tag> SingleBuilder<T> serializedBy(NBTSerializer<T, N> serializer) {
            return this;
        }

        @Override
        public SingleBuilder<T> peek(Consumer<T> consumer) {
            return this;
        }

        @Override
        public ICapabilityProvider build() {
            return CapabilityProviders.empty();
        }
    }

    private static final class NonSerializingSingleBuilderImpl<T>
    extends AbstractSingleBuilder<T>
    implements NonSerializingSingleBuilder<T> {
        private NonSerializingSingleBuilderImpl(Capability<? super T> capability, T instance) {
            super(capability, instance);
        }

        public <N extends Tag> SerializingSingleBuilderImpl<T, N> serializedBy(NBTSerializer<T, N> serializer) {
            return new SerializingSingleBuilderImpl<Object, N>(this.capability, this.instance, serializer);
        }

        @Override
        public NonSerializingSingleBuilder<T> peek(Consumer<T> consumer) {
            consumer.accept(this.instance);
            return this;
        }

        @Override
        public ICapabilityProvider build() {
            return new SimpleSingleProvider<Object>(this.capability, this.instance);
        }
    }

    private static final class CompositeBuilderImpl
    implements CompositeBuilder {
        private final ImmutableList.Builder<ICapabilityProvider> providers;

        private CompositeBuilderImpl() {
            this((ImmutableList.Builder<ICapabilityProvider>)ImmutableList.builder());
        }

        private CompositeBuilderImpl(ImmutableList.Builder<ICapabilityProvider> providers) {
            this.providers = providers;
        }

        @Override
        public CompositeBuilder add(ICapabilityProvider provider) {
            this.providers.add((Object)provider);
            return this;
        }

        @Override
        public ICapabilityProvider build() {
            ImmutableList providers = this.providers.build();
            return switch (providers.size()) {
                case 0 -> CapabilityProviders.empty();
                case 1 -> (ICapabilityProvider)Iterables.getOnlyElement((Iterable)providers);
                default -> new CompositeProvider((ImmutableList<ICapabilityProvider>)providers);
            };
        }
    }

    private static final class SerializingSingleBuilderImpl<T, N extends Tag>
    extends AbstractSingleBuilder<T>
    implements SingleBuilder<T> {
        private final NBTSerializer<T, N> serializer;

        private SerializingSingleBuilderImpl(Capability<? super T> capability, T instance, NBTSerializer<T, N> serializer) {
            super(capability, instance);
            this.serializer = serializer;
        }

        public SerializingSingleBuilderImpl<T, N> peek(Consumer<T> consumer) {
            consumer.accept(this.instance);
            return this;
        }

        @Override
        public ICapabilityProvider build() {
            return new SerializingSingleProvider<Object, N>(this.capability, this.instance, this.serializer);
        }
    }

    public static interface NonSerializingSingleBuilder<T>
    extends SingleBuilder<T> {
        public <N extends Tag> SingleBuilder<T> serializedBy(NBTSerializer<T, N> var1);
    }

    public static interface SingleBuilder<T> {
        public SingleBuilder<T> peek(Consumer<T> var1);

        public ICapabilityProvider build();
    }

    private static abstract class AbstractSingleBuilder<T>
    implements SingleBuilder<T> {
        final Capability<? super T> capability;
        final T instance;

        AbstractSingleBuilder(Capability<? super T> capability, T instance) {
            this.capability = capability;
            this.instance = instance;
        }
    }

    private static final class SerializingSingleProvider<T, N extends Tag>
    extends SingleProvider<T>
    implements INBTSerializable<N> {
        final NBTSerializer<T, N> serializer;

        private SerializingSingleProvider(Capability<? super T> capability, T instance, NBTSerializer<T, N> serializer) {
            super(capability, instance);
            this.serializer = serializer;
        }

        public N serializeNBT() {
            return this.serializer.serialize(this.instance);
        }

        public void deserializeNBT(N compound) {
            this.instance = this.serializer.deserialize(compound);
        }
    }

    private static final class SimpleSingleProvider<T>
    extends SingleProvider<T> {
        private SimpleSingleProvider(Capability<T> capability, T instance) {
            super(capability, instance);
        }
    }

    private static abstract class SingleProvider<T>
    implements ICapabilityProvider {
        final Capability<? super T> capability;
        T instance;
        LazyOptional<T> lazy;

        private SingleProvider(Capability<? super T> capability, T instance) {
            this.capability = capability;
            this.instance = instance;
            this.lazy = LazyOptional.of(() -> this.instance);
        }

        public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> capability, @Nullable Direction facing) {
            return this.capability == capability ? this.lazy.cast() : LazyOptional.empty();
        }
    }

    private static final class CompositeProvider
    implements ICapabilityProvider {
        private final ImmutableList<ICapabilityProvider> providers;

        private CompositeProvider(ImmutableList<ICapabilityProvider> providers) {
            this.providers = providers;
        }

        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            for (ICapabilityProvider provider : this.providers) {
                LazyOptional instance = provider.getCapability(capability, facing);
                if (!instance.isPresent()) continue;
                return instance;
            }
            return LazyOptional.empty();
        }
    }

    public static interface CompositeBuilder {
        public CompositeBuilder add(ICapabilityProvider var1);

        public ICapabilityProvider build();
    }
}

