/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.util;

public final class Mth {
    public static final float PI = (float)Math.PI;
    public static final float TAU = (float)Math.PI * 2;
    private static final float DEG_TO_RAD = (float)Math.PI / 180;
    private static final float RAD_TO_DEG = 57.29578f;

    private Mth() {
    }

    public static float toRadians(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public static float toDegrees(float degrees) {
        return degrees * 57.29578f;
    }

    public static float lerp(float a, float b, float t) {
        return t <= 0.0f ? a : (t >= 1.0f ? b : a + (b - a) * t);
    }

    public static float lerpDegrees(float a, float b, float t) {
        return a + t * Mth.getDifference(a, b, 360.0f);
    }

    public static double lerpDegrees(double a, double b, double t) {
        return a + t * Mth.getDifference(a, b, 360.0);
    }

    private static float getDifference(float a, float b, float rot) {
        return Mth.mod(b - a + rot / 2.0f, rot) - rot / 2.0f;
    }

    private static double getDifference(double a, double b, double rot) {
        return Mth.mod(b - a + rot / 2.0, rot) - rot / 2.0;
    }

    public static int mod(int a, int b) {
        return (a % b + b) % b;
    }

    public static float mod(float a, float b) {
        return (a % b + b) % b;
    }

    public static double mod(double a, double b) {
        return (a % b + b) % b;
    }

    public static float easeInOut(float t) {
        return -(net.minecraft.util.Mth.m_14089_((float)((float)Math.PI * t)) - 1.0f) / 2.0f;
    }

    public static float easeOutCirc(float t) {
        return net.minecraft.util.Mth.m_14116_((float)(1.0f - (t - 1.0f) * (t - 1.0f)));
    }

    public static float transform(float x, float domainMin, float domainMax, float rangeMin, float rangeMax) {
        if (x <= domainMin) {
            return rangeMin;
        }
        if (x >= domainMax) {
            return rangeMax;
        }
        return (rangeMax - rangeMin) * (x - domainMin) / (domainMax - domainMin) + rangeMin;
    }
}

