/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.util;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class Util {
    private static final Converter<String, String> UNDERSCORE_TO_CAMEL = CaseFormat.LOWER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL);

    private Util() {
    }

    public static String underScoreToCamel(String value) {
        return (String)UNDERSCORE_TO_CAMEL.convert((Object)value);
    }

    public static ResourceLocation getName(RegistryObject<?> entry) {
        ResourceLocation name = entry.getId();
        if (name == null) {
            throw new NullPointerException("Missing registry name: " + entry);
        }
        return name;
    }

    private static <V extends RegistryObject<V>> V require(IForgeRegistry<V> registry, ResourceLocation id) {
        RegistryObject v;
        RegistryObject registryObject = v = registry.containsKey(id) ? (RegistryObject)registry.getValue(id) : null;
        if (v == null) {
            throw new IllegalStateException("Missing registry object: " + id);
        }
        return (V)v;
    }
}

