/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.wraithon.entity.wraithon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.collider.OBBCollider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class EntityOBBCollider
extends OBBCollider {
    protected EntityOBBCollider(AABB outerAABB, double posX, double posY, double posZ, double center_x, double center_y, double center_z) {
        super(outerAABB, posX, posY, posZ, center_x, center_y, center_z);
    }

    public EntityOBBCollider(AABB entityCallAABB, double pos1_x, double pos1_y, double pos1_z, double pos2_x, double pos2_y, double pos2_z, double norm1_x, double norm1_y, double norm1_z, double norm2_x, double norm2_y, double norm2_z, double center_x, double center_y, double center_z) {
        super(entityCallAABB, pos1_x, pos1_y, pos1_z, pos2_x, pos2_y, pos2_z, norm1_x, norm1_y, norm1_z, norm2_x, norm2_y, norm2_z, center_x, center_y, center_z);
    }

    public EntityOBBCollider(AABB aabbCopy) {
        super(aabbCopy);
    }

    public EntityOBBCollider(double posX, double posY, double posZ, double center_x, double center_y, double center_z) {
        super(posX, posY, posZ, center_x, center_y, center_z);
    }

    public void updateOBBCollider(LivingEntityPatch<?> entitypatch, DynamicAnimation attackAnimation, float prevElapsedTime, float elapsedTime, Joint joint, float attackSpeed) {
        OpenMatrix4f transformMatrix;
        Armature armature = entitypatch.getArmature();
        if (armature.rootJoint.equals((Object)joint)) {
            Pose rootPose = new Pose();
            rootPose.putJointData("Root", JointTransform.empty());
            attackAnimation.modifyPose(attackAnimation, rootPose, entitypatch, elapsedTime, 1.0f);
            transformMatrix = rootPose.orElseEmpty("Root").getAnimationBoundMatrix(armature.rootJoint, new OpenMatrix4f()).removeTranslation();
        } else {
            transformMatrix = armature.getBoundTransformFor(attackAnimation.getPoseByTime(entitypatch, elapsedTime, 1.0f), joint);
        }
        OpenMatrix4f toWorldCoord = OpenMatrix4f.createTranslation((float)(-((float)((LivingEntity)entitypatch.getOriginal()).m_20185_())), (float)((float)((LivingEntity)entitypatch.getOriginal()).m_20186_()), (float)(-((float)((LivingEntity)entitypatch.getOriginal()).m_20189_())));
        transformMatrix.mulFront(toWorldCoord.mulBack(entitypatch.getModelMatrix(1.0f)));
        this.transform(transformMatrix);
    }

    public void transform(OpenMatrix4f modelMatrix) {
        int i;
        OpenMatrix4f noTranslation = modelMatrix.removeTranslation();
        for (i = 0; i < this.modelVertices.length; ++i) {
            this.rotatedVertices[i] = OpenMatrix4f.transform((OpenMatrix4f)noTranslation, (Vec3)this.modelVertices[i]);
        }
        for (i = 0; i < this.modelNormals.length; ++i) {
            this.rotatedNormals[i] = OpenMatrix4f.transform((OpenMatrix4f)noTranslation, (Vec3)this.modelNormals[i]);
        }
        this.scale = noTranslation.toScaleVector();
        super.transform(modelMatrix);
    }

    protected AABB getHitboxAABB() {
        return this.outerAABB.m_82377_((this.outerAABB.f_82291_ - this.outerAABB.f_82288_) * (double)this.scale.x, (this.outerAABB.f_82292_ - this.outerAABB.f_82289_) * (double)this.scale.y, (this.outerAABB.f_82293_ - this.outerAABB.f_82290_) * (double)this.scale.z).m_82386_(-this.worldCenter.f_82479_, this.worldCenter.f_82480_, -this.worldCenter.f_82481_);
    }

    public boolean isCollide(Entity entity) {
        OBBCollider obb = new OBBCollider(entity.m_20191_());
        return this.isCollide(obb);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(PoseStack poseStack, MultiBufferSource buffer, LivingEntityPatch<?> entitypatch, StaticAnimation animation, Joint joint, float prevElapsedTime, float elapsedTime, float partialTicks, float attackSpeed) {
        Pose currentPose;
        Pose prevPose;
        boolean attacking;
        Armature armature = entitypatch.getArmature();
        EntityState state = animation.getState(entitypatch, elapsedTime);
        EntityState prevState = animation.getState(entitypatch, prevElapsedTime);
        boolean bl = attacking = prevState.attacking() || state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2;
        if (joint.getName().equals(armature.rootJoint.getName())) {
            prevPose = new Pose();
            currentPose = new Pose();
            prevPose.putJointData("Root", JointTransform.empty());
            currentPose.putJointData("Root", JointTransform.empty());
            animation.modifyPose((DynamicAnimation)animation, prevPose, entitypatch, prevElapsedTime, 0.0f);
            animation.modifyPose((DynamicAnimation)animation, currentPose, entitypatch, elapsedTime, 1.0f);
        } else {
            prevPose = animation.getPoseByTime(entitypatch, prevElapsedTime, 0.0f);
            currentPose = animation.getPoseByTime(entitypatch, elapsedTime, 1.0f);
        }
        this.drawInternal(poseStack, buffer.m_6299_(this.getRenderType()), armature, joint, prevPose, currentPose, partialTicks, attacking ? -65536 : -1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInternal(PoseStack poseStack, VertexConsumer vertexConsumer, Armature armature, Joint joint, Pose pose1, Pose pose2, float partialTicks, int color) {
        OpenMatrix4f poseMatrix;
        Pose interpolatedPose = Pose.interpolatePose((Pose)pose1, (Pose)pose2, (float)partialTicks);
        color = -1;
        if (armature.rootJoint.equals((Object)joint)) {
            JointTransform jt = interpolatedPose.orElseEmpty("Root");
            jt.rotation().x = 0.0f;
            jt.rotation().y = 0.0f;
            jt.rotation().z = 0.0f;
            jt.rotation().w = 1.0f;
            poseMatrix = jt.getAnimationBoundMatrix(armature.rootJoint, new OpenMatrix4f()).removeTranslation();
        } else {
            poseMatrix = armature.getBoundTransformFor(interpolatedPose, joint);
        }
        poseStack.m_85836_();
        MathUtils.mulStack((PoseStack)poseStack, (OpenMatrix4f)poseMatrix);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Vec3 vec = this.modelVertices[1];
        float maxX = (float)(this.modelCenter.f_82479_ + vec.f_82479_);
        float maxY = (float)(this.modelCenter.f_82480_ + vec.f_82480_);
        float maxZ = (float)(this.modelCenter.f_82481_ + vec.f_82481_);
        float minX = (float)(this.modelCenter.f_82479_ - vec.f_82479_);
        float minY = (float)(this.modelCenter.f_82480_ - vec.f_82480_);
        float minZ = (float)(this.modelCenter.f_82481_ - vec.f_82481_);
        vertexConsumer.m_252986_(matrix, minX, maxY, minZ).m_193479_(color).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, minX, maxY, maxZ).m_193479_(color).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, minX, maxY, maxZ).m_193479_(color).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, maxX, maxY, maxZ).m_193479_(color).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, maxX, maxY, maxZ).m_193479_(color).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, maxX, maxY, minZ).m_193479_(color).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, maxX, maxY, minZ).m_193479_(color).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, minX, maxY, minZ).m_193479_(color).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, maxX, maxY, maxZ).m_193479_(color).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, maxX, minY, maxZ).m_193479_(color).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, minX, maxY, maxZ).m_193479_(color).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, minX, minY, maxZ).m_193479_(color).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, maxX, maxY, minZ).m_193479_(color).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, maxX, minY, minZ).m_193479_(color).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, minX, maxY, minZ).m_193479_(color).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, minX, minY, minZ).m_193479_(color).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, minX, minY, minZ).m_193479_(color).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, minX, minY, maxZ).m_193479_(color).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, minX, minY, maxZ).m_193479_(color).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, maxX, minY, maxZ).m_193479_(color).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, maxX, minY, maxZ).m_193479_(color).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, maxX, minY, minZ).m_193479_(color).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, maxX, minY, minZ).m_193479_(color).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, minX, minY, minZ).m_193479_(color).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }
}

