/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.wraithon.entity.wraithon.container;

import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import org.jetbrains.annotations.Nullable;
import org.merlin204.wraithon.entity.wraithon.WraithonEntity;

public class DamageContainer {
    private final WraithonEntity wraithon;
    @Nullable
    private TagKey<DamageType> tagKey;
    @Nullable
    private List<ResourceKey<DamageType>> damageTypes;
    private final EntityDataAccessor<Float> containerAccessor;
    public final int maxValue;
    public final int stateCode;
    private boolean fulled;

    public DamageContainer(WraithonEntity wraithon, @Nullable TagKey<DamageType> tagKey, EntityDataAccessor<Float> containerAccessor, int maxValue, int stateCode) {
        this.wraithon = wraithon;
        this.tagKey = tagKey;
        this.containerAccessor = containerAccessor;
        this.maxValue = maxValue;
        this.stateCode = stateCode;
    }

    public DamageContainer(WraithonEntity wraithon, @Nullable List<ResourceKey<DamageType>> damageTypes, EntityDataAccessor<Float> containerAccessor, int maxValue, int stateCode) {
        this.wraithon = wraithon;
        this.damageTypes = damageTypes;
        this.containerAccessor = containerAccessor;
        this.maxValue = maxValue;
        this.stateCode = stateCode;
    }

    public boolean containDamage(DamageSource damageSource) {
        if (this.tagKey != null && damageSource.m_269533_(this.tagKey)) {
            return true;
        }
        if (this.damageTypes != null) {
            for (ResourceKey<DamageType> damageTypeResourceKey : this.damageTypes) {
                if (!damageSource.m_276093_(damageTypeResourceKey)) continue;
                return true;
            }
        }
        return false;
    }

    public void setContainerValue(float value) {
        if (value >= (float)this.maxValue) {
            this.fulled = true;
            this.wraithon.setState(this.stateCode);
        }
        this.wraithon.m_20088_().m_135381_(this.containerAccessor, (Object)Float.valueOf(value));
    }

    public float getContainerValue() {
        return ((Float)this.wraithon.m_20088_().m_135370_(this.containerAccessor)).floatValue();
    }

    public boolean onHurt(DamageSource damageSource, float value) {
        if (this.wraithon.getState() == this.stateCode) {
            this.wraithon.m_5634_(value);
            float newValue = this.getContainerValue() - value / this.wraithon.m_21233_() * (float)this.maxValue;
            this.setContainerValue(newValue);
            if (this.getContainerValue() <= 0.0f) {
                this.clearContainer();
            }
        } else if (this.wraithon.getState() == 0 && this.containDamage(damageSource)) {
            float receivedValue = value * 0.7f;
            float newValue = this.getContainerValue() + receivedValue;
            this.setContainerValue(newValue);
            float healRate = switch (this.wraithon.getPhase()) {
                case 1 -> 0.2f;
                case 2 -> 0.5f;
                default -> 0.3f;
            };
            return this.wraithon.m_6469_(damageSource, value * healRate);
        }
        return false;
    }

    public void onTick() {
        if (this.wraithon.getState() == this.stateCode && !this.fulled) {
            this.fulled = true;
        }
        if (this.wraithon.f_19797_ % 20 == 0 && this.fulled && this.getContainerValue() >= 0.0f) {
            this.setContainerValue(this.getContainerValue() - 1.0f);
            if (this.getContainerValue() <= 0.0f) {
                this.clearContainer();
            }
        }
    }

    public void clearContainer() {
        this.fulled = false;
        this.wraithon.updateState();
        switch (this.wraithon.getPhase()) {
            case 0: {
                this.wraithon.m_20088_().m_135381_(this.containerAccessor, (Object)Float.valueOf(0.0f));
                break;
            }
            case 1: {
                this.wraithon.m_20088_().m_135381_(this.containerAccessor, (Object)Float.valueOf((float)this.maxValue / 2.0f));
                break;
            }
        }
    }

    public boolean isFullState() {
        return this.fulled;
    }
}

