/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.wraithon.epicfight.animation;

import com.google.common.collect.Lists;
import com.merlin204.avalon.client.CameraShake;
import com.merlin204.avalon.epicfight.animations.AvalonAttackAnimation;
import com.merlin204.avalon.util.AvalonAnimationUtils;
import com.merlin204.avalon.util.AvalonEventUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.merlin204.wraithon.avalon.WraithonVFXManagers;
import org.merlin204.wraithon.entity.wraithon.WraithonArmature;
import org.merlin204.wraithon.entity.wraithon.WraithonEntity;
import org.merlin204.wraithon.entity.wraithon.WraithonEntityPatch;
import org.merlin204.wraithon.epicfight.animation.type.wraithon.WraithonActionAnimation;
import org.merlin204.wraithon.epicfight.animation.type.wraithon.WraithonAttackAnimation;
import org.merlin204.wraithon.epicfight.animation.type.wraithon.WraithonStaticAnimation;
import org.merlin204.wraithon.worldgen.WraithonDimensions;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.BasicAttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.collider.MultiOBBCollider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.LevelUtil;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPFracture;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class WraithonAnimations {
    public static AnimationManager.AnimationAccessor<ActionAnimation> BIPE_KNOCK_FLY;
    public static AnimationManager.AnimationAccessor<ActionAnimation> BIPE_COME;
    public static AnimationManager.AnimationAccessor<WraithonStaticAnimation> WRAITHON_IDLE;
    public static AnimationManager.AnimationAccessor<WraithonStaticAnimation> WRAITHON_WALK;
    public static AnimationManager.AnimationAccessor<WraithonStaticAnimation> WRAITHON_DEATH;
    public static AnimationManager.AnimationAccessor<WraithonActionAnimation> WRAITHON_KNOCKDOWN;
    public static AnimationManager.AnimationAccessor<WraithonActionAnimation> WRAITHON_ROTATE_R_40;
    public static AnimationManager.AnimationAccessor<WraithonActionAnimation> WRAITHON_ROTATE_R_60;
    public static AnimationManager.AnimationAccessor<WraithonActionAnimation> WRAITHON_ROTATE_R_80;
    public static AnimationManager.AnimationAccessor<WraithonActionAnimation> WRAITHON_ROTATE_R_100;
    public static AnimationManager.AnimationAccessor<WraithonActionAnimation> WRAITHON_ROTATE_R_120;
    public static AnimationManager.AnimationAccessor<WraithonActionAnimation> WRAITHON_ROTATE_R_140;
    public static AnimationManager.AnimationAccessor<WraithonActionAnimation> WRAITHON_ROTATE_R_160;
    public static AnimationManager.AnimationAccessor<WraithonActionAnimation> WRAITHON_ROTATE_R_180;
    public static AnimationManager.AnimationAccessor<WraithonActionAnimation> WRAITHON_ROTATE_L_40;
    public static AnimationManager.AnimationAccessor<WraithonActionAnimation> WRAITHON_ROTATE_L_60;
    public static AnimationManager.AnimationAccessor<WraithonActionAnimation> WRAITHON_ROTATE_L_80;
    public static AnimationManager.AnimationAccessor<WraithonActionAnimation> WRAITHON_ROTATE_L_100;
    public static AnimationManager.AnimationAccessor<WraithonActionAnimation> WRAITHON_ROTATE_L_120;
    public static AnimationManager.AnimationAccessor<WraithonActionAnimation> WRAITHON_ROTATE_L_140;
    public static AnimationManager.AnimationAccessor<WraithonActionAnimation> WRAITHON_ROTATE_L_160;
    public static AnimationManager.AnimationAccessor<WraithonActionAnimation> WRAITHON_ROTATE_L_180;
    public static AnimationManager.AnimationAccessor<WraithonActionAnimation> WRAITHON_BEGIN;
    public static AnimationManager.AnimationAccessor<WraithonActionAnimation> WRAITHON_CHANGE;
    public static AnimationManager.AnimationAccessor<WraithonAttackAnimation> WRAITHON_ATK_1;
    public static AnimationManager.AnimationAccessor<WraithonAttackAnimation> WRAITHON_ATK_2;
    public static AnimationManager.AnimationAccessor<WraithonAttackAnimation> WRAITHON_ATK_3;
    public static AnimationManager.AnimationAccessor<WraithonAttackAnimation> WRAITHON_ATK_4;
    public static AnimationManager.AnimationAccessor<WraithonAttackAnimation> WRAITHON_ATK_5;
    public static AnimationManager.AnimationAccessor<WraithonAttackAnimation> WRAITHON_ATK_6;
    public static AnimationManager.AnimationAccessor<WraithonAttackAnimation> WRAITHON_ATK_7;
    public static AnimationManager.AnimationAccessor<WraithonAttackAnimation> WRAITHON_ATK_8;
    public static AnimationManager.AnimationAccessor<WraithonAttackAnimation> WRAITHON_ATK_9;
    public static AnimationManager.AnimationAccessor<WraithonAttackAnimation> WRAITHON_ATK_10;
    public static AnimationManager.AnimationAccessor<WraithonAttackAnimation> WRAITHON_ATK_11;
    public static AnimationManager.AnimationAccessor<WraithonAttackAnimation> WRAITHON_ATK_12;
    public static AnimationManager.AnimationAccessor<WraithonAttackAnimation> WRAITHON_ATK_13;
    public static AnimationManager.AnimationAccessor<WraithonAttackAnimation> WRAITHON_ATK_14;
    public static AnimationManager.AnimationAccessor<WraithonAttackAnimation> WRAITHON_ATK_15;
    public static AnimationManager.AnimationAccessor<WraithonAttackAnimation> WRAITHON_SKILL_1;
    public static AnimationManager.AnimationAccessor<WraithonAttackAnimation> WRAITHON_SKILL_2;
    public static AnimationManager.AnimationAccessor<WraithonAttackAnimation> WRAITHON_SKILL_3;
    public static AnimationManager.AnimationAccessor<WraithonAttackAnimation> WRAITHON_SKILL_4;
    public static final String PATH = "wraithon/wraithon_";
    private static final Armatures.ArmatureAccessor<WraithonArmature> ARMATURE;
    private static final Collider SWORD;
    private static final Collider FLY_SWORD;
    private static final Collider SPEAR_1;
    private static final Collider SPEAR_2;

    public static void buildWraithonAnim(AnimationManager.AnimationBuilder builder) {
        Armatures.ArmatureAccessor bipe = Armatures.BIPED;
        BIPE_KNOCK_FLY = builder.nextAccessor("biped/knock_fly", accessor -> (ActionAnimation)new ActionAnimation(0.2f, accessor, (AssetAccessor)bipe).newTimePair(1.0f, Float.MAX_VALUE).addStateRemoveOld(EntityState.CAN_SKILL_EXECUTION, (Object)true));
        BIPE_COME = builder.nextAccessor("biped/come", accessor -> (ActionAnimation)new ActionAnimation(0.1f, accessor, (AssetAccessor)bipe).addEvents(new AnimationEvent[]{AvalonEventUtils.simpleGroundSplit((int)60, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (float)5.0f, (boolean)true)}));
        WRAITHON_IDLE = builder.nextAccessor("wraithon/wraithon_idle", accessor -> {
            WraithonStaticAnimation animation = (WraithonStaticAnimation)new WraithonStaticAnimation(0.1f, true, (AnimationManager.AnimationAccessor<? extends WraithonStaticAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE).addEvents(new AnimationEvent[0]);
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addEvents(new AnimationEvent[]{WraithonAnimations.setSpearShouldDraw(0, true), WraithonAnimations.setSwordRShouldDraw(0, false), WraithonAnimations.setFlySwordRShouldDraw(0, false), WraithonAnimations.setFlySwordLShouldDraw(0, false), WraithonAnimations.setSwordLShouldDraw(0, true)}).addProperty(ClientAnimationProperties.TRAIL_EFFECT, List.of());
            }
            return animation;
        });
        WRAITHON_WALK = builder.nextAccessor("wraithon/wraithon_walk", accessor -> new WraithonStaticAnimation(0.1f, false, (AnimationManager.AnimationAccessor<? extends WraithonStaticAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE));
        WRAITHON_ROTATE_R_40 = builder.nextAccessor("wraithon/wraithon_rot_r_40", accessor -> new WraithonActionAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE));
        WRAITHON_ROTATE_R_60 = builder.nextAccessor("wraithon/wraithon_rot_r_60", accessor -> new WraithonActionAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE));
        WRAITHON_ROTATE_R_80 = builder.nextAccessor("wraithon/wraithon_rot_r_80", accessor -> new WraithonActionAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE));
        WRAITHON_ROTATE_R_100 = builder.nextAccessor("wraithon/wraithon_rot_r_100", accessor -> new WraithonActionAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE));
        WRAITHON_ROTATE_R_120 = builder.nextAccessor("wraithon/wraithon_rot_r_120", accessor -> new WraithonActionAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE));
        WRAITHON_ROTATE_R_140 = builder.nextAccessor("wraithon/wraithon_rot_r_140", accessor -> new WraithonActionAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE));
        WRAITHON_ROTATE_R_160 = builder.nextAccessor("wraithon/wraithon_rot_r_160", accessor -> new WraithonActionAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE));
        WRAITHON_ROTATE_R_180 = builder.nextAccessor("wraithon/wraithon_rot_r_180", accessor -> new WraithonActionAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE));
        WRAITHON_ROTATE_L_40 = builder.nextAccessor("wraithon/wraithon_rot_l_40", accessor -> new WraithonActionAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE));
        WRAITHON_ROTATE_L_60 = builder.nextAccessor("wraithon/wraithon_rot_l_60", accessor -> new WraithonActionAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE));
        WRAITHON_ROTATE_L_80 = builder.nextAccessor("wraithon/wraithon_rot_l_80", accessor -> new WraithonActionAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE));
        WRAITHON_ROTATE_L_100 = builder.nextAccessor("wraithon/wraithon_rot_l_100", accessor -> new WraithonActionAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE));
        WRAITHON_ROTATE_L_120 = builder.nextAccessor("wraithon/wraithon_rot_l_120", accessor -> new WraithonActionAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE));
        WRAITHON_ROTATE_L_140 = builder.nextAccessor("wraithon/wraithon_rot_l_140", accessor -> new WraithonActionAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE));
        WRAITHON_ROTATE_L_160 = builder.nextAccessor("wraithon/wraithon_rot_l_160", accessor -> new WraithonActionAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE));
        WRAITHON_ROTATE_L_180 = builder.nextAccessor("wraithon/wraithon_rot_l_180", accessor -> new WraithonActionAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE));
        WRAITHON_BEGIN = builder.nextAccessor("wraithon/wraithon_begin", accessor -> {
            WraithonActionAnimation animation = (WraithonActionAnimation)new WraithonActionAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE).addEvents(new AnimationEvent[]{AvalonEventUtils.simpleCameraShake((int)60, (int)100, (float)50.0f, (float)0.2f, (float)300.0f)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addEvents(new AnimationEvent[]{WraithonAnimations.setSpearShouldDraw(0, false), WraithonAnimations.setSpearShouldDraw(150, true), WraithonAnimations.setSwordLShouldDraw(0, false), WraithonAnimations.setSwordLShouldDraw(150, true)}).addProperty(ClientAnimationProperties.TRAIL_EFFECT, List.of());
            }
            return animation;
        });
        WRAITHON_CHANGE = builder.nextAccessor("wraithon/wraithon_change", accessor -> {
            WraithonActionAnimation animation = (WraithonActionAnimation)new WraithonActionAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE).addEvents(new AnimationEvent[]{AvalonEventUtils.simpleCameraShake((int)60, (int)100, (float)50.0f, (float)0.2f, (float)300.0f), AnimationEvent.InPeriodEvent.create((float)0.0f, (float)1.0f, (entityPatch, self, params) -> {
                if (entityPatch instanceof WraithonEntityPatch) {
                    WraithonEntityPatch wraithonEntityPatch = (WraithonEntityPatch)entityPatch;
                    WraithonAnimations.createJointSphereParticles(entityPatch, ((WraithonArmature)WraithonAnimations.ARMATURE.get()).chest, (ParticleOptions)((WraithonEntity)wraithonEntityPatch.getOriginal()).getStateParticleTypes(), 0.1, 0.1, 0.2, 20);
                }
            }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.InPeriodEvent.create((float)1.0f, (float)2.5f, (entityPatch, self, params) -> {
                if (entityPatch instanceof WraithonEntityPatch) {
                    WraithonEntityPatch wraithonEntityPatch = (WraithonEntityPatch)entityPatch;
                    WraithonAnimations.createJointSphereParticles(entityPatch, ((WraithonArmature)WraithonAnimations.ARMATURE.get()).chest, (ParticleOptions)((WraithonEntity)wraithonEntityPatch.getOriginal()).getStateParticleTypes(), 0.1, 3.0, 4.0, 100);
                }
            }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addEvents(new AnimationEvent[]{WraithonAnimations.setSpearShouldDraw(0, false), WraithonAnimations.setSpearShouldDraw(150, true), WraithonAnimations.setSwordLShouldDraw(0, false), WraithonAnimations.setSwordLShouldDraw(150, true)}).addProperty(ClientAnimationProperties.TRAIL_EFFECT, List.of());
            }
            return animation;
        });
        WRAITHON_DEATH = builder.nextAccessor("wraithon/wraithon_death", accessor -> {
            WraithonStaticAnimation animation = (WraithonStaticAnimation)new WraithonStaticAnimation(0.1f, false, (AnimationManager.AnimationAccessor<? extends WraithonStaticAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE).addEvents(new AnimationEvent[]{AvalonEventUtils.simpleCameraShake((int)180, (int)100, (float)50.0f, (float)0.2f, (float)300.0f), AnimationEvent.InPeriodEvent.create((float)0.0f, (float)3.0f, (entityPatch, self, params) -> {
                if (entityPatch instanceof WraithonEntityPatch) {
                    WraithonEntityPatch wraithonEntityPatch = (WraithonEntityPatch)entityPatch;
                    WraithonAnimations.createJointSphereParticles(entityPatch, ((WraithonArmature)WraithonAnimations.ARMATURE.get()).chest, (ParticleOptions)((WraithonEntity)wraithonEntityPatch.getOriginal()).getStateParticleTypes(), 0.1, 0.2, 0.5, 100);
                }
            }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.InPeriodEvent.create((float)3.0f, (float)5.0f, (entityPatch, self, params) -> {
                if (entityPatch instanceof WraithonEntityPatch) {
                    WraithonEntityPatch wraithonEntityPatch = (WraithonEntityPatch)entityPatch;
                    WraithonAnimations.createJointSphereParticles(entityPatch, ((WraithonArmature)WraithonAnimations.ARMATURE.get()).chest, (ParticleOptions)((WraithonEntity)wraithonEntityPatch.getOriginal()).getStateParticleTypes(), 0.1, 3.0, 4.0, 100);
                }
            }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addEvents(new AnimationEvent[]{WraithonAnimations.setSpearShouldDraw(0, false), WraithonAnimations.setSwordLShouldDraw(0, false)}).addProperty(ClientAnimationProperties.TRAIL_EFFECT, List.of());
            }
            return animation;
        });
        WRAITHON_KNOCKDOWN = builder.nextAccessor("wraithon/wraithon_knockdown", accessor -> (WraithonActionAnimation)new WraithonActionAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE).addEvents(new AnimationEvent[]{AnimationEvent.InTimeEvent.create((float)7.5f, (entityPatch, self, params) -> {
            if (entityPatch instanceof WraithonEntityPatch) {
                WraithonEntityPatch wraithonEntityPatch = (WraithonEntityPatch)entityPatch;
                ((WraithonEntity)wraithonEntityPatch.getOriginal()).setKnockdown(false);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH)}));
        WRAITHON_ATK_1 = builder.nextAccessor("wraithon/wraithon_atk_1", accessor -> {
            WraithonAttackAnimation animation = (WraithonAttackAnimation)new WraithonAttackAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends BasicAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE, WraithonAnimations.swordPhaseL(40, 50), WraithonAnimations.swordPhaseR(80, 90), WraithonAnimations.swordPhaseL(90, 100)).addEvents(new AnimationEvent[]{WraithonAnimations.swordLParticleTrail(40, 50), WraithonAnimations.swordRParticleTrail(80, 90), WraithonAnimations.swordLParticleTrail(90, 100)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addEvents(new AnimationEvent[]{WraithonAnimations.setSpearShouldDraw(0, false), WraithonAnimations.setSpearShouldDraw(180, true), WraithonAnimations.setSwordRShouldDraw(45, true), WraithonAnimations.setSwordRShouldDraw(160, false)}).addProperty(ClientAnimationProperties.TRAIL_EFFECT, List.of(WraithonAnimations.swordLTrail(40, 50), WraithonAnimations.swordRTrail(80, 90), WraithonAnimations.swordLTrail(85, 100)));
            }
            return animation;
        });
        WRAITHON_ATK_2 = builder.nextAccessor("wraithon/wraithon_atk_2", accessor -> {
            WraithonAttackAnimation animation = (WraithonAttackAnimation)new WraithonAttackAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends BasicAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE, WraithonAnimations.spearPhase(40, 60), WraithonAnimations.spearPhase(90, 100), WraithonAnimations.swordPhaseL(100, 110)).addEvents(new AnimationEvent[]{WraithonAnimations.spearParticleTrail(40, 60), WraithonAnimations.spearParticleTrail(90, 100), WraithonAnimations.swordLParticleTrail(100, 110)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addEvents(new AnimationEvent[]{WraithonAnimations.setSpearShouldDraw(0, true), WraithonAnimations.setSwordLShouldDraw(0, false), WraithonAnimations.setSwordLShouldDraw(60, true)}).addProperty(ClientAnimationProperties.TRAIL_EFFECT, List.of(WraithonAnimations.spearTrail(40, 60), WraithonAnimations.spearTrail(90, 100), WraithonAnimations.swordLTrail(100, 110)));
            }
            return animation;
        });
        WRAITHON_ATK_3 = builder.nextAccessor("wraithon/wraithon_atk_3", accessor -> {
            WraithonAttackAnimation animation = (WraithonAttackAnimation)new WraithonAttackAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends BasicAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE, WraithonAnimations.flySwordLPhase(40, 50), WraithonAnimations.flySwordRPhase(90, 100)).addEvents(new AnimationEvent[]{WraithonAnimations.flySwordLParticleTrail(40, 50), WraithonAnimations.flySwordRParticleTrail(90, 100)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addEvents(new AnimationEvent[]{WraithonAnimations.setSpearShouldDraw(0, false), WraithonAnimations.setSpearShouldDraw(140, true), WraithonAnimations.setSwordLShouldDraw(0, false), WraithonAnimations.setSwordLShouldDraw(140, true), WraithonAnimations.setFlySwordLShouldDraw(25, true), WraithonAnimations.setFlySwordLShouldDraw(50, false), WraithonAnimations.setFlySwordRShouldDraw(75, true), WraithonAnimations.setFlySwordRShouldDraw(100, false)}).addProperty(ClientAnimationProperties.TRAIL_EFFECT, WraithonAnimations.flySwordALLTrail(90, 100, 40, 50));
            }
            return animation;
        });
        WRAITHON_ATK_4 = builder.nextAccessor("wraithon/wraithon_atk_4", accessor -> {
            WraithonAttackAnimation animation = (WraithonAttackAnimation)new WraithonAttackAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends BasicAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE, WraithonAnimations.flySwordLPhase(200, 210), WraithonAnimations.flySwordRPhase(200, 210)).addEvents(new AnimationEvent[]{WraithonAnimations.flySwordLParticleTrail(200, 210), WraithonAnimations.flySwordRParticleTrail(200, 210), WraithonAnimations.legParticleTrail(85, 90)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addEvents(new AnimationEvent[]{WraithonAnimations.setSpearShouldDraw(0, false), WraithonAnimations.setSpearShouldDraw(270, true), WraithonAnimations.setSwordLShouldDraw(0, false), WraithonAnimations.setSwordLShouldDraw(270, true), WraithonAnimations.setFlySwordLShouldDraw(160, true), WraithonAnimations.setFlySwordLShouldDraw(200, false), WraithonAnimations.setFlySwordRShouldDraw(160, true), WraithonAnimations.setFlySwordRShouldDraw(200, false)}).addProperty(ClientAnimationProperties.TRAIL_EFFECT, List.of());
            }
            return animation;
        });
        WRAITHON_ATK_5 = builder.nextAccessor("wraithon/wraithon_atk_5", accessor -> {
            WraithonAttackAnimation animation = (WraithonAttackAnimation)new WraithonAttackAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends BasicAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE, WraithonAnimations.swordPhaseL(40, 50), WraithonAnimations.swordPhaseR(40, 50), WraithonAnimations.swordPhaseL(100, 115), WraithonAnimations.swordPhaseR(157, 165), WraithonAnimations.swordPhaseL(150, 160)).addEvents(new AnimationEvent[]{WraithonAnimations.swordLParticleTrail(40, 50), WraithonAnimations.swordRParticleTrail(40, 50), WraithonAnimations.swordLParticleTrail(100, 115), WraithonAnimations.swordRParticleTrail(157, 165), WraithonAnimations.swordLParticleTrail(150, 160)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addEvents(new AnimationEvent[]{WraithonAnimations.setSpearShouldDraw(0, false), WraithonAnimations.setSpearShouldDraw(215, true), WraithonAnimations.setSwordRShouldDraw(0, true), WraithonAnimations.setSwordRShouldDraw(215, false)}).addProperty(ClientAnimationProperties.TRAIL_EFFECT, List.of(WraithonAnimations.swordLTrail(40, 50), WraithonAnimations.swordRTrail(40, 50), WraithonAnimations.swordRTrail(80, 90), WraithonAnimations.swordLTrail(100, 115), WraithonAnimations.swordRTrail(157, 165), WraithonAnimations.swordLTrail(150, 160)));
            }
            return animation;
        });
        WRAITHON_ATK_6 = builder.nextAccessor("wraithon/wraithon_atk_6", accessor -> {
            WraithonAttackAnimation animation = (WraithonAttackAnimation)new WraithonAttackAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends BasicAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE, WraithonAnimations.spearPhase(40, 50), WraithonAnimations.spearPhase(100, 110)).addEvents(new AnimationEvent[]{WraithonAnimations.spearParticleTrail(40, 50), WraithonAnimations.spearParticleTrail(100, 110)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addEvents(new AnimationEvent[]{WraithonAnimations.setSwordLShouldDraw(0, false), WraithonAnimations.setSwordLShouldDraw(150, true)}).addProperty(ClientAnimationProperties.TRAIL_EFFECT, List.of(WraithonAnimations.spearTrail(40, 50), WraithonAnimations.spearTrail(100, 110)));
            }
            return animation;
        });
        WRAITHON_ATK_7 = builder.nextAccessor("wraithon/wraithon_atk_7", accessor -> {
            WraithonAttackAnimation animation = (WraithonAttackAnimation)new WraithonAttackAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends BasicAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE, WraithonAnimations.flySwordLPhase(110, 120), WraithonAnimations.flySwordRPhase(110, 120)).addEvents(new AnimationEvent[]{WraithonAnimations.legParticleTrail(70, 75)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addEvents(new AnimationEvent[]{WraithonAnimations.setSpearShouldDraw(0, false), WraithonAnimations.setSpearShouldDraw(175, true), WraithonAnimations.setSwordLShouldDraw(0, false), WraithonAnimations.setSwordLShouldDraw(175, true), WraithonAnimations.setFlySwordLShouldDraw(80, true), WraithonAnimations.setFlySwordLShouldDraw(120, false), WraithonAnimations.setFlySwordRShouldDraw(80, true), WraithonAnimations.setFlySwordRShouldDraw(120, false)}).addProperty(ClientAnimationProperties.TRAIL_EFFECT, WraithonAnimations.flySwordALLTrail(110, 120, 110, 120));
            }
            return animation;
        });
        WRAITHON_ATK_8 = builder.nextAccessor("wraithon/wraithon_atk_8", accessor -> {
            WraithonAttackAnimation animation = (WraithonAttackAnimation)new WraithonAttackAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends BasicAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE, WraithonAnimations.swordPhaseL(60, 70), WraithonAnimations.swordPhaseL(100, 110)).addEvents(new AnimationEvent[]{WraithonAnimations.swordLParticleTrail(60, 70), WraithonAnimations.swordLParticleTrail(100, 110)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addProperty(ClientAnimationProperties.TRAIL_EFFECT, List.of(WraithonAnimations.swordLTrail(60, 70), WraithonAnimations.swordLTrail(100, 110)));
            }
            return animation;
        });
        WRAITHON_ATK_9 = builder.nextAccessor("wraithon/wraithon_atk_9", accessor -> {
            WraithonAttackAnimation animation = (WraithonAttackAnimation)new WraithonAttackAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends BasicAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE, WraithonAnimations.swordPhaseL(60, 75), WraithonAnimations.spearPhase(120, 135), WraithonAnimations.swordPhaseL(130, 145)).addEvents(new AnimationEvent[]{WraithonAnimations.swordLParticleTrail(60, 75), WraithonAnimations.spearParticleTrail(120, 135), WraithonAnimations.swordLParticleTrail(130, 145)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addProperty(ClientAnimationProperties.TRAIL_EFFECT, List.of(WraithonAnimations.swordLTrail(60, 75), WraithonAnimations.spearTrail(120, 135), WraithonAnimations.swordLTrail(130, 145)));
            }
            return animation;
        });
        WRAITHON_ATK_10 = builder.nextAccessor("wraithon/wraithon_atk_10", accessor -> {
            WraithonAttackAnimation animation = (WraithonAttackAnimation)new WraithonAttackAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends BasicAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE, WraithonAnimations.spearPhase(50, 60)).addEvents(new AnimationEvent[]{WraithonAnimations.spearParticleTrail(50, 60)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addProperty(ClientAnimationProperties.TRAIL_EFFECT, List.of(WraithonAnimations.spearTrail(50, 60)));
            }
            return animation;
        });
        WRAITHON_ATK_11 = builder.nextAccessor("wraithon/wraithon_atk_11", accessor -> {
            WraithonAttackAnimation animation = (WraithonAttackAnimation)new WraithonAttackAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends BasicAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE, WraithonAnimations.flySwordLPhase(60, 70)).addEvents(new AnimationEvent[]{WraithonAnimations.flySwordRParticleTrail(60, 70)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addEvents(new AnimationEvent[]{WraithonAnimations.setFlySwordRShouldDraw(30, true), WraithonAnimations.setFlySwordRShouldDraw(70, false)}).addProperty(ClientAnimationProperties.TRAIL_EFFECT, WraithonAnimations.flySwordRTrail(60, 70));
            }
            return animation;
        });
        WRAITHON_ATK_12 = builder.nextAccessor("wraithon/wraithon_atk_12", accessor -> {
            WraithonAttackAnimation animation = (WraithonAttackAnimation)new WraithonAttackAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends BasicAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE, WraithonAnimations.flySwordLPhase(70, 80), WraithonAnimations.flySwordRPhase(70, 80)).addEvents(new AnimationEvent[]{WraithonAnimations.flySwordLParticleTrail(70, 80), WraithonAnimations.flySwordRParticleTrail(70, 80)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addEvents(new AnimationEvent[]{WraithonAnimations.setSpearShouldDraw(0, false), WraithonAnimations.setSpearShouldDraw(120, true), WraithonAnimations.setSwordLShouldDraw(0, false), WraithonAnimations.setSwordLShouldDraw(120, true), WraithonAnimations.setFlySwordLShouldDraw(40, true), WraithonAnimations.setFlySwordLShouldDraw(80, false), WraithonAnimations.setFlySwordRShouldDraw(40, true), WraithonAnimations.setFlySwordRShouldDraw(80, false)}).addProperty(ClientAnimationProperties.TRAIL_EFFECT, WraithonAnimations.flySwordALLTrail(70, 80, 70, 80));
            }
            return animation;
        });
        WRAITHON_ATK_13 = builder.nextAccessor("wraithon/wraithon_atk_13", accessor -> {
            WraithonAttackAnimation animation = (WraithonAttackAnimation)new WraithonAttackAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends BasicAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE, WraithonAnimations.swordPhaseL(60, 70), WraithonAnimations.swordPhaseR(70, 80)).addEvents(new AnimationEvent[]{WraithonAnimations.swordLParticleTrail(60, 70), WraithonAnimations.swordRParticleTrail(70, 80)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addEvents(new AnimationEvent[]{WraithonAnimations.setSpearShouldDraw(0, false), WraithonAnimations.setSpearShouldDraw(120, true), WraithonAnimations.setSwordRShouldDraw(30, true), WraithonAnimations.setSwordRShouldDraw(120, false)}).addProperty(ClientAnimationProperties.TRAIL_EFFECT, List.of(WraithonAnimations.swordLTrail(60, 70), WraithonAnimations.swordRTrail(70, 80)));
            }
            return animation;
        });
        WRAITHON_ATK_14 = builder.nextAccessor("wraithon/wraithon_atk_14", accessor -> {
            WraithonAttackAnimation animation = (WraithonAttackAnimation)new WraithonAttackAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends BasicAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE, WraithonAnimations.flySwordLPhase(30, 40)).addEvents(new AnimationEvent[]{WraithonAnimations.flySwordLParticleTrail(30, 40)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addEvents(new AnimationEvent[]{WraithonAnimations.setFlySwordLShouldDraw(0, true), WraithonAnimations.setFlySwordLShouldDraw(40, false), WraithonAnimations.setSpearShouldDraw(0, false), WraithonAnimations.setSpearShouldDraw(90, true), WraithonAnimations.setSwordLShouldDraw(0, false), WraithonAnimations.setSwordLShouldDraw(90, true)}).addProperty(ClientAnimationProperties.TRAIL_EFFECT, WraithonAnimations.flySwordLTrail(30, 40));
            }
            return animation;
        });
        WRAITHON_ATK_15 = builder.nextAccessor("wraithon/wraithon_atk_15", accessor -> {
            WraithonAttackAnimation animation = (WraithonAttackAnimation)new WraithonAttackAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends BasicAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE, WraithonAnimations.swordPhaseL(65, 90), WraithonAnimations.spearPhase(60, 75)).addEvents(new AnimationEvent[]{WraithonAnimations.swordLParticleTrail(65, 90), WraithonAnimations.spearParticleTrail(60, 75)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addEvents(new AnimationEvent[0]).addProperty(ClientAnimationProperties.TRAIL_EFFECT, List.of(WraithonAnimations.swordLTrail(65, 90), WraithonAnimations.spearTrail(60, 75)));
            }
            return animation;
        });
        WRAITHON_SKILL_1 = builder.nextAccessor("wraithon/wraithon_skill_1", accessor -> {
            WraithonAttackAnimation animation = (WraithonAttackAnimation)new WraithonAttackAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends BasicAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE, WraithonAnimations.spearPhase(50, 60)).addEvents(new AnimationEvent[]{AnimationEvent.InTimeEvent.create((float)0.33333334f, (entityPatch, self, params) -> {
                if (entityPatch.getTarget() != null) {
                    WraithonVFXManagers.SWORD_2.spawnVFXEntity((LivingEntity)entityPatch.getOriginal(), entityPatch.getTarget().m_20182_(), Vec3f.ZERO, 1.0f);
                }
            }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addEvents(new AnimationEvent[]{WraithonAnimations.setSwordLShouldDraw(0, false), WraithonAnimations.setSwordLShouldDraw(150, true)}).addProperty(ClientAnimationProperties.TRAIL_EFFECT, List.of(WraithonAnimations.spearTrail(50, 60)));
            }
            return animation;
        });
        WRAITHON_SKILL_2 = builder.nextAccessor("wraithon/wraithon_skill_2", accessor -> {
            WraithonAttackAnimation animation = (WraithonAttackAnimation)new WraithonAttackAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends BasicAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE, WraithonAnimations.spearPhase(0, 0)).addEvents(new AnimationEvent[]{WraithonAnimations.createSpearRing(60, 20, 10.0f, 12.0f), WraithonAnimations.createSpearRing(70, 24, 12.0f, 14.0f), WraithonAnimations.createSpearRing(80, 28, 16.0f, 18.0f), WraithonAnimations.createSpearRing(90, 32, 20.0f, 22.0f), AvalonEventUtils.simpleCameraShake((int)60, (int)20, (float)30.0f, (float)0.3f, (float)50.0f), WraithonAnimations.knockFly(60, 8.0), AvalonEventUtils.simpleGroundSplit((int)60, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (float)10.0f, (boolean)false), WraithonAnimations.createRing(40, (ParticleOptions)ParticleTypes.f_123755_.m_6012_(), 22.0, 150)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addEvents(new AnimationEvent[]{WraithonAnimations.setSwordLShouldDraw(0, false), WraithonAnimations.setSwordLShouldDraw(140, true)}).addProperty(ClientAnimationProperties.TRAIL_EFFECT, List.of(WraithonAnimations.spearTrail(30, 60)));
            }
            return animation;
        });
        WRAITHON_SKILL_3 = builder.nextAccessor("wraithon/wraithon_skill_3", accessor -> {
            WraithonAttackAnimation animation = (WraithonAttackAnimation)new WraithonAttackAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends BasicAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE, WraithonAnimations.spearPhase(0, 0)).addEvents(new AnimationEvent[]{AnimationEvent.InTimeEvent.create((float)1.5833334f, (entityPatch, self, params) -> {
                if (entityPatch.getTarget() != null) {
                    WraithonVFXManagers.SPEAR_2.spawnVFXEntity((LivingEntity)entityPatch.getOriginal(), entityPatch.getTarget().m_20182_(), Vec3f.ZERO, 1.0f);
                } else {
                    WraithonVFXManagers.SPEAR_2.spawnVFXEntity((LivingEntity)entityPatch.getOriginal(), new Vec3f(12.0f, 0.0f, 30.0f), Vec3f.ZERO, 1.0f);
                }
            }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)});
            if (FMLEnvironment.dist == Dist.CLIENT) {
                animation.addEvents(new AnimationEvent[]{WraithonAnimations.setSpearShouldDraw(90, false), WraithonAnimations.setSpearShouldDraw(165, true), WraithonAnimations.setSwordLShouldDraw(0, false), WraithonAnimations.setSwordLShouldDraw(165, true)}).addProperty(ClientAnimationProperties.TRAIL_EFFECT, List.of(WraithonAnimations.spearTrail(5, 40)));
            }
            return animation;
        });
        WRAITHON_SKILL_4 = builder.nextAccessor("wraithon/wraithon_skill_4", accessor -> {
            WraithonAttackAnimation animation = (WraithonAttackAnimation)new WraithonAttackAnimation(0.1f, (AnimationManager.AnimationAccessor<? extends BasicAttackAnimation>)accessor, (AssetAccessor<? extends Armature>)ARMATURE, WraithonAnimations.spearPhase(0, 0)).addEvents(new AnimationEvent[]{WraithonAnimations.createSpearRing(160, 20, 10.0f, 12.0f), WraithonAnimations.createSpearRing(170, 24, 12.0f, 14.0f), WraithonAnimations.createSpearRing(180, 28, 16.0f, 18.0f), WraithonAnimations.createSpearRing(190, 32, 20.0f, 22.0f), AvalonEventUtils.simpleCameraShake((int)140, (int)20, (float)30.0f, (float)0.3f, (float)50.0f), WraithonAnimations.knockFly(140, 10.0), AvalonEventUtils.simpleGroundSplit((int)140, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (float)10.0f, (boolean)false), AnimationEvent.InTimeEvent.create((float)1.8333334f, (entityPatch, self, params) -> {
                if (((LivingEntity)entityPatch.getOriginal()).m_9236_().m_46472_() == WraithonDimensions.SANCTUM_OF_THE_WRAITHON_LEVEL_KEY) {
                    ((LivingEntity)entityPatch.getOriginal()).m_146884_(new Vec3(170.0, 7.0, 300.0));
                }
            }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)});
            return animation;
        });
    }

    private static AnimationEvent.InTimeEvent createRing(int startFrame, ParticleOptions particleOptions, double radius, int particleCount) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Level level = ((LivingEntity)entityPatch.getOriginal()).m_9236_();
            Vec3 center = ((LivingEntity)entityPatch.getOriginal()).m_20182_();
            RandomSource random = level.f_46441_;
            for (int i = 0; i < particleCount; ++i) {
                double angle = random.m_188500_() * 2.0 * Math.PI;
                double x = center.m_7096_() + Math.cos(angle) * radius;
                double y = center.m_7098_();
                double z = center.m_7094_() + Math.sin(angle) * radius;
                level.m_6493_(particleOptions, true, x, y, z, 0.0, 0.01, 0.0);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    private static AnimationEvent.InTimeEvent createSpearRing(int startFrame, int Count, float innerRadius, float outerRadius) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Level level = ((LivingEntity)entityPatch.getOriginal()).m_9236_();
            Vec3 center = ((LivingEntity)entityPatch.getOriginal()).m_20182_();
            RandomSource random = level.f_46441_;
            for (int i = 0; i < Count; ++i) {
                double angle = (double)(i * 2) * Math.PI / (double)Count;
                double radius = (double)innerRadius + random.m_188500_() * (double)(outerRadius - innerRadius);
                double x = center.f_82479_ + radius * Math.cos(angle);
                double y = center.f_82480_;
                double z = center.f_82481_ + radius * Math.sin(angle);
                WraithonVFXManagers.SPEAR_1.spawnVFXEntity((LivingEntity)entityPatch.getOriginal(), new Vec3(x, y, z), new Vec3f((random.m_188501_() - 0.5f) * 30.0f, (random.m_188501_() - 0.5f) * 30.0f, (random.m_188501_() - 0.5f) * 30.0f), 1.0f);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    private static AnimationEvent.InPeriodEvent TrailEvent(int startFrame, int endFrame, float timeInterpolation, int particleCount, float random, Vec3 trailStartOffset, Vec3 trailEndOffset, String name) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            if (entityPatch instanceof WraithonEntityPatch) {
                WraithonEntityPatch wraithonEntityPatch = (WraithonEntityPatch)entityPatch;
                AnimationPlayer player = entityPatch.getAnimator().getPlayerFor(null);
                float prevElapsedTime = player.getPrevElapsedTime();
                float elapsedTime = player.getElapsedTime();
                float step = (elapsedTime - prevElapsedTime) / timeInterpolation;
                Vec3f trailDirection = new Vec3f((float)(trailEndOffset.f_82479_ - trailStartOffset.f_82479_), (float)(trailEndOffset.f_82480_ - trailStartOffset.f_82480_), (float)(trailEndOffset.f_82481_ - trailStartOffset.f_82481_));
                for (float f = prevElapsedTime; f <= elapsedTime; f += step) {
                    for (int i = 0; i <= particleCount; ++i) {
                        float ratio = (float)i / (float)particleCount;
                        Vec3f pointOffset = new Vec3f((float)(trailStartOffset.f_82479_ + (double)(trailDirection.x * ratio)), (float)(trailStartOffset.f_82480_ + (double)(trailDirection.y * ratio)), (float)(trailStartOffset.f_82481_ + (double)(trailDirection.z * ratio)));
                        double randX = (Math.random() - 0.5) * (double)random;
                        double randY = (Math.random() - 0.5) * (double)random;
                        double randZ = (Math.random() - 0.5) * (double)random;
                        Vec3 worldPos = WraithonAnimations.getJointWorldRawPos((WraithonEntityPatch)entityPatch, ((WraithonArmature)ARMATURE.get()).searchJointByName(name), f, pointOffset);
                        if (!((LivingEntity)entityPatch.getOriginal()).m_9236_().f_46443_) continue;
                        WraithonAnimations.wCircleSlamFracture((LivingEntity)entityPatch.getOriginal(), ((LivingEntity)entityPatch.getOriginal()).m_9236_(), worldPos, 2.0);
                        if (((WraithonEntity)wraithonEntityPatch.getOriginal()).getStateParticleTypes() == null) continue;
                        ((LivingEntity)entityPatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)((WraithonEntity)wraithonEntityPatch.getOriginal()).getStateParticleTypes(), worldPos.f_82479_ + randX, worldPos.f_82480_ + randY, worldPos.f_82481_ + randZ, 0.0, 0.0, 0.0);
                    }
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    private static AnimationEvent.InPeriodEvent TrailEvent(int startFrame, int endFrame, float timeInterpolation, int particleCount, float random, Vec3 trailStartOffset, Vec3 trailEndOffset, List<String> names) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            if (entityPatch instanceof WraithonEntityPatch) {
                WraithonEntityPatch wraithonEntityPatch = (WraithonEntityPatch)entityPatch;
                AnimationPlayer player = entityPatch.getAnimator().getPlayerFor(null);
                float prevElapsedTime = player.getPrevElapsedTime();
                float elapsedTime = player.getElapsedTime();
                float step = (elapsedTime - prevElapsedTime) / timeInterpolation;
                Vec3f trailDirection = new Vec3f((float)(trailEndOffset.f_82479_ - trailStartOffset.f_82479_), (float)(trailEndOffset.f_82480_ - trailStartOffset.f_82480_), (float)(trailEndOffset.f_82481_ - trailStartOffset.f_82481_));
                for (String name : names) {
                    for (float f = prevElapsedTime; f <= elapsedTime; f += step) {
                        for (int i = 0; i <= particleCount; ++i) {
                            float ratio = (float)i / (float)particleCount;
                            Vec3f pointOffset = new Vec3f((float)(trailStartOffset.f_82479_ + (double)(trailDirection.x * ratio)), (float)(trailStartOffset.f_82480_ + (double)(trailDirection.y * ratio)), (float)(trailStartOffset.f_82481_ + (double)(trailDirection.z * ratio)));
                            double randX = (Math.random() - 0.5) * (double)random;
                            double randY = (Math.random() - 0.5) * (double)random;
                            double randZ = (Math.random() - 0.5) * (double)random;
                            Vec3 worldPos = WraithonAnimations.getJointWorldRawPos((WraithonEntityPatch)entityPatch, ((WraithonArmature)ARMATURE.get()).searchJointByName(name), f, pointOffset);
                            if (!((LivingEntity)entityPatch.getOriginal()).m_9236_().f_46443_) continue;
                            WraithonAnimations.wCircleSlamFracture((LivingEntity)entityPatch.getOriginal(), ((LivingEntity)entityPatch.getOriginal()).m_9236_(), worldPos, 2.0);
                            if (((WraithonEntity)wraithonEntityPatch.getOriginal()).getStateParticleTypes() == null) continue;
                            ((LivingEntity)entityPatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)((WraithonEntity)wraithonEntityPatch.getOriginal()).getStateParticleTypes(), worldPos.f_82479_ + randX, worldPos.f_82480_ + randY, worldPos.f_82481_ + randZ, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    private static AvalonAttackAnimation.AvalonPhase swordPhaseL(int startFrame, int endFrame) {
        return AvalonAnimationUtils.createSimplePhase((int)startFrame, (int)endFrame, (int)500, (InteractionHand)InteractionHand.OFF_HAND, (Joint)((WraithonArmature)ARMATURE.get()).searchJointByName("sword_L"), (Collider)SWORD);
    }

    private static AvalonAttackAnimation.AvalonPhase swordPhaseR(int startFrame, int endFrame) {
        return AvalonAnimationUtils.createSimplePhase((int)startFrame, (int)endFrame, (int)500, (InteractionHand)InteractionHand.MAIN_HAND, (Joint)((WraithonArmature)ARMATURE.get()).searchJointByName("sword_R"), (Collider)SWORD);
    }

    private static AvalonAttackAnimation.AvalonPhase spearPhase(int startFrame, int endFrame) {
        return AvalonAnimationUtils.createSimplePhase((int)startFrame, (int)endFrame, (int)500, (InteractionHand)InteractionHand.MAIN_HAND, (AttackAnimation.JointColliderPair[])new AttackAnimation.JointColliderPair[]{AttackAnimation.JointColliderPair.of((Joint)((WraithonArmature)ARMATURE.get()).searchJointByName("spear"), (Collider)SPEAR_1), AttackAnimation.JointColliderPair.of((Joint)((WraithonArmature)ARMATURE.get()).searchJointByName("spear"), (Collider)SPEAR_2)});
    }

    private static AvalonAttackAnimation.AvalonPhase flySwordRPhase(int startFrame, int endFrame) {
        return AvalonAnimationUtils.createSimplePhase((int)startFrame, (int)endFrame, (int)500, (InteractionHand)InteractionHand.MAIN_HAND, (AttackAnimation.JointColliderPair[])new AttackAnimation.JointColliderPair[]{AttackAnimation.JointColliderPair.of((Joint)((WraithonArmature)ARMATURE.get()).searchJointByName("fly_sword_1_R"), (Collider)FLY_SWORD), AttackAnimation.JointColliderPair.of((Joint)((WraithonArmature)ARMATURE.get()).searchJointByName("fly_sword_2_R"), (Collider)FLY_SWORD), AttackAnimation.JointColliderPair.of((Joint)((WraithonArmature)ARMATURE.get()).searchJointByName("fly_sword_3_R"), (Collider)FLY_SWORD)});
    }

    private static AvalonAttackAnimation.AvalonPhase flySwordLPhase(int startFrame, int endFrame) {
        return AvalonAnimationUtils.createSimplePhase((int)startFrame, (int)endFrame, (int)500, (InteractionHand)InteractionHand.MAIN_HAND, (AttackAnimation.JointColliderPair[])new AttackAnimation.JointColliderPair[]{AttackAnimation.JointColliderPair.of((Joint)((WraithonArmature)ARMATURE.get()).searchJointByName("fly_sword_1_L"), (Collider)FLY_SWORD), AttackAnimation.JointColliderPair.of((Joint)((WraithonArmature)ARMATURE.get()).searchJointByName("fly_sword_2_L"), (Collider)FLY_SWORD), AttackAnimation.JointColliderPair.of((Joint)((WraithonArmature)ARMATURE.get()).searchJointByName("fly_sword_3_L"), (Collider)FLY_SWORD)});
    }

    @OnlyIn(value=Dist.CLIENT)
    private static AnimationEvent.InTimeEvent setSwordLShouldDraw(int startFrame, boolean shouldDraw) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            if (entityPatch instanceof WraithonEntityPatch) {
                WraithonEntityPatch wraithonEntityPatch = (WraithonEntityPatch)entityPatch;
                wraithonEntityPatch.SWORD_L.setShouldDraw(shouldDraw);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static AnimationEvent.InTimeEvent setSwordRShouldDraw(int startFrame, boolean shouldDraw) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            if (entityPatch instanceof WraithonEntityPatch) {
                WraithonEntityPatch wraithonEntityPatch = (WraithonEntityPatch)entityPatch;
                wraithonEntityPatch.SWORD_R.setShouldDraw(shouldDraw);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static AnimationEvent.InTimeEvent setSpearShouldDraw(int startFrame, boolean shouldDraw) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            if (entityPatch instanceof WraithonEntityPatch) {
                WraithonEntityPatch wraithonEntityPatch = (WraithonEntityPatch)entityPatch;
                wraithonEntityPatch.SPEAR.setShouldDraw(shouldDraw);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static AnimationEvent.InTimeEvent setFlySwordLShouldDraw(int startFrame, boolean shouldDraw) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            if (entityPatch instanceof WraithonEntityPatch) {
                WraithonEntityPatch wraithonEntityPatch = (WraithonEntityPatch)entityPatch;
                wraithonEntityPatch.FLY_SWORD_L.setShouldDraw(shouldDraw);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static AnimationEvent.InTimeEvent setFlySwordRShouldDraw(int startFrame, boolean shouldDraw) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            if (entityPatch instanceof WraithonEntityPatch) {
                WraithonEntityPatch wraithonEntityPatch = (WraithonEntityPatch)entityPatch;
                wraithonEntityPatch.FLY_SWORD_R.setShouldDraw(shouldDraw);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    private static AnimationEvent.InPeriodEvent swordLParticleTrail(int startFrame, int endFrame) {
        return WraithonAnimations.TrailEvent(startFrame, endFrame, 5.0f, 10, 0.5f, new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 13.0, 0.0), "sword_L");
    }

    private static AnimationEvent.InPeriodEvent swordRParticleTrail(int startFrame, int endFrame) {
        return WraithonAnimations.TrailEvent(startFrame, endFrame, 5.0f, 10, 0.5f, new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 13.0, 0.0), "sword_R");
    }

    private static AnimationEvent.InPeriodEvent spearParticleTrail(int startFrame, int endFrame) {
        return WraithonAnimations.TrailEvent(startFrame, endFrame, 5.0f, 10, 0.5f, new Vec3(0.0, 5.0, 0.0), new Vec3(0.0, 13.0, 0.0), "spear");
    }

    private static AnimationEvent.InPeriodEvent flySwordRParticleTrail(int startFrame, int endFrame) {
        return WraithonAnimations.TrailEvent(startFrame, endFrame, 5.0f, 10, 0.5f, new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 11.5, 0.0), List.of("fly_sword_1_R", "fly_sword_2_R", "fly_sword_3_R"));
    }

    private static AnimationEvent.InPeriodEvent flySwordLParticleTrail(int startFrame, int endFrame) {
        return WraithonAnimations.TrailEvent(startFrame, endFrame, 5.0f, 10, 0.5f, new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 11.5, 0.0), List.of("fly_sword_1_L", "fly_sword_2_L", "fly_sword_3_L"));
    }

    private static AnimationEvent.InPeriodEvent legParticleTrail(int startFrame, int endFrame) {
        return WraithonAnimations.TrailEvent(startFrame, endFrame, 5.0f, 10, 0.5f, new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 5.0, 0.0), List.of("leg_m_4_L", "leg_b_3_L", "leg_f_3_L", "leg_m_4_R", "leg_b_3_R", "leg_f_3_R"));
    }

    private static List<TrailInfo> flySwordALLTrail(int startFrameR, int endFrameR, int startFrameL, int endFrameL) {
        ArrayList<TrailInfo> list = new ArrayList<TrailInfo>();
        List<TrailInfo> listR = WraithonAnimations.flySwordRTrail(startFrameR, endFrameR);
        List<TrailInfo> listL = WraithonAnimations.flySwordLTrail(startFrameL, endFrameL);
        list.add(listR.get(0));
        list.add(listR.get(1));
        list.add(listR.get(2));
        list.add(listL.get(0));
        list.add(listL.get(1));
        list.add(listL.get(2));
        return list;
    }

    private static List<TrailInfo> flySwordRTrail(int startFrame, int endFrame) {
        ArrayList<TrailInfo> list = new ArrayList<TrailInfo>();
        Vec3 startPos = new Vec3(0.0, 0.0, 0.0);
        Vec3 endPos = new Vec3(0.0, 11.5, 0.0);
        int liftTime = 10;
        list.add(TrailInfo.builder().r(1.0f).b(1.0f).g(1.0f).startPos(startPos).endPos(endPos).time((float)startFrame / 60.0f, (float)endFrame / 60.0f).lifetime(liftTime).interpolations(15).updateInterval(1).joint("fly_sword_1_R").itemSkinHand(InteractionHand.MAIN_HAND).texture("wraithon:textures/particle/vatansever.png").type((SimpleParticleType)EpicFightParticles.SWING_TRAIL.get()).create());
        list.add(TrailInfo.builder().r(1.0f).b(1.0f).g(1.0f).startPos(startPos).endPos(endPos).time((float)startFrame / 60.0f, (float)endFrame / 60.0f).lifetime(liftTime).interpolations(15).updateInterval(1).joint("fly_sword_2_R").itemSkinHand(InteractionHand.MAIN_HAND).texture("wraithon:textures/particle/vatansever.png").type((SimpleParticleType)EpicFightParticles.SWING_TRAIL.get()).create());
        list.add(TrailInfo.builder().r(1.0f).b(1.0f).g(1.0f).startPos(startPos).endPos(endPos).time((float)startFrame / 60.0f, (float)endFrame / 60.0f).lifetime(liftTime).interpolations(15).updateInterval(1).joint("fly_sword_3_R").itemSkinHand(InteractionHand.MAIN_HAND).texture("wraithon:textures/particle/vatansever.png").type((SimpleParticleType)EpicFightParticles.SWING_TRAIL.get()).create());
        return list;
    }

    private static List<TrailInfo> flySwordLTrail(int startFrame, int endFrame) {
        ArrayList<TrailInfo> list = new ArrayList<TrailInfo>();
        Vec3 startPos = new Vec3(0.0, 0.0, 0.0);
        Vec3 endPos = new Vec3(0.0, 11.5, 0.0);
        int liftTime = 10;
        list.add(TrailInfo.builder().r(1.0f).b(1.0f).g(1.0f).startPos(startPos).endPos(endPos).time((float)startFrame / 60.0f, (float)endFrame / 60.0f).lifetime(liftTime).interpolations(15).updateInterval(1).joint("fly_sword_1_L").itemSkinHand(InteractionHand.MAIN_HAND).texture("wraithon:textures/particle/vatansever.png").type((SimpleParticleType)EpicFightParticles.SWING_TRAIL.get()).create());
        list.add(TrailInfo.builder().r(1.0f).b(1.0f).g(1.0f).startPos(startPos).endPos(endPos).time((float)startFrame / 60.0f, (float)endFrame / 60.0f).lifetime(liftTime).interpolations(15).updateInterval(1).joint("fly_sword_2_L").itemSkinHand(InteractionHand.MAIN_HAND).texture("wraithon:textures/particle/vatansever.png").type((SimpleParticleType)EpicFightParticles.SWING_TRAIL.get()).create());
        list.add(TrailInfo.builder().r(1.0f).b(1.0f).g(1.0f).startPos(startPos).endPos(endPos).time((float)startFrame / 60.0f, (float)endFrame / 60.0f).lifetime(liftTime).interpolations(15).updateInterval(1).joint("fly_sword_3_L").itemSkinHand(InteractionHand.MAIN_HAND).texture("wraithon:textures/particle/vatansever.png").type((SimpleParticleType)EpicFightParticles.SWING_TRAIL.get()).create());
        return list;
    }

    private static TrailInfo swordLTrail(int startFrame, int endFrame) {
        return TrailInfo.builder().r(1.0f).b(1.0f).g(1.0f).startPos(new Vec3(0.0, 0.0, 0.0)).endPos(new Vec3(0.0, 13.0, 0.0)).time((float)startFrame / 60.0f, (float)endFrame / 60.0f).lifetime(15).interpolations(15).updateInterval(1).joint("sword_L").itemSkinHand(InteractionHand.MAIN_HAND).texture("wraithon:textures/particle/vatansever.png").type((SimpleParticleType)EpicFightParticles.SWING_TRAIL.get()).create();
    }

    private static TrailInfo swordRTrail(int startFrame, int endFrame) {
        return TrailInfo.builder().r(1.0f).b(1.0f).g(1.0f).startPos(new Vec3(0.0, 0.0, 0.0)).endPos(new Vec3(0.0, 13.0, 0.0)).time((float)startFrame / 60.0f, (float)endFrame / 60.0f).lifetime(15).interpolations(15).updateInterval(1).joint("sword_R").itemSkinHand(InteractionHand.MAIN_HAND).texture("wraithon:textures/particle/vatansever.png").type((SimpleParticleType)EpicFightParticles.SWING_TRAIL.get()).create();
    }

    private static TrailInfo spearTrail(int startFrame, int endFrame) {
        return TrailInfo.builder().r(1.0f).b(1.0f).g(1.0f).startPos(new Vec3(0.0, 5.0, 0.0)).endPos(new Vec3(0.0, 13.0, 0.0)).time((float)startFrame / 60.0f, (float)endFrame / 60.0f).lifetime(15).interpolations(15).updateInterval(1).joint("spear").itemSkinHand(InteractionHand.MAIN_HAND).texture("wraithon:textures/particle/vatansever.png").type((SimpleParticleType)EpicFightParticles.SWING_TRAIL.get()).create();
    }

    public static Vec3 getJointWorldPos(WraithonEntityPatch entityPatch, Joint joint) {
        return WraithonAnimations.getJointWorldPos(entityPatch, joint, Vec3f.ZERO);
    }

    public static Vec3 getJointWorldRawPos(WraithonEntityPatch entityPatch, Joint joint, float time) {
        return WraithonAnimations.getJointWorldRawPos(entityPatch, joint, time, Vec3f.ZERO);
    }

    public static Vec3 getJointWorldPos(WraithonEntityPatch entityPatch, Joint joint, Vec3f offset) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        OpenMatrix4f transformMatrix = entityPatch.getArmature().getBoundTransformFor(entityPatch.getAnimator().getPose(0.1f), joint);
        transformMatrix.translate(offset);
        OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(180.0f + ((WraithonEntity)entityPatch.getOriginal()).getCorrectYRot(0.0f))), new Vec3f(0.0f, 1.0f, 0.0f));
        OpenMatrix4f.mul((OpenMatrix4f)rotation, (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
        Vec3 pos = new Vec3((double)(transformMatrix.m30 + (float)entity.m_20185_()), (double)(transformMatrix.m31 + (float)entity.m_20186_()), (double)(transformMatrix.m32 + (float)entity.m_20189_()));
        return pos;
    }

    public static Vec3 getJointWorldRawPos(WraithonEntityPatch entityPatch, Joint joint, float time, Vec3f offset) {
        Animator animator = entityPatch.getAnimator();
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        Pose pose = ((DynamicAnimation)animator.getPlayerFor(null).getAnimation().get()).getRawPose(time);
        OpenMatrix4f transformMatrix = entityPatch.getArmature().getBoundTransformFor(pose, joint);
        transformMatrix.translate(offset);
        OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(180.0f + ((WraithonEntity)entityPatch.getOriginal()).getCorrectYRot(0.0f))), new Vec3f(0.0f, 1.0f, 0.0f));
        OpenMatrix4f.mul((OpenMatrix4f)rotation, (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
        Vec3 pos = new Vec3((double)(transformMatrix.m30 + (float)entity.m_20185_()), (double)(transformMatrix.m31 + (float)entity.m_20186_()), (double)(transformMatrix.m32 + (float)entity.m_20189_()));
        return pos;
    }

    public static AnimationEvent.InTimeEvent knockFly(int startFrame, double radius) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Level patt56011$temp = ((LivingEntity)entityPatch.getOriginal()).m_9236_();
            if (patt56011$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt56011$temp;
                Vec3 center = ((LivingEntity)entityPatch.getOriginal()).m_20182_();
                AABB area = new AABB(center.m_7096_() - radius, center.m_7098_() - radius, center.m_7094_() - radius, center.m_7096_() + radius, center.m_7098_() + radius, center.m_7094_() + radius);
                List entities = serverLevel.m_6443_(LivingEntity.class, area, entity -> entity.m_6084_() && entity.m_20238_(center) <= radius * radius && entity != entityPatch.getOriginal());
                for (LivingEntity entity2 : entities) {
                    if (!(entity2.m_20182_().m_82554_(((LivingEntity)entityPatch.getOriginal()).m_20182_()) < radius) || EpicFightCapabilities.getEntityPatch((Entity)entity2, LivingEntityPatch.class) == null) continue;
                    ((LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)entity2, LivingEntityPatch.class)).playAnimationSynchronized(BIPE_KNOCK_FLY, 0.0f);
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static boolean wCircleSlamFracture(@Nullable LivingEntity caster, Level level, Vec3 center, double radius) {
        Vec3 closestEdge = new Vec3((double)Math.round(center.f_82479_), Math.floor(center.f_82480_), (double)Math.round(center.f_82481_));
        Vec3 centerOfBlock = new Vec3(Math.floor(center.f_82479_) + 0.5, Math.floor(center.f_82480_), Math.floor(center.f_82481_) + 0.5);
        center = closestEdge.m_82557_(center) < centerOfBlock.m_82557_(center) ? closestEdge : centerOfBlock;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(center.f_82479_, center.f_82480_, center.f_82481_);
        BlockState originBlockState = level.m_8055_((BlockPos)blockPos);
        if (!LevelUtil.canTransferShockWave((Level)level, (BlockPos)blockPos, (BlockState)originBlockState)) {
            return false;
        }
        radius = Math.max(0.5, radius);
        if (!level.f_46443_) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisChunkWithSelf((Object)new SPFracture(center, radius, true, false), (LevelChunk)level.m_46745_((BlockPos)blockPos), (Object[])new Object[0]);
        }
        int xFrom = (int)Math.floor(center.f_82479_ - radius);
        int xTo = (int)Math.ceil(center.f_82479_ + radius);
        int zFrom = (int)Math.floor(center.f_82481_ - radius);
        int zTo = (int)Math.ceil(center.f_82481_ + radius);
        ArrayList entityBeingHit = Lists.newArrayList();
        for (int i = zFrom; i <= zTo; ++i) {
            for (int j = xFrom; j <= xTo; j += i != zFrom && i != zTo ? xTo - xFrom : 1) {
                Vec3 direction = new Vec3((double)j - center.f_82479_ + 0.1, 0.0, (double)i - center.f_82481_);
                LevelUtil.spreadShockwave((Level)level, (Vec3)center, (Vec3)direction, (double)radius, (int)j, (int)i, (List)entityBeingHit);
            }
        }
        if (!level.f_46443_) {
            for (Entity entity : entityBeingHit) {
                LivingEntityPatch livingEntityPatch;
                if (entity.m_7306_((Entity)caster) || !((livingEntityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, LivingEntityPatch.class)) instanceof HumanoidMobPatch)) continue;
                livingEntityPatch.playAnimationSynchronized(BIPE_KNOCK_FLY, 0.1f);
            }
        } else {
            boolean smallSlam;
            CameraShake.shake((int)20, (float)25.0f, (float)0.3f, (Vec3)center, (float)50.0f);
            boolean bl = smallSlam = radius < 1.5;
            if (!smallSlam) {
                level.m_7106_((ParticleOptions)EpicFightParticles.GROUND_SLAM.get(), center.f_82479_, center.f_82480_, center.f_82481_, 1.0, radius * 10.0, 0.5);
            }
        }
        return true;
    }

    public static void createJointSphereParticles(LivingEntityPatch<?> entityPatch, Joint joint, ParticleOptions particleOptions, double radius, double minSpeed, double maxSpeed, int particleCount) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        Level level = entity.m_9236_();
        if (entityPatch instanceof WraithonEntityPatch) {
            WraithonEntityPatch wraithonEntityPatch = (WraithonEntityPatch)entityPatch;
            Vec3 vec3 = WraithonAnimations.getJointWorldPos(wraithonEntityPatch, joint);
            RandomSource random = level.f_46441_;
            for (int i = 0; i < particleCount; ++i) {
                double angle = random.m_188500_() * 2.0 * Math.PI;
                double pitch = Math.acos(2.0 * random.m_188500_() - 1.0) - 1.5707963267948966;
                double offsetX = Math.cos(angle) * Math.cos(pitch);
                double offsetY = Math.sin(pitch);
                double offsetZ = Math.sin(angle) * Math.cos(pitch);
                double x = vec3.m_7096_() + offsetX * radius;
                double y = vec3.m_7098_() + offsetY * radius;
                double z = vec3.m_7094_() + offsetZ * radius;
                double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
                if (!level.f_46443_) continue;
                level.m_6493_(particleOptions, true, x, y, z, offsetX * speed, offsetY * speed, offsetZ * speed);
            }
        }
    }

    static {
        ARMATURE = WraithonArmature.WRAITHON_ARMATURE;
        SWORD = new MultiOBBCollider(10, 0.2, 6.0, 0.5, 0.0, 6.0, 0.0);
        FLY_SWORD = new MultiOBBCollider(10, 0.2, 5.0, 0.5, 0.0, 5.5, 0.0);
        SPEAR_1 = new MultiOBBCollider(10, 0.2, 3.0, 0.5, 0.0, 8.5, 0.0);
        SPEAR_2 = new MultiOBBCollider(10, 0.2, 2.4, 2.5, 0.0, 7.0, 0.0);
    }
}

