/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.wraithon.epicfight.animation;

import com.merlin204.avalon.entity.vfx.VFXEntityPatch;
import com.merlin204.avalon.epicfight.animations.AutoDiscardAttackAnimation;
import com.merlin204.avalon.epicfight.animations.AvalonAttackAnimation;
import com.merlin204.avalon.util.AvalonAnimationUtils;
import com.merlin204.avalon.util.AvalonEventUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.merlin204.wraithon.avalon.WraithonVFXManagers;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.collider.MultiOBBCollider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;

public class WraithonVFXAnimations {
    private static final Collider SWORD = new MultiOBBCollider(10, 0.5, 6.0, 0.2, 0.0, 6.0, 0.0);
    private static final Collider SPEAR = new MultiOBBCollider(10, 2.5, 4.0, 0.2, 0.0, 7.0, 0.0);
    public static AnimationManager.AnimationAccessor<AutoDiscardAttackAnimation> SWORD_1;
    public static AnimationManager.AnimationAccessor<AutoDiscardAttackAnimation> SWORD_2;
    public static AnimationManager.AnimationAccessor<AutoDiscardAttackAnimation> SPEAR_1;
    public static AnimationManager.AnimationAccessor<AutoDiscardAttackAnimation> SPEAR_2;

    public static void buildVFXAnimations(AnimationManager.AnimationBuilder builder) {
        Armatures.ArmatureAccessor sword = Armatures.ArmatureAccessor.create((String)"wraithon", (String)"entity/vfx/sword", Armature::new);
        Armatures.ArmatureAccessor spear = Armatures.ArmatureAccessor.create((String)"wraithon", (String)"entity/vfx/spear", Armature::new);
        SWORD_1 = builder.nextAccessor("vfx/sword_1", accessor -> (AutoDiscardAttackAnimation)new AutoDiscardAttackAnimation(0.0f, accessor, (AssetAccessor)sword, new AvalonAttackAnimation.AvalonPhase[]{AvalonAnimationUtils.createSimplePhase((int)30, (int)40, (int)50, (InteractionHand)InteractionHand.MAIN_HAND, (Joint)sword.get().searchJointByName("weapon"), (Collider)SWORD)}).addEvents(new AnimationEvent[]{AvalonEventUtils.simpleGroundSplit((int)32, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (float)3.0f, (boolean)false), WraithonVFXAnimations.createRing(0, (ParticleOptions)ParticleTypes.f_123755_, 3.0, 100), AvalonEventUtils.startDispersed((int)45, (float)0.07f), AvalonEventUtils.simpleCameraShake((int)32, (int)20, (float)10.0f, (float)0.2f, (float)8.0f)}));
        SWORD_2 = builder.nextAccessor("vfx/sword_2", accessor -> (AutoDiscardAttackAnimation)new AutoDiscardAttackAnimation(0.0f, accessor, (AssetAccessor)sword, new AvalonAttackAnimation.AvalonPhase[]{AvalonAnimationUtils.createSimplePhase((int)30, (int)40, (int)50, (InteractionHand)InteractionHand.MAIN_HAND, (Joint)sword.get().searchJointByName("weapon"), (Collider)SWORD)}).addEvents(new AnimationEvent[]{AvalonEventUtils.simpleGroundSplit((int)36, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (float)5.0f, (boolean)false), WraithonVFXAnimations.createRing(0, (ParticleOptions)ParticleTypes.f_123755_, 14.0, 100), WraithonVFXAnimations.createSpearRing(65, 4, 2.0f, 4.0f), WraithonVFXAnimations.createSpearRing(75, 8, 4.0f, 6.0f), WraithonVFXAnimations.createSpearRing(85, 12, 6.0f, 8.0f), WraithonVFXAnimations.createSpearRing(95, 16, 8.0f, 10.0f), WraithonVFXAnimations.createSpearRing(105, 20, 10.0f, 12.0f), WraithonVFXAnimations.createSpearRing(115, 24, 12.0f, 14.0f), AvalonEventUtils.startDispersed((int)65, (float)0.03f), AvalonEventUtils.simpleCameraShake((int)36, (int)20, (float)10.0f, (float)0.2f, (float)8.0f)}));
        SPEAR_1 = builder.nextAccessor("vfx/spear_1", accessor -> (AutoDiscardAttackAnimation)new AutoDiscardAttackAnimation(0.0f, accessor, (AssetAccessor)spear, new AvalonAttackAnimation.AvalonPhase[]{AvalonAnimationUtils.createSimplePhase((int)30, (int)40, (int)50, (InteractionHand)InteractionHand.MAIN_HAND, (Joint)spear.get().searchJointByName("weapon"), (Collider)SPEAR)}).addEvents(new AnimationEvent[]{AvalonEventUtils.startDispersed((int)75, (float)0.04f), AvalonEventUtils.simpleCameraShake((int)34, (int)20, (float)5.0f, (float)0.2f, (float)6.0f)}));
        SPEAR_2 = builder.nextAccessor("vfx/spear_2", accessor -> (AutoDiscardAttackAnimation)new AutoDiscardAttackAnimation(0.0f, accessor, (AssetAccessor)spear, 10.0f, new AvalonAttackAnimation.AvalonPhase[]{AvalonAnimationUtils.createSimplePhase((int)0, (int)40, (int)50, (InteractionHand)InteractionHand.MAIN_HAND, (Joint)sword.get().searchJointByName("weapon"), (Collider)SPEAR)}).addEvents(new AnimationEvent[]{AvalonEventUtils.simpleGroundSplit((int)40, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (float)10.0f, (boolean)false), WraithonVFXAnimations.createRing(0, (ParticleOptions)ParticleTypes.f_123755_, 22.0, 200), WraithonVFXAnimations.createSpearRing(65, 4, 2.0f, 4.0f), WraithonVFXAnimations.createSpearRing(75, 8, 4.0f, 6.0f), WraithonVFXAnimations.createSpearRing(85, 12, 6.0f, 8.0f), WraithonVFXAnimations.createSpearRing(95, 16, 8.0f, 10.0f), WraithonVFXAnimations.createSpearRing(105, 20, 10.0f, 12.0f), WraithonVFXAnimations.createSpearRing(115, 24, 12.0f, 14.0f), WraithonVFXAnimations.createSpearRing(125, 24, 14.0f, 16.0f), WraithonVFXAnimations.createSpearRing(135, 24, 16.0f, 18.0f), WraithonVFXAnimations.createSpearRing(145, 24, 20.0f, 22.0f), AvalonEventUtils.startDispersed((int)45, (float)0.03f), AvalonEventUtils.simpleCameraShake((int)40, (int)20, (float)10.0f, (float)0.2f, (float)22.0f)}));
    }

    private static AnimationEvent.InTimeEvent createSpearRing(int startFrame, int Count, float innerRadius, float outerRadius) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            if (!(entityPatch instanceof VFXEntityPatch)) {
                return;
            }
            VFXEntityPatch vfxEntityPatch = (VFXEntityPatch)entityPatch;
            Level level = ((LivingEntity)entityPatch.getOriginal()).m_9236_();
            Vec3 center = ((LivingEntity)entityPatch.getOriginal()).m_20182_();
            RandomSource random = level.f_46441_;
            for (int i = 0; i < Count; ++i) {
                double angle = (double)(i * 2) * Math.PI / (double)Count;
                double radius = (double)innerRadius + random.m_188500_() * (double)(outerRadius - innerRadius);
                double x = center.f_82479_ + radius * Math.cos(angle);
                double y = center.f_82480_;
                double z = center.f_82481_ + radius * Math.sin(angle);
                WraithonVFXManagers.SPEAR_1.spawnVFXEntity((LivingEntity)vfxEntityPatch.getOwnerPatch().getOriginal(), new Vec3(x, y, z), new Vec3f((random.m_188501_() - 0.5f) * 30.0f, (random.m_188501_() - 0.5f) * 30.0f, (random.m_188501_() - 0.5f) * 30.0f), 1.0f);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    private static AnimationEvent.InTimeEvent createRing(int startFrame, ParticleOptions particleOptions, double radius, int particleCount) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Level level = ((LivingEntity)entityPatch.getOriginal()).m_9236_();
            Vec3 center = ((LivingEntity)entityPatch.getOriginal()).m_20182_();
            RandomSource random = level.f_46441_;
            for (int i = 0; i < particleCount; ++i) {
                double angle = random.m_188500_() * 2.0 * Math.PI;
                double x = center.m_7096_() + Math.cos(angle) * radius;
                double y = center.m_7098_();
                double z = center.m_7094_() + Math.sin(angle) * radius;
                level.m_6493_(particleOptions, true, x, y, z, 0.0, 0.01, 0.0);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }
}

