/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.wraithon.event;

import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.merlin204.wraithon.client.gui.WraithonBossBarRenderer;
import org.merlin204.wraithon.entity.WraithonEntities;
import org.merlin204.wraithon.network.PacketHandler;
import org.merlin204.wraithon.network.PacketRelay;
import org.merlin204.wraithon.network.packet.client.SyncBossBarPacket;
import org.merlin204.wraithon.util.DimensionResourceCopier;
import org.merlin204.wraithon.worldgen.WraithonDimensions;

@Mod.EventBusSubscriber(modid="wraithon")
public class ForgeEvents {
    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            WraithonBossBarRenderer.BOSSES.forEach((uuid, integer) -> PacketRelay.sendToPlayer(PacketHandler.INSTANCE, new SyncBossBarPacket((UUID)uuid, (int)integer), serverPlayer));
            ServerLevel serverLevel = serverPlayer.m_284548_();
            if (WraithonDimensions.SANCTUM_OF_THE_WRAITHON_LEVEL_KEY == serverLevel.m_46472_()) {
                ForgeEvents.checkWraithon(serverLevel);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Level level;
        if (WraithonDimensions.SANCTUM_OF_THE_WRAITHON_LEVEL_KEY == event.getTo() && (level = event.getEntity().m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ForgeEvents.checkWraithon(serverLevel);
        }
    }

    public static void checkWraithon(ServerLevel serverLevel) {
        List entities = serverLevel.m_143280_((EntityTypeTest)WraithonEntities.WRAITHON.get(), wraithonEntity -> true);
    }

    @SubscribeEvent
    public static void onLivingJoin(EntityJoinLevelEvent event) {
        if (List.of(EntityType.f_20479_, EntityType.f_20554_).contains(event.getEntity().m_6095_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBreakBlock(BlockEvent.EntityPlaceEvent event) {
        ServerLevel serverLevel;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).m_46472_() == WraithonDimensions.SANCTUM_OF_THE_WRAITHON_LEVEL_KEY) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBreakBlock(BlockEvent.BreakEvent event) {
        ServerLevel serverLevel;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).m_46472_() == WraithonDimensions.SANCTUM_OF_THE_WRAITHON_LEVEL_KEY) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        DimensionResourceCopier.copyDimensionToSaves(event.getServer());
    }
}

