/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.wraithon.network.packet;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.merlin204.wraithon.entity.wraithon.WraithonEntity;
import org.merlin204.wraithon.entity.wraithon.WraithonPartEntity;
import org.merlin204.wraithon.network.packet.BasePacket;

public class SyncPartEntityBrokenPacket
implements BasePacket {
    private final int ownerId;
    private final int partId;
    private final boolean isBroken;

    public SyncPartEntityBrokenPacket(int ownerId, int partId, boolean isBroken) {
        this.ownerId = ownerId;
        this.partId = partId;
        this.isBroken = isBroken;
    }

    public static SyncPartEntityBrokenPacket decode(FriendlyByteBuf buf) {
        int ownerId = buf.readInt();
        int partId = buf.readInt();
        boolean isBroken = buf.readBoolean();
        return new SyncPartEntityBrokenPacket(ownerId, partId, isBroken);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.ownerId);
        buf.writeInt(this.partId);
        buf.writeBoolean(this.isBroken);
    }

    @Override
    public void execute(Player player) {
        Entity entity;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (entity = level.m_6815_(this.ownerId)) instanceof WraithonEntity) {
            WraithonEntity wraithonEntity = (WraithonEntity)entity;
            for (WraithonPartEntity wraithonPartEntity : wraithonEntity.getSubEntities()) {
                if (wraithonPartEntity.joint.getId() != this.partId) continue;
                wraithonPartEntity.setBroken(this.isBroken);
            }
        }
    }
}

