/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fastprojectileapi.collision;

import dev.xkmc.fastprojectileapi.collision.FastMap;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashMap;
import net.minecraft.core.SectionPos;

public class FastMapInit {
    private static boolean useFast = true;

    public static <T> FastMap<T> createFastMap() {
        return useFast ? new LongFastMap() : new HashFastMap();
    }

    public static void init() {
        long hash = FastMapInit.hash();
        long fast = FastMapInit.fast();
        YoukaisHomecoming.LOGGER.info("HashMap test result: hash=" + hash + ", L2O=" + fast);
        useFast = (double)fast < (double)hash * 0.8;
    }

    private static long fast() {
        int r = 1;
        long t0 = System.currentTimeMillis();
        for (int k = 0; k < 20; ++k) {
            Long2ObjectOpenHashMap map = new Long2ObjectOpenHashMap();
            for (int i = 0; i < 2000; ++i) {
                for (int x = -r; x <= r; ++x) {
                    for (int y = -r; y <= r; ++y) {
                        for (int z = -r; z <= r; ++z) {
                            long val = SectionPos.m_123209_((int)x, (int)y, (int)z);
                            if (map.containsKey(val)) continue;
                            map.put(val, (Object)1);
                        }
                    }
                }
            }
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    private static long hash() {
        int r = 1;
        long t0 = System.currentTimeMillis();
        for (int k = 0; k < 20; ++k) {
            HashMap<SectionPos, Integer> map = new HashMap<SectionPos, Integer>();
            for (int i = 0; i < 2000; ++i) {
                for (int x = -r; x <= r; ++x) {
                    for (int y = -r; y <= r; ++y) {
                        for (int z = -r; z <= r; ++z) {
                            SectionPos vec = SectionPos.m_123173_((int)x, (int)y, (int)z);
                            if (map.containsKey(vec)) continue;
                            map.put(vec, 1);
                        }
                    }
                }
            }
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    private static class LongFastMap<T>
    implements FastMap<T> {
        private final Long2ObjectOpenHashMap<T> map = new Long2ObjectOpenHashMap(1024);

        private LongFastMap() {
        }

        @Override
        public boolean containsKey(int x, int y, int z) {
            return this.map.containsKey(SectionPos.m_123209_((int)x, (int)y, (int)z));
        }

        @Override
        public void put(int x, int y, int z, T e) {
            this.map.put(SectionPos.m_123209_((int)x, (int)y, (int)z), e);
        }

        @Override
        public T get(int x, int y, int z) {
            return (T)this.map.get(SectionPos.m_123209_((int)x, (int)y, (int)z));
        }
    }

    private static class HashFastMap<T>
    implements FastMap<T> {
        private final HashMap<SectionPos, T> map = new HashMap(1024);

        private HashFastMap() {
        }

        @Override
        public boolean containsKey(int x, int y, int z) {
            return this.map.containsKey(SectionPos.m_123173_((int)x, (int)y, (int)z));
        }

        @Override
        public void put(int x, int y, int z, T e) {
            this.map.put(SectionPos.m_123173_((int)x, (int)y, (int)z), e);
        }

        @Override
        public T get(int x, int y, int z) {
            return this.map.get(SectionPos.m_123173_((int)x, (int)y, (int)z));
        }
    }
}

