/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fastprojectileapi.collision;

import dev.xkmc.fastprojectileapi.collision.EntityStorageCache;
import dev.xkmc.fastprojectileapi.collision.IEntityCache;
import dev.xkmc.fastprojectileapi.collision.ProjectileHitHelper;
import dev.xkmc.fastprojectileapi.entity.BaseLaser;
import dev.xkmc.fastprojectileapi.entity.EntityCachingUser;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LaserHitHelper {
    public static LaserHitResult getHitResultOnProjection(BaseLaser e, boolean checkBlock, boolean checkEntity) {
        Vec3 src = e.m_20182_().m_82520_(0.0, (double)(e.m_20206_() / 2.0f), 0.0);
        Vec3 v = e.m_20156_().m_82490_(e.getLength());
        Level level = e.m_9236_();
        Vec3 dst = src.m_82549_(v);
        BlockHitResult bhit = null;
        if (checkBlock) {
            bhit = level.m_45547_(new ClipContext(src, dst, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)e));
            if (bhit.m_6662_() != HitResult.Type.MISS) {
                dst = bhit.m_82450_();
            } else {
                bhit = null;
            }
        }
        ArrayList<EntityHitResult> ehit = new ArrayList<EntityHitResult>();
        if (checkEntity && level instanceof ServerLevel) {
            IEntityCache iEntityCache;
            ServerLevel sl = (ServerLevel)level;
            float radius = e.getEffectiveHitRadius();
            float graze = e.grazeRange();
            AABB box = e.m_20191_().m_82369_(v);
            Entity entity = e.m_19749_();
            if (entity instanceof EntityCachingUser) {
                EntityCachingUser user = (EntityCachingUser)entity;
                iEntityCache = user.entityCache().get(sl, user.self());
            } else {
                iEntityCache = EntityStorageCache.get(sl);
            }
            EntityStorageCache cache = iEntityCache;
            List<Entity> list = cache.foreach(box.m_82400_((double)(1.0f + radius + graze)), e::canHitEntity);
            for (Entity x : list) {
                if (x == e) continue;
                Vec3 hit = ProjectileHitHelper.checkHit(x, e.alterHitBox(x, radius, 0.0f), src, dst);
                if (hit != null) {
                    ehit.add(new EntityHitResult(x, hit));
                }
                if (!(graze > 0.0f) || !(x instanceof Player)) continue;
                Player pl = (Player)x;
                Vec3 gr = ProjectileHitHelper.checkHit(x, e.alterHitBox(x, radius, graze), src, dst);
                if (gr == null) continue;
                e.doGraze(pl);
            }
        }
        return new LaserHitResult(dst, bhit, ehit);
    }

    public record LaserHitResult(Vec3 dst, @Nullable BlockHitResult bhit, List<EntityHitResult> ehit) {
    }
}

