/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.compat.jei;

import dev.xkmc.youkaishomecoming.content.pot.base.BasePotRecipe;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.common.utility.ClientRenderUtils;
import vectorwing.farmersdelight.common.utility.RecipeUtils;

public abstract class BasePotRecipeCategory<T extends BasePotRecipe>
implements IRecipeCategory<T> {
    protected final IDrawable timeIcon;
    protected final IDrawable expIcon;
    private final IDrawable background;
    private final IDrawable icon;

    public BasePotRecipeCategory(IGuiHelper helper, String path, ItemStack icon) {
        ResourceLocation backgroundImage = YoukaisHomecoming.loc("textures/gui/" + path + ".png");
        this.background = helper.createDrawable(backgroundImage, 29, 16, 116, 56);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)icon);
        this.timeIcon = helper.createDrawable(backgroundImage, 176, 32, 8, 11);
        this.expIcon = helper.createDrawable(backgroundImage, 176, 43, 9, 9);
    }

    public abstract RecipeType<T> getRecipeType();

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focusGroup) {
        NonNullList recipeIngredients = recipe.m_7527_();
        ItemStack resultStack = RecipeUtils.getResultItem(recipe);
        ItemStack containerStack = recipe.getOutputContainer();
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 2; ++column) {
                int inputIndex = row * 2 + column;
                if (inputIndex >= recipeIngredients.size()) continue;
                builder.addSlot(RecipeIngredientRole.INPUT, column * borderSlotSize + 6, row * borderSlotSize + 2).addItemStacks(Arrays.asList(((Ingredient)recipeIngredients.get(inputIndex)).m_43908_()));
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 92, 11).addItemStack(resultStack);
        if (!containerStack.m_41619_()) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 60, 38).addItemStack(containerStack);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 92, 38).addItemStack(resultStack);
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
    }

    public List<Component> getTooltipStrings(CookingPotRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (ClientRenderUtils.isCursorInsideBounds((int)61, (int)2, (int)22, (int)28, (double)mouseX, (double)mouseY)) {
            float experience;
            ArrayList<Component> tooltipStrings = new ArrayList<Component>();
            int cookTime = recipe.getCookTime();
            if (cookTime > 0) {
                int cookTimeSeconds = cookTime / 20;
                tooltipStrings.add((Component)Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds}));
            }
            if ((experience = recipe.getExperience()) > 0.0f) {
                tooltipStrings.add((Component)Component.m_237110_((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)}));
            }
            return tooltipStrings;
        }
        return Collections.emptyList();
    }
}

