/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.compat.jei;

import dev.xkmc.l2library.serial.recipe.BaseRecipeCategory;
import dev.xkmc.youkaishomecoming.content.item.fluid.BottleTexture;
import dev.xkmc.youkaishomecoming.content.item.fluid.BottledDrinkSet;
import dev.xkmc.youkaishomecoming.content.item.fluid.YHFluid;
import dev.xkmc.youkaishomecoming.content.pot.ferment.SimpleFermentationRecipe;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.data.YHLangData;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public class FermentRecipeCategory
extends BaseRecipeCategory<SimpleFermentationRecipe, FermentRecipeCategory> {
    protected static final ResourceLocation BG = YoukaisHomecoming.loc("textures/gui/ferment.png");

    public FermentRecipeCategory() {
        super(YoukaisHomecoming.loc("ferment"), SimpleFermentationRecipe.class);
    }

    public FermentRecipeCategory init(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(BG, 0, 0, 144, 54);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)YHBlocks.FERMENT.asStack());
        return this;
    }

    public Component getTitle() {
        return YHLangData.JEI_FERMENT.get(new Object[0]);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SimpleFermentationRecipe recipe, IFocusGroup focuses) {
        int x;
        int y;
        if (recipe.isSimple()) {
            ItemStack[] in = recipe.ingredients.get(0).m_43908_();
            ItemStack out = recipe.results.isEmpty() ? ItemStack.f_41583_ : recipe.results.get(0);
            int n = in.length;
            for (int i = 0; i < 8; ++i) {
                int y2 = i / 3 * 18 + 1;
                int x2 = i % 3 * 18 + 1;
                ItemStack[] inList = new ItemStack[n * 8];
                ItemStack[] outList = new ItemStack[n * 8];
                for (int j = 0; j < 8; ++j) {
                    for (int k = 0; k < n; ++k) {
                        if (j >= i) {
                            inList[j * n + k] = in[k];
                            outList[j * n + k] = out;
                            continue;
                        }
                        inList[j * n + k] = ItemStack.f_41583_;
                        outList[j * n + k] = ItemStack.f_41583_;
                    }
                }
                builder.addSlot(RecipeIngredientRole.INPUT, x2, y2).addItemStacks(List.of(inList));
                builder.addSlot(RecipeIngredientRole.OUTPUT, x2 + 90, y2).addItemStacks(List.of(outList));
            }
            return;
        }
        int n = 0;
        for (Ingredient stack : recipe.ingredients) {
            if (stack.m_43947_()) continue;
            y = n / 3 * 18 + 1;
            x = n % 3 * 18 + 1;
            builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients(stack);
            ++n;
        }
        if (!recipe.inputFluid.isEmpty()) {
            int y3 = n / 3 * 18 + 1;
            int x3 = n % 3 * 18 + 1;
            builder.addSlot(RecipeIngredientRole.INPUT, x3, y3).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of(recipe.inputFluid));
        }
        n = 0;
        for (ItemStack stack : recipe.results) {
            if (stack.m_41619_()) continue;
            y = n / 3 * 18 + 1;
            x = n % 3 * 18 + 91;
            builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStack(stack);
            ++n;
        }
        if (!recipe.outputFluid.isEmpty()) {
            int y4 = n / 3 * 18 + 1;
            int x4 = n % 3 * 18 + 91;
            Fluid x5 = recipe.outputFluid.getFluid();
            if (x5 instanceof YHFluid) {
                YHFluid sake = (YHFluid)x5;
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                list.add(sake.type.asStack(sake.type.count()));
                BottleTexture bottleTexture = sake.type.bottleSet();
                if (bottleTexture instanceof BottledDrinkSet) {
                    BottledDrinkSet set = (BottledDrinkSet)bottleTexture;
                    list.add(set.bottle.asStack(1));
                }
                builder.addSlot(RecipeIngredientRole.OUTPUT, x4, y4).addItemStacks(list);
                builder.addSlot(RecipeIngredientRole.INPUT, 64, 1).addItemStack(new ItemStack((ItemLike)sake.type.getContainer(), sake.type.count()));
            } else if (!recipe.defaultContainer.m_41619_() && !recipe.defaultBottle.m_41619_()) {
                builder.addSlot(RecipeIngredientRole.OUTPUT, x4, y4).addItemStack(recipe.defaultBottle);
                builder.addSlot(RecipeIngredientRole.INPUT, 64, 1).addItemStack(recipe.defaultContainer);
            } else {
                builder.addSlot(RecipeIngredientRole.OUTPUT, x4, y4).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of(recipe.outputFluid));
            }
        }
    }
}

