/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.compat.jei;

import dev.xkmc.l2library.serial.recipe.BaseRecipeCategory;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.youkaishomecoming.content.block.food.PotFoodBlock;
import dev.xkmc.youkaishomecoming.content.pot.cooking.core.PotCookingRecipe;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.data.YHLangData;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class PotCookingRecipeCategory
extends BaseRecipeCategory<PotCookingRecipe<?>, PotCookingRecipeCategory> {
    private final ItemStack iconStack;

    public PotCookingRecipeCategory(String id, ItemStack icon) {
        super(YoukaisHomecoming.loc(id), (Class)Wrappers.cast(PotCookingRecipe.class));
        this.iconStack = icon;
    }

    public PotCookingRecipeCategory init(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(152, 36);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)this.iconStack);
        return this;
    }

    public Component getTitle() {
        return YHLangData.JEI_COOKING.get(new Object[0]);
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, PotCookingRecipe<?> recipe, IFocusGroup focuses) {
        int n;
        int cookTime = recipe.getProcessTime();
        if (cookTime <= 0) {
            cookTime = 200;
        }
        int width = (n = this.compile(recipe.getInput()).size()) <= 5 ? n : (n + 1) / 2;
        builder.addAnimatedRecipeArrow(cookTime).setPosition(98 - (5 - width) * 9, 6);
        builder.addAnimatedRecipeFlame(300).setPosition(102 - (5 - width) * 9, 22);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PotCookingRecipe<?> recipe, IFocusGroup focuses) {
        BlockItem item;
        int x = 0;
        int y = 0;
        List<ItemStack[]> list = this.compile(recipe.getInput());
        int n = list.size();
        int width = n <= 5 ? n : (n + 1) / 2;
        int xff = 1 + (5 - width) * 9;
        int yff = n <= 5 ? 10 : 1;
        for (ItemStack[] ing : list) {
            builder.addSlot(RecipeIngredientRole.INPUT, x * 18 + xff, y * 18 + yff).setStandardSlotBackground().addItemStacks(List.of(ing));
            if (++x < width) continue;
            x = 0;
            ++y;
            xff = (width - n + 5) * 9 + 1;
        }
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        results.add(recipe.getResult());
        Item item2 = recipe.getResult().m_41720_();
        if (item2 instanceof BlockItem && (item2 = (item = (BlockItem)item2).m_40614_()) instanceof PotFoodBlock) {
            PotFoodBlock block = (PotFoodBlock)item2;
            results.add(block.asBowls());
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 131 - (5 - width) * 9, 10).setOutputSlotBackground().addItemStacks(results);
    }

    private List<ItemStack[]> compile(List<Ingredient> list) {
        Int2ObjectLinkedOpenHashMap set = new Int2ObjectLinkedOpenHashMap();
        for (Ingredient e : list) {
            if (e.m_43947_()) {
                set.put(1, (Object)new ItemStack[0]);
                continue;
            }
            ItemStack[] stacks = e.m_43908_();
            int result = 1;
            for (ItemStack stack : stacks) {
                int hash;
                if (stack.m_41619_()) {
                    hash = 0;
                } else {
                    hash = BuiltInRegistries.f_257033_.m_7447_((Object)stack.m_41720_());
                    CompoundTag tag = stack.m_41783_();
                    if (tag != null) {
                        hash += tag.hashCode() * 15;
                    }
                }
                result = 31 * result + hash;
            }
            ItemStack[] old = (ItemStack[])set.get(result);
            if (old != null) {
                for (ItemStack x : old) {
                    x.m_41769_(1);
                }
                continue;
            }
            ItemStack[] copy = (ItemStack[])stacks.clone();
            for (int i = 0; i < copy.length; ++i) {
                copy[i] = copy[i].m_41777_();
            }
            set.put(result, (Object)copy);
        }
        return new ArrayList<ItemStack[]>((Collection<ItemStack[]>)set.values());
    }
}

