/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.compat.jei;

import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.youkaishomecoming.compat.jei.BasinRecipeCategory;
import dev.xkmc.youkaishomecoming.compat.jei.CuisineRecipeCategory;
import dev.xkmc.youkaishomecoming.compat.jei.DryingRackCategory;
import dev.xkmc.youkaishomecoming.compat.jei.FermentRecipeCategory;
import dev.xkmc.youkaishomecoming.compat.jei.KettleRecipeCategory;
import dev.xkmc.youkaishomecoming.compat.jei.MokaRecipeCategory;
import dev.xkmc.youkaishomecoming.compat.jei.PotCookingRecipeCategory;
import dev.xkmc.youkaishomecoming.compat.jei.SteamingCategory;
import dev.xkmc.youkaishomecoming.content.item.fluid.SlipBottleItem;
import dev.xkmc.youkaishomecoming.content.pot.basin.SimpleBasinRecipe;
import dev.xkmc.youkaishomecoming.content.pot.cooking.core.PotCookingRecipe;
import dev.xkmc.youkaishomecoming.content.pot.ferment.SimpleFermentationRecipe;
import dev.xkmc.youkaishomecoming.content.pot.kettle.KettleRecipe;
import dev.xkmc.youkaishomecoming.content.pot.moka.MokaMenu;
import dev.xkmc.youkaishomecoming.content.pot.moka.MokaRecipe;
import dev.xkmc.youkaishomecoming.content.pot.moka.MokaScreen;
import dev.xkmc.youkaishomecoming.content.pot.rack.DryingRackRecipe;
import dev.xkmc.youkaishomecoming.content.pot.steamer.SteamingRecipe;
import dev.xkmc.youkaishomecoming.content.pot.table.recipe.CuisineRecipe;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import dev.xkmc.youkaishomecoming.init.registrate.YHItems;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;
import vectorwing.farmersdelight.common.registry.ModBlocks;

@JeiPlugin
public class YHJeiPlugin
implements IModPlugin {
    public static final ResourceLocation ID = YoukaisHomecoming.loc("main");
    public static final RecipeType<MokaRecipe> MOKA = RecipeType.create((String)"youkaishomecoming", (String)"moka", MokaRecipe.class);
    public static final RecipeType<KettleRecipe> KETTLE = RecipeType.create((String)"youkaishomecoming", (String)"kettle", KettleRecipe.class);
    public static final RecipeType<DryingRackRecipe> RACK = RecipeType.create((String)"youkaishomecoming", (String)"drying_rack", DryingRackRecipe.class);
    public static final RecipeType<SteamingRecipe> STEAM = RecipeType.create((String)"youkaishomecoming", (String)"steaming", SteamingRecipe.class);
    public static final RecipeType<SimpleFermentationRecipe> FERMENT = RecipeType.create((String)"youkaishomecoming", (String)"ferment", SimpleFermentationRecipe.class);
    public static final RecipeType<CuisineRecipe<?>> CUISINE = RecipeType.create((String)"youkaishomecoming", (String)"cuisine", (Class)((Class)Wrappers.cast(CuisineRecipe.class)));
    public static final RecipeType<SimpleBasinRecipe> BASIN = RecipeType.create((String)"youkaishomecoming", (String)"basin", SimpleBasinRecipe.class);
    public static final RecipeType<PotCookingRecipe<?>> BOWL_COOKING = RecipeType.create((String)"youkaishomecoming", (String)"bowl_cooking", (Class)((Class)Wrappers.cast(PotCookingRecipe.class)));
    public static final RecipeType<PotCookingRecipe<?>> POT_COOKING = RecipeType.create((String)"youkaishomecoming", (String)"pot_cooking", (Class)((Class)Wrappers.cast(PotCookingRecipe.class)));
    public static final RecipeType<PotCookingRecipe<?>> STOCK_COOKING = RecipeType.create((String)"youkaishomecoming", (String)"stock_cooking", (Class)((Class)Wrappers.cast(PotCookingRecipe.class)));

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)YHItems.SAKE_BOTTLE.get(), this::slipSubType);
    }

    private String slipSubType(ItemStack stack, UidContext uid) {
        return ((ResourceKey)SlipBottleItem.getFluid(stack).getFluid().m_205069_().m_203543_().orElseThrow()).m_135782_().toString();
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new MokaRecipeCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new KettleRecipeCategory().init(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new DryingRackCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SteamingCategory(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FermentRecipeCategory().init(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new BasinRecipeCategory().init(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CuisineRecipeCategory().init(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PotCookingRecipeCategory("bowl_cooking", YHBlocks.IRON_BOWL.asStack()).init(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PotCookingRecipeCategory("pot_cooking", YHBlocks.IRON_POT.asStack()).init(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PotCookingRecipeCategory("stock_cooking", YHBlocks.STOCKPOT.asStack()).init(helper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        assert (level != null);
        RecipeManager m = level.m_7465_();
        registration.addRecipes(MOKA, m.m_44013_((net.minecraft.world.item.crafting.RecipeType)YHBlocks.MOKA_RT.get()));
        registration.addRecipes(KETTLE, m.m_44013_((net.minecraft.world.item.crafting.RecipeType)YHBlocks.KETTLE_RT.get()));
        registration.addRecipes(RACK, m.m_44013_((net.minecraft.world.item.crafting.RecipeType)YHBlocks.RACK_RT.get()));
        registration.addRecipes(STEAM, m.m_44013_((net.minecraft.world.item.crafting.RecipeType)YHBlocks.STEAM_RT.get()));
        registration.addRecipes(FERMENT, m.m_44013_((net.minecraft.world.item.crafting.RecipeType)YHBlocks.FERMENT_RT.get()).stream().map(e -> {
            SimpleFermentationRecipe x;
            return e instanceof SimpleFermentationRecipe ? (x = (SimpleFermentationRecipe)e) : null;
        }).filter(Objects::nonNull).toList());
        registration.addRecipes(BASIN, m.m_44013_((net.minecraft.world.item.crafting.RecipeType)YHBlocks.BASIN_RT.get()).stream().map(e -> {
            SimpleBasinRecipe x;
            return e instanceof SimpleBasinRecipe ? (x = (SimpleBasinRecipe)((Object)e)) : null;
        }).filter(Objects::nonNull).toList());
        registration.addRecipes(CUISINE, m.m_44013_((net.minecraft.world.item.crafting.RecipeType)YHBlocks.CUISINE_RT.get()));
        registration.addRecipes(BOWL_COOKING, m.m_44013_((net.minecraft.world.item.crafting.RecipeType)YHBlocks.COOKING_RT.get()).stream().filter(e -> e.matchContainer(YHBlocks.IRON_BOWL.m_5456_())).toList());
        registration.addRecipes(POT_COOKING, m.m_44013_((net.minecraft.world.item.crafting.RecipeType)YHBlocks.COOKING_RT.get()).stream().filter(e -> e.matchContainer(YHBlocks.IRON_POT.m_5456_())).toList());
        registration.addRecipes(STOCK_COOKING, m.m_44013_((net.minecraft.world.item.crafting.RecipeType)YHBlocks.COOKING_RT.get()).stream().filter(e -> e.matchContainer(YHBlocks.STOCKPOT.m_5456_())).toList());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(YHBlocks.MOKA.asStack(), new RecipeType[]{MOKA});
        registration.addRecipeCatalyst(YHBlocks.KETTLE.asStack(), new RecipeType[]{KETTLE});
        registration.addRecipeCatalyst(YHBlocks.RACK.asStack(), new RecipeType[]{RACK});
        registration.addRecipeCatalyst(YHBlocks.FERMENT.asStack(), new RecipeType[]{FERMENT});
        registration.addRecipeCatalyst(YHBlocks.BASIN.asStack(), new RecipeType[]{BASIN});
        registration.addRecipeCatalyst(YHBlocks.STEAMER_LID.asStack(), new RecipeType[]{STEAM});
        registration.addRecipeCatalyst(YHBlocks.STEAMER_RACK.asStack(), new RecipeType[]{STEAM});
        registration.addRecipeCatalyst(YHBlocks.STEAMER_POT.asStack(), new RecipeType[]{STEAM});
        registration.addRecipeCatalyst(YHBlocks.CUISINE_BOARD.asStack(), new RecipeType[]{CUISINE});
        registration.addRecipeCatalyst(YHBlocks.IRON_BOWL.asStack(), new RecipeType[]{BOWL_COOKING});
        registration.addRecipeCatalyst(YHBlocks.IRON_POT.asStack(), new RecipeType[]{POT_COOKING});
        registration.addRecipeCatalyst(YHBlocks.STOCKPOT.asStack(), new RecipeType[]{STOCK_COOKING});
        registration.addRecipeCatalyst(((Block)ModBlocks.STOVE.get()).m_5456_().m_7968_(), new RecipeType[]{MOKA, KETTLE, STEAM, BOWL_COOKING, POT_COOKING, STOCK_COOKING});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(MokaScreen.class, 89, 25, 24, 17, new RecipeType[]{MOKA});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(MokaMenu.class, (MenuType)YHBlocks.MOKA_MT.get(), MOKA, 0, 4, 7, 36);
    }
}

