/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.block.food;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import dev.xkmc.l2library.base.L2Registrate;
import dev.xkmc.youkaishomecoming.content.block.food.ISteamerContentBlock;
import dev.xkmc.youkaishomecoming.content.block.food.IronBowlBlock;
import dev.xkmc.youkaishomecoming.content.block.variants.LeftClickBlock;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public class BowlBlock
extends HorizontalDirectionalBlock
implements ISteamerContentBlock,
LeftClickBlock {
    public static final Vec3 IRON_SHAPE = new Vec3(4.0, 4.0, 4.0);
    public static final Vec3 WOOD_SHAPE = new Vec3(5.0, 3.0, 5.0);
    public static final Vec3 BAMBOO_SHAPE = new Vec3(2.0, 3.0, 5.5);
    public static final Vec3 RAW_BAMBOO_SHAPE = new Vec3(2.0, 5.0, 5.5);
    public static final Vec3 POT_SHAPE = new Vec3(2.0, 6.0, 2.0);
    public static final Vec3 STOCKPOT_SHAPE = new Vec3(1.0, 15.0, 1.0);
    private final VoxelShape shape_x;
    private final VoxelShape shape_z;
    protected final ItemLike food;

    public BowlBlock(BlockBehaviour.Properties prop, Vec3 saucer, ItemLike food) {
        super(prop);
        this.food = food;
        this.shape_x = Block.m_49796_((double)saucer.f_82479_, (double)0.0, (double)saucer.f_82481_, (double)(16.0 - saucer.f_82479_), (double)saucer.f_82480_, (double)(16.0 - saucer.f_82481_));
        this.shape_z = Block.m_49796_((double)saucer.f_82481_, (double)0.0, (double)saucer.f_82479_, (double)(16.0 - saucer.f_82481_), (double)saucer.f_82480_, (double)(16.0 - saucer.f_82479_));
    }

    public BowlBlock(BlockBehaviour.Properties prop, Vec3 saucer) {
        super(prop);
        this.food = this;
        this.shape_x = Block.m_49796_((double)saucer.f_82479_, (double)0.0, (double)saucer.f_82481_, (double)(16.0 - saucer.f_82479_), (double)saucer.f_82480_, (double)(16.0 - saucer.f_82481_));
        this.shape_z = Block.m_49796_((double)saucer.f_82481_, (double)0.0, (double)saucer.f_82479_, (double)(16.0 - saucer.f_82481_), (double)saucer.f_82480_, (double)(16.0 - saucer.f_82479_));
    }

    @Override
    public float clearance() {
        return 2.0f;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return ((Direction)state.m_61143_((Property)f_54117_)).m_122434_() == Direction.Axis.Z ? this.shape_x : this.shape_z;
    }

    @Override
    public boolean leftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return this.collectBowl(state, level, pos, player, (Block)YHBlocks.WOOD_BOWL.get(), Items.f_42399_) || this.collectBowl(state, level, pos, player, (Block)YHBlocks.BAMBOO_BOWL.get(), Items.f_41911_) || this.collectBowl(state, level, pos, player, (Block)YHBlocks.IRON_BOWL.get(), YHBlocks.IRON_BOWL.m_5456_());
    }

    private boolean collectBowl(BlockState state, Level level, BlockPos pos, Player player, Block block, Item item) {
        if (state.m_60713_(block)) {
            if (!level.m_5776_()) {
                level.m_7471_(pos, false);
                player.m_150109_().m_150079_(item.m_7968_());
            }
            return true;
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        ItemStack item = this.food.m_5456_().m_7968_();
        FoodProperties food = item.getFoodProperties((LivingEntity)player);
        if (food == null || !player.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        if (!stack.m_41619_() && !stack.m_150930_((Item)YHBlocks.BIG_SPOON.get())) {
            return InteractionResult.PASS;
        }
        if (!level.m_5776_()) {
            player.m_5584_(level, item.m_41777_());
            this.consume(state, level, pos);
        }
        return InteractionResult.SUCCESS;
    }

    protected void consume(BlockState state, Level level, BlockPos pos) {
        Item item;
        ItemStack cont = this.m_5456_().m_7968_().getCraftingRemainingItem();
        if (cont.m_150930_(Items.f_41911_)) {
            level.m_46597_(pos, (BlockState)YHBlocks.BAMBOO_BOWL.getDefaultState().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_))));
        }
        if ((item = cont.m_41720_()) instanceof BlockItem) {
            BlockItem block = (BlockItem)item;
            level.m_46597_(pos, (BlockState)block.m_40614_().m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_))));
        } else {
            level.m_46597_(pos, (BlockState)YHBlocks.WOOD_BOWL.getDefaultState().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_))));
        }
    }

    private static void buildBowlModel(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockstateProvider pvd, String folder) {
        pvd.horizontalBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder("block/" + ctx.getName())).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("custom/bowl/" + folder + "/" + ctx.getName())))).texture("bowl", pvd.modLoc("block/bowl/" + folder + "/" + folder + "_bowl"))).texture("base", pvd.modLoc("block/bowl/" + folder + "/" + ctx.getName()))).renderType("cutout"));
    }

    public static BlockBuilder<IronBowlBlock, L2Registrate> ironBowl(String id) {
        return YoukaisHomecoming.REGISTRATE.block(id, p -> new IronBowlBlock((BlockBehaviour.Properties)p, IRON_SHAPE)).properties(p -> p.m_284180_(MapColor.f_283906_).m_60913_(0.5f, 6.0f).m_60918_(SoundType.f_56762_)).blockstate((ctx, pvd) -> BowlBlock.buildBowlModel((DataGenContext<Block, ? extends Block>)ctx, pvd, "iron")).tag(new TagKey[]{BlockTags.f_144282_});
    }

    public static BlockBuilder<BowlBlock, L2Registrate> ironBowlFood(String id) {
        return YoukaisHomecoming.REGISTRATE.block(id, p -> new BowlBlock((BlockBehaviour.Properties)p, IRON_SHAPE)).properties(p -> p.m_284180_(MapColor.f_283906_).m_60913_(0.5f, 6.0f).m_60918_(SoundType.f_56762_)).blockstate((ctx, pvd) -> BowlBlock.buildBowlModel((DataGenContext<Block, ? extends Block>)ctx, pvd, "iron")).tag(new TagKey[]{BlockTags.f_144282_});
    }

    public static BlockBuilder<BowlBlock, L2Registrate> woodBowlFood(String id) {
        return YoukaisHomecoming.REGISTRATE.block(id, p -> new BowlBlock((BlockBehaviour.Properties)p, WOOD_SHAPE)).properties(p -> p.m_284180_(MapColor.f_283825_).m_60913_(0.5f, 1.0f).m_60918_(SoundType.f_56736_)).blockstate((ctx, pvd) -> BowlBlock.buildBowlModel((DataGenContext<Block, ? extends Block>)ctx, pvd, "wood")).tag(new TagKey[]{BlockTags.f_144280_});
    }

    public static BlockBuilder<BowlBlock, L2Registrate> rawBambooBowl(String id) {
        return YoukaisHomecoming.REGISTRATE.block(id, p -> new BowlBlock((BlockBehaviour.Properties)p, RAW_BAMBOO_SHAPE)).properties(p -> p.m_284180_(MapColor.f_283915_).m_60913_(0.2f, 0.5f).m_60918_(SoundType.f_56736_)).blockstate((ctx, pvd) -> pvd.horizontalBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder("block/" + ctx.getName())).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("custom/bowl/bamboo/raw_bamboo")))).texture("bamboo", pvd.modLoc("block/bowl/bamboo/raw_bamboo"))).renderType("cutout"))).tag(new TagKey[]{BlockTags.f_144280_});
    }

    public static BlockBuilder<BowlBlock, L2Registrate> bambooBowl(String id) {
        return YoukaisHomecoming.REGISTRATE.block(id, p -> new BowlBlock((BlockBehaviour.Properties)p, BAMBOO_SHAPE)).properties(p -> p.m_284180_(MapColor.f_283915_).m_60913_(0.2f, 0.5f).m_60918_(SoundType.f_56736_)).blockstate((ctx, pvd) -> pvd.horizontalBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder("block/" + ctx.getName())).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("custom/bowl/bamboo/" + ctx.getName())))).texture("out", pvd.modLoc("block/bowl/bamboo/bamboo_bowl"))).texture("in", pvd.modLoc("block/bowl/bamboo/bamboo_inside"))).texture("leaf", pvd.modLoc("block/bowl/bamboo/bamboo_leaf"))).texture("base", pvd.modLoc("block/bowl/bamboo/" + ctx.getName()))).renderType("cutout"))).tag(new TagKey[]{BlockTags.f_144280_});
    }
}

