/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.block.plant;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeHooks;

public abstract class DoubleCropBlock
extends CropBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;

    public DoubleCropBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public abstract int getDoubleBlockStart();

    public boolean m_6724_(BlockState pState) {
        return pState.m_61143_(HALF) == DoubleBlockHalf.LOWER;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        int i;
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        if (pLevel.m_45524_(pPos, 0) >= 9 && (i = this.m_52305_(pState)) < this.m_7419_()) {
            float f = this.modifySpeed(pState, DoubleCropBlock.m_52272_((Block)this, (BlockGetter)pLevel, (BlockPos)pPos) * 0.04f);
            if (ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.m_188501_() < f ? 1 : 0) != 0)) {
                this.setGrowth((Level)pLevel, pPos, i + 1, 2);
                ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            }
        }
    }

    protected float modifySpeed(BlockState state, float val) {
        return val;
    }

    public void m_52263_(Level pLevel, BlockPos pPos, BlockState pState) {
        int j;
        int i;
        if (pState.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            BlockState lower = pLevel.m_8055_(pPos.m_7495_());
            if (lower.m_60713_((Block)this) && lower.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                pPos = pPos.m_7495_();
                pState = lower;
            } else {
                return;
            }
        }
        if ((i = this.m_52305_(pState) + this.m_7125_(pLevel)) > (j = this.m_7419_())) {
            i = j;
        }
        this.setGrowth(pLevel, pPos, i, 2);
    }

    public void setGrowth(Level level, BlockPos pos, int age, int flag) {
        if (age >= this.getDoubleBlockStart()) {
            boolean fail = level.m_151570_(pos.m_7494_());
            if (!fail) {
                BlockState above = level.m_8055_(pos.m_7494_());
                boolean bl = fail = !above.m_60713_((Block)this) && !above.m_247087_();
            }
            if (fail && (age = this.getDoubleBlockStart() - 1) < 0) {
                return;
            }
        }
        level.m_7731_(pos, this.m_52289_(age), flag);
        if (age >= this.getDoubleBlockStart()) {
            level.m_7731_(pos.m_7494_(), (BlockState)this.m_52289_(age).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), flag);
        } else {
            BlockState above = level.m_8055_(pos.m_7494_());
            if (above.m_60713_((Block)this) && above.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
                level.m_7471_(pos.m_7494_(), false);
            }
        }
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        if (pState.m_61143_(HALF) != DoubleBlockHalf.UPPER) {
            return super.m_7898_(pState, pLevel, pPos);
        }
        BlockState blockstate = pLevel.m_8055_(pPos.m_7495_());
        if (pState.m_60734_() != this) {
            return super.m_7898_(pState, pLevel, pPos);
        }
        return blockstate.m_60713_((Block)this) && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER;
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState sourceState, LevelAccessor level, BlockPos pos, BlockPos sourcePos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        if (half == DoubleBlockHalf.LOWER && dir == Direction.DOWN && !state.m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (dir.m_122434_() == Direction.Axis.Y) {
            boolean illegal;
            boolean bl = illegal = !sourceState.m_60713_((Block)this) || sourceState.m_61143_(HALF) == half;
            if (half == DoubleBlockHalf.UPPER && dir == Direction.DOWN && illegal) {
                return Blocks.f_50016_.m_49966_();
            }
            if (half == DoubleBlockHalf.LOWER && dir == Direction.UP && illegal && (Integer)state.m_61143_((Property)this.m_7959_()) >= this.getDoubleBlockStart()) {
                return Blocks.f_50016_.m_49966_();
            }
        }
        return super.m_7417_(state, dir, sourceState, level, pos, sourcePos);
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pLevel.f_46443_) {
            if (pPlayer.m_7500_()) {
                DoubleCropBlock.preventCreativeDropFromBottomPart(pLevel, pPos, pState, pPlayer);
            } else {
                DoubleCropBlock.m_49881_((BlockState)pState, (Level)pLevel, (BlockPos)pPos, null, (Entity)pPlayer, (ItemStack)pPlayer.m_21205_());
            }
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public void m_6240_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @Nullable BlockEntity pTe, ItemStack pStack) {
        super.m_6240_(pLevel, pPlayer, pPos, Blocks.f_50016_.m_49966_(), pTe, pStack);
    }

    protected static void preventCreativeDropFromBottomPart(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)pState.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = pLevel.m_8055_(blockpos = pPos.m_7495_())).m_60713_(pState.m_60734_()) && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockstate1 = blockstate.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            pLevel.m_7731_(blockpos, blockstate1, 35);
            pLevel.m_5898_(pPlayer, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }
}

