/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.block.plant.grape;

import dev.xkmc.youkaishomecoming.content.block.plant.grape.BaseCropVineBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.grape.BranchCropVineBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.rope.RopeLoggedCropBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;

public abstract class CenterCropVineBlock
extends BaseCropVineBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    public static final BooleanProperty LEFT = BooleanProperty.m_61465_((String)"left");
    public static final BooleanProperty RIGHT = BooleanProperty.m_61465_((String)"right");

    public CenterCropVineBlock(BlockBehaviour.Properties prop) {
        super(prop.m_60977_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)Direction.Axis.Z)).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected abstract BranchCropVineBlock getSide();

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AXIS, LEFT, RIGHT});
    }

    @Override
    protected boolean attemptGrowth(BlockState state, LevelReader level, BlockPos pos, @Nullable RandomSource random, boolean simulate, boolean natural, float speed) {
        if (this.attemptGrowthImpl(state, level, pos, random, simulate, natural, speed, true)) {
            return true;
        }
        int age = (Integer)state.m_61143_((Property)this.getAgeProperty());
        if (age < this.getMaxAge() && simulate) {
            return true;
        }
        if (age >= this.getBaseAge()) {
            if (!((Boolean)state.m_61143_((Property)TOP)).booleanValue()) {
                BlockPos up = pos.m_7494_();
                BlockState top = level.m_8055_(up);
                if (RopeLoggedCropBlock.isRope(top)) {
                    top = (BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS)))).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true));
                    if (this.attemptClimb(top, level, up, random, simulate, natural, speed)) {
                        return true;
                    }
                } else if (top.m_60713_((Block)this)) {
                    boolean pass;
                    int prevAge = (Integer)top.m_61143_((Property)this.getAgeProperty());
                    boolean bl = pass = prevAge < age || age == this.getMaxAge();
                    if (pass && prevAge >= this.getBaseAge() && !simulate && random != null && (age < this.getMaxAge() || this.attemptGrowthImpl(state, level, pos, random, true, natural, speed, false) || super.attemptGrowth(state, level, pos, random, true, natural, speed))) {
                        pass = random.m_188499_();
                    }
                    if (pass && this.attemptGrowth(top, level, up, random, simulate, natural, speed)) {
                        return true;
                    }
                }
            }
            if (this.attemptGrowthImpl(state, level, pos, random, simulate, natural, speed, false)) {
                return true;
            }
        }
        return super.attemptGrowth(state, level, pos, random, simulate, natural, speed);
    }

    protected boolean attemptGrowthImpl(BlockState state, LevelReader level, BlockPos pos, @Nullable RandomSource random, boolean simulate, boolean natural, float speed, boolean first) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        Direction firstDir = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis);
        Direction secondDir = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        int age = (Integer)state.m_61143_((Property)this.getAgeProperty());
        if (!simulate && random != null && random.m_188499_()) {
            firstDir = firstDir.m_122424_();
            secondDir = secondDir.m_122424_();
        }
        if (this.attemptGrowthBranch(firstDir, age, level, pos.m_121945_(firstDir), pos, state, random, simulate, natural, speed, first)) {
            return true;
        }
        return this.attemptGrowthBranch(secondDir, age, level, pos.m_121945_(secondDir), pos, state, random, simulate, natural, speed, first);
    }

    protected boolean attemptClimb(BlockState state, LevelReader level, BlockPos pos, @Nullable RandomSource random, boolean simulate, boolean natural, float speed) {
        if (simulate) {
            return true;
        }
        assert (random != null);
        Level setter = (Level)level;
        if (natural && !ForgeHooks.onCropsGrowPre((Level)setter, (BlockPos)pos, (BlockState)state, (random.m_188501_() < speed ? 1 : 0) != 0)) {
            return false;
        }
        setter.m_7731_(pos, state, 2);
        if (natural) {
            ForgeHooks.onCropsGrowPost((Level)setter, (BlockPos)pos, (BlockState)state);
        }
        return true;
    }

    protected boolean attemptGrowthBranch(Direction dir, int age, LevelReader level, BlockPos pos, BlockPos source, BlockState center, @Nullable RandomSource random, boolean simulate, boolean natural, float speed, boolean first) {
        BlockState down = level.m_8055_(pos.m_7495_());
        if (down.m_60713_((Block)this.getSide()) && (Integer)down.m_61143_((Property)this.getSide().getAgeProperty()) < this.getSide().getBaseAge()) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        boolean updateSelf = false;
        if (!state.m_60713_((Block)this.getSide())) {
            if (!RopeLoggedCropBlock.isRope(state)) {
                return false;
            }
            BlockState next = level.m_8055_(pos.m_121945_(dir));
            boolean ext = next.m_60734_() instanceof BranchCropVineBlock;
            BlockState low = level.m_8055_(pos.m_7495_());
            boolean top = low.m_60713_((Block)this.getSide()) && ((Direction)low.m_61143_((Property)BranchCropVineBlock.FACING)).m_122434_() == dir.m_122434_();
            state = (BlockState)((BlockState)((BlockState)this.getSide().m_49966_().m_61124_((Property)BranchCropVineBlock.FACING, (Comparable)dir.m_122424_())).m_61124_((Property)BranchCropVineBlock.EXTENDED, (Comparable)Boolean.valueOf(ext))).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(top));
            updateSelf = true;
        } else {
            int prevAge;
            int n = prevAge = state.m_60713_((Block)this.getSide()) ? (Integer)state.m_61143_((Property)this.getSide().getAgeProperty()) : -1;
            if (prevAge >= age) {
                return false;
            }
            if (first && prevAge >= this.getBaseAge()) {
                return false;
            }
        }
        if (simulate) {
            return true;
        }
        assert (random != null);
        Level setter = (Level)level;
        if (natural && !ForgeHooks.onCropsGrowPre((Level)setter, (BlockPos)pos, (BlockState)state, (random.m_188501_() < speed ? 1 : 0) != 0)) {
            return false;
        }
        if (updateSelf) {
            setter.m_7731_(pos, state, 2);
            BooleanProperty prop = dir.m_122421_() == Direction.AxisDirection.NEGATIVE ? LEFT : RIGHT;
            setter.m_7731_(source, (BlockState)center.m_61124_((Property)prop, (Comparable)Boolean.valueOf(true)), 2);
        } else {
            this.getSide().doGrowth(state, setter, pos, random);
        }
        if (natural) {
            ForgeHooks.onCropsGrowPost((Level)setter, (BlockPos)pos, (BlockState)state);
        }
        return true;
    }

    @Override
    @Nullable
    protected BlockPos getTrunk(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState low = level.m_8055_(pos = pos.m_7495_());
        if (low.m_60713_((Block)this.getTrunk())) {
            return pos;
        }
        if (low.m_60713_((Block)this) && (low = level.m_8055_(pos = pos.m_7495_())).m_60713_((Block)this.getTrunk())) {
            return pos;
        }
        return null;
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState fstate, LevelAccessor level, BlockPos cpos, BlockPos fpos) {
        if (facing.m_122434_() == state.m_61143_(AXIS)) {
            if (facing.m_122421_() == Direction.AxisDirection.NEGATIVE) {
                if (!fstate.m_60713_((Block)this.getSide()) || fstate.m_61143_((Property)BranchCropVineBlock.FACING) != facing.m_122424_()) {
                    state = (BlockState)state.m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false));
                }
            } else if (!fstate.m_60713_((Block)this.getSide()) || fstate.m_61143_((Property)BranchCropVineBlock.FACING) != facing.m_122424_()) {
                state = (BlockState)state.m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(false));
            }
        }
        return super.m_7417_(state, facing, fstate, level, cpos, fpos);
    }
}

