/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.block.plant.grape;

import dev.xkmc.l2harvester.api.HarvestResult;
import dev.xkmc.l2harvester.api.HarvestableBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.rope.RopeLoggedCropBlock;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class DoubleRopeCropBlock
extends RopeLoggedCropBlock
implements HarvestableBlock {
    public static final BooleanProperty ROOT = BooleanProperty.m_61465_((String)"rooted");

    public DoubleRopeCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected boolean mayGrow(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        return (Boolean)state.m_61143_((Property)ROOT) != false && super.mayGrow(state, level, pos, random) && this.mayGrowTo(state, (LevelReader)level, pos, (Integer)state.m_61143_((Property)this.m_7959_()) + 1);
    }

    @Override
    protected boolean mayGrowTo(BlockState state, LevelReader level, BlockPos pos, int age) {
        BlockState upper;
        if (!(age < this.getDoubleBlockStart() || (upper = level.m_8055_(pos.m_7494_())).m_60795_() || upper.m_60713_((Block)this) || DoubleRopeCropBlock.isRope(upper))) {
            return false;
        }
        return super.mayGrowTo(state, level, pos, age);
    }

    @Override
    protected void growTo(BlockState state, ServerLevel level, BlockPos pos, int age) {
        super.growTo(state, level, pos, age);
        if (age >= this.getDoubleBlockStart()) {
            BlockState upper = level.m_8055_(pos.m_7494_());
            boolean ropped = DoubleRopeCropBlock.isRope(upper) || upper.m_60713_((Block)this) && (Boolean)upper.m_61143_((Property)ROPELOGGED) != false;
            BlockState next = (BlockState)((BlockState)((BlockState)state.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(age))).m_61124_((Property)ROOT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ROPELOGGED, (Comparable)Boolean.valueOf(ropped));
            level.m_7731_(pos.m_7494_(), next, 2);
        }
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean client) {
        if (!this.mayGrowTo(state, level, pos, (Integer)state.m_61143_((Property)this.m_7959_()) + 1)) {
            return false;
        }
        return super.m_7370_(level, pos, state, client);
    }

    @Override
    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (!((Boolean)state.m_61143_((Property)ROOT)).booleanValue()) {
            BlockState lower = level.m_8055_(pos.m_7495_());
            if (!lower.m_60713_((Block)this)) {
                return;
            }
            this.m_214148_(level, random, pos.m_7495_(), lower);
            return;
        }
        super.m_214148_(level, random, pos, state);
    }

    @Override
    protected void pickup(BlockState state, Level level, BlockPos pos, Player player) {
        if (!((Boolean)state.m_61143_((Property)ROOT)).booleanValue()) {
            BlockState lower = level.m_8055_(pos.m_7495_());
            if (!lower.m_60713_((Block)this)) {
                return;
            }
            this.pickup(lower, level, pos.m_7495_(), player);
            return;
        }
        super.pickup(state, level, pos, player);
        BlockState up = level.m_8055_(pos.m_7494_());
        if (up.m_60713_((Block)this)) {
            level.m_7731_(pos.m_7494_(), (BlockState)up.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(this.getBaseAge())), 2);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ROOT});
    }

    public abstract int getDoubleBlockStart();

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        if (((Boolean)pState.m_61143_((Property)ROOT)).booleanValue()) {
            return super.m_7898_(pState, pLevel, pPos);
        }
        BlockState blockstate = pLevel.m_8055_(pPos.m_7495_());
        if (pState.m_60734_() != this) {
            return super.m_7898_(pState, pLevel, pPos);
        }
        return blockstate.m_60713_((Block)this) && (Boolean)blockstate.m_61143_((Property)ROOT) != false;
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction dir, BlockState sourceState, LevelAccessor level, BlockPos pos, BlockPos sourcePos) {
        boolean root = (Boolean)state.m_61143_((Property)ROOT);
        if (root && dir == Direction.DOWN && !state.m_60710_((LevelReader)level, pos)) {
            level.m_186460_(pos, (Block)this, 1);
            return state;
        }
        if (dir.m_122434_() == Direction.Axis.Y) {
            boolean illegal;
            boolean bl = illegal = !sourceState.m_60713_((Block)this) || (Boolean)sourceState.m_61143_((Property)ROOT) == root;
            if (!root && dir == Direction.DOWN && illegal) {
                level.m_186460_(pos, (Block)this, 1);
                return state;
            }
            if (root && dir == Direction.UP && illegal && (Integer)state.m_61143_((Property)this.m_7959_()) >= this.getDoubleBlockStart()) {
                level.m_186460_(pos, (Block)this, 1);
                return state;
            }
        }
        return super.m_7417_(state, dir, sourceState, level, pos, sourcePos);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            if (player.m_7500_()) {
                DoubleRopeCropBlock.preventCreativeDropFromBottomPart(level, pos, state, player);
            } else {
                DoubleRopeCropBlock.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    @Override
    public void doPlayerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity be, ItemStack stack) {
        super.doPlayerDestroy(level, player, pos, Blocks.f_50016_.m_49966_(), be, stack);
    }

    public static void preventCreativeDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos low;
        BlockState lowState;
        Boolean base = (Boolean)state.m_61143_((Property)ROOT);
        if (!base.booleanValue() && (lowState = level.m_8055_(low = pos.m_7495_())).m_60713_(state.m_60734_()) && ((Boolean)lowState.m_61143_((Property)ROOT)).booleanValue()) {
            BlockState empty = (Boolean)state.m_61143_((Property)ROPELOGGED) != false ? DoubleRopeCropBlock.getRopeBlock() : Blocks.f_50016_.m_49966_();
            level.m_7731_(low, empty, 35);
            level.m_5898_(player, 2001, low, Block.m_49956_((BlockState)lowState));
        }
    }

    @Override
    @Nullable
    public HarvestResult getHarvestResult(Level level, BlockState state, BlockPos pos) {
        BlockPos lower;
        if (!((Boolean)state.m_61143_((Property)ROOT)).booleanValue()) {
            lower = pos.m_7495_();
            state = level.m_8055_(lower);
            if (!state.m_60713_((Block)this)) {
                return null;
            }
        } else {
            lower = pos;
        }
        if ((Integer)state.m_61143_((Property)this.m_7959_()) < this.m_7419_()) {
            return null;
        }
        int j = 1 + level.f_46441_.m_188503_(2);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack(this.getFruit(), j));
        return new HarvestResult((l, p) -> {
            l.m_7731_(lower, (BlockState)l.m_8055_(lower).m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(this.getBaseAge())), 2);
            l.m_7731_(lower.m_7494_(), (BlockState)l.m_8055_(lower.m_7494_()).m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(this.getBaseAge())), 2);
        }, list);
    }
}

