/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.block.variants;

import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import dev.xkmc.l2library.util.raytrace.RayTraceUtil;
import dev.xkmc.youkaishomecoming.content.block.variants.LeftClickBlock;
import dev.xkmc.youkaishomecoming.util.VoxelBuilder;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import org.jetbrains.annotations.Nullable;

public class MultiFenceBlock
extends Block
implements SimpleWaterloggedBlock,
LeftClickBlock {
    public static final EnumProperty<State>[] STATES;
    public static final BooleanProperty WATERLOGGED;
    public static final BooleanProperty INVERTED;
    public static final VoxelShape[] SHAPES;

    private int indexOf(BlockState state) {
        int total = 0;
        for (int i = 0; i < 4; ++i) {
            Direction dir = Direction.m_122407_((int)i);
            total |= MultiFenceBlock.of(state, dir).collide() << i * 2;
        }
        return total;
    }

    public static State of(BlockState state, Direction dire) {
        return (State)((Object)state.m_61143_(STATES[dire.m_122416_()]));
    }

    public static BlockState with(BlockState state, Direction dire, State val) {
        return (BlockState)state.m_61124_(STATES[dire.m_122416_()], (Comparable)((Object)val));
    }

    public static BlockState with(BlockState state, State north, State south, State west, State east) {
        state = MultiFenceBlock.with(state, Direction.NORTH, north);
        state = MultiFenceBlock.with(state, Direction.SOUTH, south);
        state = MultiFenceBlock.with(state, Direction.WEST, west);
        state = MultiFenceBlock.with(state, Direction.EAST, east);
        return state;
    }

    public MultiFenceBlock(BlockBehaviour.Properties prop) {
        super(prop);
        this.m_49959_((BlockState)((BlockState)MultiFenceBlock.with(this.m_49966_(), State.FLAT, State.OPEN, State.OPEN, State.OPEN).m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(STATES);
        builder.m_61104_(new Property[]{WATERLOGGED, INVERTED});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42751_)) {
            return InteractionResult.PASS;
        }
        if (this.m_6864_(state, new BlockPlaceContext(player, hand, stack, hit))) {
            return InteractionResult.PASS;
        }
        if (!level.m_5776_()) {
            while (level.m_8055_(pos.m_7494_()).m_60734_() instanceof MultiFenceBlock) {
                pos = pos.m_7494_();
            }
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf((Boolean)(state = level.m_8055_(pos)).m_61143_((Property)INVERTED) == false)));
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public boolean leftClick(BlockState state, Level level, BlockPos pos, Player player) {
        if (player.m_36335_().m_41519_(this.m_5456_())) {
            return false;
        }
        player.m_36335_().m_41524_(this.m_5456_(), 4);
        BlockHitResult result = RayTraceUtil.rayTraceBlock((Level)level, (Player)player, (double)player.getBlockReach());
        Vec3 hit = result.m_82450_();
        if (!new AABB(pos).m_82400_(0.1).m_82390_(hit)) {
            return true;
        }
        Vec3 rel = hit.m_82546_(Vec3.m_82512_((Vec3i)pos));
        Direction candidate = null;
        double minSqr = 10.0;
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            Direction dir = Direction.m_122407_((int)i);
            if (MultiFenceBlock.of(state, dir).type() == 0) continue;
            ++count;
            double distSqr = rel.f_82479_ * (double)dir.m_122429_() + rel.f_82481_ * (double)dir.m_122431_();
            if (candidate != null && !(distSqr > minSqr)) continue;
            minSqr = distSqr;
            candidate = dir;
        }
        if (count > 1) {
            level.m_46597_(pos, MultiFenceBlock.with(state, candidate, State.OPEN));
        } else {
            level.m_7471_(pos, false);
        }
        MultiFenceBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)this.m_5456_().m_7968_());
        return true;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext ctx) {
        if (!ctx.m_43722_().m_150930_(this.m_5456_())) {
            return false;
        }
        Direction dir = ctx.m_43719_().m_122424_();
        BlockPos pos = ctx.m_8083_();
        Vec3 hit = ctx.m_43720_();
        if (dir.m_122434_().m_122479_()) {
            if (new AABB(pos).m_82390_(hit)) {
                Direction req;
                Vec3 center = Vec3.m_82512_((Vec3i)pos).m_231075_(dir, 0.5);
                Direction.Axis axis = dir.m_122428_().m_122434_();
                double val = hit.m_82546_(center).m_82507_(axis);
                if (Math.abs(val) > 0.1875) {
                    Direction.AxisDirection ad = val > 0.0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
                    req = Direction.m_122390_((Direction.AxisDirection)ad, (Direction.Axis)axis);
                } else {
                    req = dir.m_122424_();
                }
                State st = MultiFenceBlock.of(state, req);
                return st.type() == 0;
            }
            return false;
        }
        Vec3 rel = hit.m_82546_(Vec3.m_82512_((Vec3i)pos));
        Direction dx = Direction.m_122366_((double)rel.f_82479_, (double)0.0, (double)rel.f_82481_);
        if (dx.m_122434_().m_122478_()) {
            dx = Direction.NORTH;
        }
        return MultiFenceBlock.of(state, dx).type() == 0;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state;
        BlockPos pos = ctx.m_8083_();
        Direction dir = ctx.m_43719_().m_122424_();
        Vec3 hit = ctx.m_43720_();
        BlockState old = ctx.m_43725_().m_8055_(pos);
        if (old.m_60734_() instanceof MultiFenceBlock) {
            state = old;
            if (dir.m_122434_().m_122479_() && new AABB(pos).m_82390_(hit)) {
                Direction req;
                Vec3 center = Vec3.m_82512_((Vec3i)pos).m_231075_(dir, 0.5);
                Direction.Axis axis = dir.m_122428_().m_122434_();
                double val = hit.m_82546_(center).m_82507_(axis);
                if (Math.abs(val) > 0.1875) {
                    Direction.AxisDirection ad = val > 0.0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
                    req = Direction.m_122390_((Direction.AxisDirection)ad, (Direction.Axis)axis);
                } else {
                    req = dir.m_122424_();
                }
                State st = MultiFenceBlock.of(state, req);
                if (st.type() == 0) {
                    return MultiFenceBlock.with(state, req, State.FLAT);
                }
            }
        } else {
            state = this.m_49966_();
            FluidState fluidstate = ctx.m_43725_().m_6425_(ctx.m_8083_());
            boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
            state = MultiFenceBlock.with(state, State.OPEN, State.OPEN, State.OPEN, State.OPEN);
            state = (BlockState)((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf(false));
        }
        if (dir.m_122434_().m_122479_()) {
            return (BlockState)MultiFenceBlock.with(state, dir, State.FLAT).m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf(true));
        }
        Vec3 rel = hit.m_82546_(Vec3.m_82512_((Vec3i)pos));
        Direction dx = Direction.m_122366_((double)rel.f_82479_, (double)0.0, (double)rel.f_82481_);
        if (dx.m_122434_().m_122478_()) {
            dx = Direction.NORTH;
        }
        return MultiFenceBlock.with(state, dx, State.FLAT);
    }

    public BlockState m_7417_(BlockState state, Direction dire, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (dire == Direction.DOWN && !state.m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (dire == Direction.UP) {
            BlockState ans = state;
            boolean valid = neighborState.m_60734_() instanceof MultiFenceBlock;
            if (valid) {
                ans = (BlockState)ans.m_61124_((Property)INVERTED, (Comparable)((Boolean)neighborState.m_61143_((Property)INVERTED)));
            }
            for (int i = 0; i < 4; ++i) {
                boolean up;
                Direction d = Direction.m_122407_((int)i);
                State old = MultiFenceBlock.of(state, d);
                if (old.type() == 0) continue;
                boolean bl = up = valid && MultiFenceBlock.of(neighborState, d).type() > 0;
                if (old == State.UP) {
                    old = State.FLAT;
                }
                ans = MultiFenceBlock.with(ans, d, up ? State.UP : old);
            }
            return ans;
        }
        if (dire.m_122434_().m_122479_()) {
            BlockState ans = state;
            Direction left = dire.m_122427_();
            Direction right = dire.m_122428_();
            boolean flag = neighborState.m_60734_() instanceof MultiFenceBlock;
            if (MultiFenceBlock.of(state, dire).type() == 0) {
                if (flag) {
                    if (MultiFenceBlock.of(state, left).type() > 1) {
                        boolean bl = flag = MultiFenceBlock.of(neighborState, left).type() > 1;
                    }
                    if (MultiFenceBlock.of(state, right).type() > 1) {
                        flag &= MultiFenceBlock.of(neighborState, right).type() > 1;
                    }
                }
                ans = MultiFenceBlock.with(ans, dire, flag ? State.CONNECT : State.OPEN);
            }
            if (neighborState.m_60734_() instanceof MultiFenceBlock) {
                BlockPos rev;
                BlockState low;
                if (MultiFenceBlock.of(state, left).type() > 1 && MultiFenceBlock.of(neighborState, left).type() > 0 && (low = level.m_8055_(rev = pos.m_121945_(dire.m_122424_()).m_7495_())).m_60734_() instanceof MultiFenceBlock && MultiFenceBlock.of(low, left).type() > 1) {
                    ans = MultiFenceBlock.with(ans, left, State.CW);
                }
                if (MultiFenceBlock.of(state, right).type() > 1 && MultiFenceBlock.of(neighborState, right).type() > 0 && (low = level.m_8055_(rev = pos.m_121945_(dire.m_122424_()).m_7495_())).m_60734_() instanceof MultiFenceBlock && MultiFenceBlock.of(low, right).type() > 1) {
                    ans = MultiFenceBlock.with(ans, right, State.CCW);
                }
            }
            return ans;
        }
        return super.m_7417_(state, dire, neighborState, level, pos, neighborPos);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPES[this.indexOf(state)];
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return switch (mirror) {
            default -> throw new IncompatibleClassChangeError();
            case Mirror.LEFT_RIGHT -> MultiFenceBlock.with(state, MultiFenceBlock.of(state, Direction.SOUTH).flip(), MultiFenceBlock.of(state, Direction.NORTH).flip(), MultiFenceBlock.of(state, Direction.WEST).flip(), MultiFenceBlock.of(state, Direction.EAST).flip());
            case Mirror.FRONT_BACK -> MultiFenceBlock.with(state, MultiFenceBlock.of(state, Direction.NORTH).flip(), MultiFenceBlock.of(state, Direction.SOUTH).flip(), MultiFenceBlock.of(state, Direction.EAST).flip(), MultiFenceBlock.of(state, Direction.WEST).flip());
            case Mirror.NONE -> state;
        };
    }

    public BlockState m_6843_(BlockState state, Rotation rotate) {
        BlockState ans = state;
        ans = MultiFenceBlock.with(ans, rotate.m_55954_(Direction.NORTH), MultiFenceBlock.of(state, Direction.NORTH));
        ans = MultiFenceBlock.with(ans, rotate.m_55954_(Direction.SOUTH), MultiFenceBlock.of(state, Direction.SOUTH));
        ans = MultiFenceBlock.with(ans, rotate.m_55954_(Direction.WEST), MultiFenceBlock.of(state, Direction.WEST));
        ans = MultiFenceBlock.with(ans, rotate.m_55954_(Direction.EAST), MultiFenceBlock.of(state, Direction.EAST));
        return ans;
    }

    public static void genModel(DataGenContext<Block, MultiFenceBlock> ctx, RegistrateBlockstateProvider pvd) {
        MultiPartBlockStateBuilder builder = pvd.getMultipartBuilder((Block)ctx.get());
        FlatModelSet set = new FlatModelSet(ctx, pvd);
        for (int i = 0; i < 4; ++i) {
            Direction dir = Direction.m_122407_((int)i);
            int rot = ((int)dir.m_122435_() + 180) % 360;
            EnumProperty<State> left = STATES[dir.m_122428_().m_122416_()];
            EnumProperty<State> right = STATES[dir.m_122427_().m_122416_()];
            set.buildFace(builder, rot, STATES[i], left, right);
        }
    }

    static {
        int i;
        WATERLOGGED = BlockStateProperties.f_61362_;
        INVERTED = BlockStateProperties.f_61441_;
        STATES = new EnumProperty[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            MultiFenceBlock.STATES[i2] = EnumProperty.m_61587_((String)Direction.m_122407_((int)i2).m_122433_(), State.class);
        }
        SHAPES = new VoxelShape[256];
        VoxelBuilder box = new VoxelBuilder(0, 0, 0, 16, 16, 2);
        VoxelBuilder left = new VoxelBuilder(0, 8, 0, 8, 16, 2);
        VoxelBuilder right = new VoxelBuilder(8, 8, 0, 16, 16, 2);
        VoxelShape[][] parts = new VoxelShape[4][4];
        for (i = 0; i < 4; ++i) {
            Direction dir = Direction.m_122407_((int)i);
            parts[i][0] = Shapes.m_83040_();
            VoxelShape rbox = box.rotateFromNorth(dir);
            VoxelShape ls = left.rotateFromNorth(dir);
            VoxelShape rs = right.rotateFromNorth(dir);
            parts[i][1] = rbox;
            parts[i][2] = Shapes.m_83113_((VoxelShape)rbox, (VoxelShape)rs, (BooleanOp)BooleanOp.f_82685_);
            parts[i][3] = Shapes.m_83113_((VoxelShape)rbox, (VoxelShape)ls, (BooleanOp)BooleanOp.f_82685_);
        }
        for (i = 0; i < 256; ++i) {
            ArrayList<VoxelShape> list = new ArrayList<VoxelShape>();
            for (int j = 0; j < 4; ++j) {
                int index = i >> j * 2 & 3;
                list.add(parts[j][index]);
            }
            MultiFenceBlock.SHAPES[i] = Shapes.m_83124_((VoxelShape)Shapes.m_83040_(), (VoxelShape[])((VoxelShape[])list.toArray(VoxelShape[]::new)));
        }
    }

    public static enum State implements StringRepresentable
    {
        OPEN,
        CONNECT,
        FLAT,
        UP,
        CW,
        CCW;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public State flip() {
            return switch (this) {
                case CW -> CCW;
                case CCW -> CW;
                default -> this;
            };
        }

        public int type() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case OPEN, CONNECT -> 0;
                case UP -> 1;
                case FLAT -> 2;
                case CW, CCW -> 3;
            };
        }

        public int collide() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case OPEN, CONNECT -> 0;
                case UP, FLAT -> 1;
                case CW -> 2;
                case CCW -> 3;
            };
        }
    }

    private static class FlatModelSet {
        private static ModelFile[][][] FLAT = null;
        private static ModelFile[][][] DIAG = null;
        private final DataGenContext<Block, MultiFenceBlock> ctx;
        private final RegistrateBlockstateProvider pvd;
        private final ModelFile[][][] flat;
        private final ModelFile[][][] diag;

        private static void genRow(ModelBuilder<?> builder, float x, float y, float z, float w, float h, float t, float u) {
            builder.element().from(x, y, z).to(x + w, y + h, z + t).face(Direction.NORTH).uvs(u, 0.0f, u + w, h).texture("#all").end().face(Direction.SOUTH).uvs(u + w, 0.0f, u, h).texture("#all").end().face(Direction.UP).uvs(u + w, t, u, 0.0f).texture("#all").end().face(Direction.DOWN).uvs(u + w, h - t, u, h).texture("#all").end();
        }

        private static void genDiagonal(ModelBuilder<?> builder, float x, float y, float z, float w, float h, float t, float u, Rotate r, Side s) {
            int angle = r == Rotate.CW ? -45 : 45;
            int px = r == Rotate.CW ? 0 : 16;
            ModelBuilder.ElementBuilder elem = builder.element().from(x, y, z).to(x + w, y + h, z + t).rotation().angle((float)angle).axis(Direction.Axis.Z).origin((float)px, 0.0f, 0.0f).end().face(Direction.NORTH).uvs(u, 0.0f, u + w, h).texture("#all").end().face(Direction.SOUTH).uvs(u + w, 0.0f, u, h).texture("#all").end().face(Direction.UP).uvs(u + w, t, u, 0.0f).texture("#all").end().face(Direction.DOWN).uvs(u + w, h - t, u, h).texture("#all").end();
            if (s == Side.LEFT) {
                elem.face(Direction.WEST).uvs(u + w - t, 0.0f, u + w, h).texture("#all").end();
            } else {
                elem.face(Direction.EAST).uvs(u, 0.0f, u + t, h).texture("#all").end();
            }
        }

        private static void genExt(ModelBuilder<?> builder, float x, float y, float z, float w, float h, float t, float u, Side s) {
            ModelBuilder.ElementBuilder elem = builder.element().from(x, y, z).to(x + w, y + h, z + t).face(Direction.NORTH).uvs(u, 0.0f, u + w, h).texture("#all").end().face(Direction.SOUTH).uvs(u + w, 0.0f, u, h).texture("#all").end().face(Direction.UP).uvs(u + w, 0.0f, u, t).texture("#all").end().face(Direction.DOWN).uvs(u + w, h - t, u, h).texture("#all").end();
            if (s == Side.LEFT) {
                elem.face(Direction.WEST).uvs(u + w - t, 0.0f, u + w, h).texture("#all").end();
            } else {
                elem.face(Direction.EAST).uvs(u, 0.0f, u + t, h).texture("#all").end();
            }
        }

        private static void genColumn(ModelBuilder<?> builder, float x, float y, float z, float w, float h, float t, float u, float v) {
            builder.element().from(x, y, z).to(x + w, y + h, z + t).face(Direction.NORTH).uvs(16.0f - h - u, v + w, 16.0f - u, v).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#all").end().face(Direction.EAST).uvs(16.0f - h - u, v + t, 16.0f - u, v).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#all").end().face(Direction.SOUTH).uvs(16.0f - h - u, v, 16.0f - u, v + w).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#all").end().face(Direction.WEST).uvs(16.0f - h - u, v + w, 16.0f - u, v + w - t).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#all").end().face(Direction.UP).uvs(16.0f - h - u, v, 16.0f - h - u + t, v + w).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#all").end().face(Direction.DOWN).uvs(16.0f - t, v, 16.0f, v + w).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#all").end();
        }

        private static ModelFile genFlat(RegistrateBlockstateProvider pvd, Face f, Side s, Type t) {
            String name = (f.name() + "_" + s.name() + "_" + t.name()).toLowerCase(Locale.ROOT);
            BlockModelBuilder builder = (BlockModelBuilder)pvd.models().withExistingParent("custom/handrail_" + name, "block/block");
            int off = t == Type.CORNER ? 1 : 0;
            int z = f == Face.INNER ? 1 : 0;
            int x = s == Side.RIGHT ? 8 : off;
            int u = s == Side.RIGHT ? off : 8;
            float y = 12.99f;
            int h = 3;
            FlatModelSet.genRow(builder, x, y, z, 8 - off, h, 1.0f, u);
            if (t == Type.EXTEND) {
                int e = f == Face.INNER ? 2 : 1;
                x = s == Side.RIGHT ? 16 : -e;
                u = s == Side.RIGHT ? 16 - e : 0;
                FlatModelSet.genExt(builder, x, y, z, e, h, 1.0f, u, s);
            }
            x = s == Side.RIGHT ? 11 : 3;
            FlatModelSet.genColumn(builder, x, 0.0f, 1 - z, 2.0f, 16.0f, 1.0f, 0.0f, 3.0f);
            builder.texture("particle", "#all");
            return builder;
        }

        private static ModelFile genDiag(RegistrateBlockstateProvider pvd, Face f, Side s, Rotate r) {
            String name = (f.name() + "_" + s.name() + "_" + r.name()).toLowerCase(Locale.ROOT);
            BlockModelBuilder builder = (BlockModelBuilder)pvd.models().withExistingParent("custom/handrail_" + name, "block/block");
            int z = f == Face.INNER ? 1 : 0;
            float x = (s == Side.RIGHT ? 12.5f : 0.0f) + (r == Rotate.CW ? -11.25f : 2.25f);
            float u = s == Side.RIGHT ? 0.0f : 3.5f;
            float y = 8.25f;
            FlatModelSet.genDiagonal(builder, x + 0.01f, y, (float)z + 0.01f, 12.5f, 3.0f, 1.0f, u, r, s);
            int x0 = s == Side.RIGHT ? 11 : 3;
            int h = s == Side.RIGHT == (r == Rotate.CW) ? 2 : 10;
            FlatModelSet.genColumn(builder, (float)x0 + 0.01f, 0.0f, (float)(1 - z) + 0.01f, 2.0f, h, 1.0f, 0.0f, 3.0f);
            if (h < 8) {
                FlatModelSet.genColumn(builder, (float)x0 + 0.01f, h - 10, (float)(1 - z) + 0.01f, 2.0f, 10 - h, 1.0f, 10 - h, 3.0f);
            }
            return builder;
        }

        private static void genPost(RegistrateBlockstateProvider pvd, Face f) {
            String name = "post_" + f.name().toLowerCase(Locale.ROOT);
            BlockModelBuilder builder = (BlockModelBuilder)pvd.models().withExistingParent("custom/handrail_" + name, "block/block");
            int z = f == Face.INNER ? 1 : 0;
            FlatModelSet.genColumn(builder, 3.0f, 0.0f, 1 - z, 2.0f, 16.0f, 1.0f, 0.0f, 3.0f);
            FlatModelSet.genColumn(builder, 11.0f, 0.0f, 1 - z, 2.0f, 16.0f, 1.0f, 0.0f, 3.0f);
            builder.texture("particle", "#all");
        }

        private static void init(RegistrateBlockstateProvider pvd) {
            if (FLAT != null) {
                return;
            }
            FLAT = new ModelFile[2][2][3];
            DIAG = new ModelFile[2][2][2];
            for (Face f : Face.values()) {
                for (Side s : Side.values()) {
                    for (Type type : Type.values()) {
                        if (f == Face.OUTER && type == Type.CORNER) continue;
                        FlatModelSet.FLAT[f.ordinal()][s.ordinal()][type.ordinal()] = FlatModelSet.genFlat(pvd, f, s, type);
                    }
                    for (Enum enum_ : Rotate.values()) {
                        FlatModelSet.DIAG[f.ordinal()][s.ordinal()][enum_.ordinal()] = FlatModelSet.genDiag(pvd, f, s, (Rotate)enum_);
                    }
                }
            }
            FlatModelSet.genPost(pvd, Face.INNER);
            FlatModelSet.genPost(pvd, Face.OUTER);
        }

        private FlatModelSet(DataGenContext<Block, MultiFenceBlock> ctx, RegistrateBlockstateProvider pvd) {
            this.ctx = ctx;
            this.pvd = pvd;
            FlatModelSet.init(pvd);
            this.flat = new ModelFile[2][2][3];
            this.diag = new ModelFile[2][2][2];
            for (Face f : Face.values()) {
                for (Side s : Side.values()) {
                    for (Type type : Type.values()) {
                        if (f == Face.OUTER && type == Type.CORNER) continue;
                        this.flat[f.ordinal()][s.ordinal()][type.ordinal()] = this.genFlatModel(f, s, type);
                    }
                    for (Enum enum_ : Rotate.values()) {
                        this.diag[f.ordinal()][s.ordinal()][enum_.ordinal()] = this.genDiagModel(f, s, (Rotate)enum_);
                    }
                }
            }
        }

        private ModelFile genFlatModel(Face f, Side s, Type t) {
            String name = (f.name() + "_" + s.name() + "_" + t.name()).toLowerCase(Locale.ROOT);
            return ((BlockModelBuilder)((BlockModelBuilder)this.pvd.models().getBuilder("block/" + this.ctx.getName() + "_" + name)).parent(FLAT[f.ordinal()][s.ordinal()][t.ordinal()])).texture("all", this.pvd.modLoc("block/wooden/" + this.ctx.getName()));
        }

        private ModelFile genDiagModel(Face f, Side s, Rotate r) {
            String name = (f.name() + "_" + s.name() + "_" + r.name()).toLowerCase(Locale.ROOT);
            return ((BlockModelBuilder)((BlockModelBuilder)this.pvd.models().getBuilder("block/" + this.ctx.getName() + "_" + name)).parent(DIAG[f.ordinal()][s.ordinal()][r.ordinal()])).texture("all", this.pvd.modLoc("block/wooden/" + this.ctx.getName()));
        }

        private ModelFile getModel(Face f, Side s, Type t) {
            return this.flat[f.ordinal()][s.ordinal()][t.ordinal()];
        }

        private ModelFile getModel(Face f, Side s, Rotate r) {
            return this.diag[f.ordinal()][s.ordinal()][r.ordinal()];
        }

        private void buildInnerSide(MultiPartBlockStateBuilder builder, int rot, EnumProperty<State> self, Side side, EnumProperty<State> adj) {
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.getModel(Face.INNER, side, Type.CORNER)).rotationY(rot).addModel()).condition((Property)INVERTED, (Comparable[])new Boolean[]{true}).condition(self, (Comparable[])new State[]{State.FLAT}).condition(adj, (Comparable[])new State[]{State.FLAT}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.getModel(Face.INNER, side, Type.CONNECT)).rotationY(rot).addModel()).condition((Property)INVERTED, (Comparable[])new Boolean[]{true}).condition(self, (Comparable[])new State[]{State.FLAT}).condition(adj, (Comparable[])new State[]{State.CONNECT}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.getModel(Face.INNER, side, Type.EXTEND)).rotationY(rot).addModel()).condition((Property)INVERTED, (Comparable[])new Boolean[]{true}).condition(self, (Comparable[])new State[]{State.FLAT}).condition(adj, (Comparable[])new State[]{State.OPEN, State.UP, State.CW, State.CCW}).end();
        }

        private void buildOuterSide(MultiPartBlockStateBuilder builder, int rot, EnumProperty<State> self, Side side, EnumProperty<State> adj) {
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.getModel(Face.OUTER, side, Type.CONNECT)).rotationY(rot).addModel()).condition((Property)INVERTED, (Comparable[])new Boolean[]{false}).condition(self, (Comparable[])new State[]{State.FLAT}).condition(adj, (Comparable[])new State[]{State.CONNECT, State.FLAT}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.getModel(Face.OUTER, side, Type.EXTEND)).rotationY(rot).addModel()).condition((Property)INVERTED, (Comparable[])new Boolean[]{false}).condition(self, (Comparable[])new State[]{State.FLAT}).condition(adj, (Comparable[])new State[]{State.OPEN, State.UP, State.CW, State.CCW}).end();
        }

        private void buildDiag(MultiPartBlockStateBuilder builder, int rot, EnumProperty<State> self, Face face, Side side) {
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.getModel(face, side, Rotate.CW)).rotationY(rot).addModel()).condition((Property)INVERTED, (Comparable[])new Boolean[]{face == Face.INNER}).condition(self, (Comparable[])new State[]{State.CW}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.getModel(face, side, Rotate.CCW)).rotationY(rot).addModel()).condition((Property)INVERTED, (Comparable[])new Boolean[]{face == Face.INNER}).condition(self, (Comparable[])new State[]{State.CCW}).end();
        }

        private void buildPost(MultiPartBlockStateBuilder builder, int rot, EnumProperty<State> self, Face face) {
            String name = "post_" + face.name().toLowerCase(Locale.ROOT);
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.pvd.models().getBuilder("block/" + this.ctx.getName() + "_" + name)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.pvd.modLoc("custom/handrail_" + name)))).texture("all", this.pvd.modLoc("block/wooden/" + this.ctx.getName()))).rotationY(rot).addModel()).condition((Property)INVERTED, (Comparable[])new Boolean[]{face == Face.INNER}).condition(self, (Comparable[])new State[]{State.UP}).end();
        }

        private void buildFace(MultiPartBlockStateBuilder builder, int rot, EnumProperty<State> self, EnumProperty<State> left, EnumProperty<State> right) {
            this.buildInnerSide(builder, rot, self, Side.LEFT, left);
            this.buildInnerSide(builder, rot, self, Side.RIGHT, right);
            this.buildOuterSide(builder, rot, self, Side.LEFT, left);
            this.buildOuterSide(builder, rot, self, Side.RIGHT, right);
            this.buildPost(builder, rot, self, Face.INNER);
            this.buildPost(builder, rot, self, Face.OUTER);
            this.buildDiag(builder, rot, self, Face.INNER, Side.LEFT);
            this.buildDiag(builder, rot, self, Face.INNER, Side.RIGHT);
            this.buildDiag(builder, rot, self, Face.OUTER, Side.LEFT);
            this.buildDiag(builder, rot, self, Face.OUTER, Side.RIGHT);
        }

        private static enum Rotate {
            CW,
            CCW;

        }

        private static enum Side {
            LEFT,
            RIGHT;

        }

        private static enum Face {
            INNER,
            OUTER;

        }

        private static enum Type {
            CORNER,
            CONNECT,
            EXTEND;

        }
    }
}

