/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.capability;

import dev.xkmc.fastprojectileapi.entity.GrazingEntity;
import dev.xkmc.l2serial.network.SerialPacketBase;
import dev.xkmc.l2serial.network.SimplePacketBase;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.capability.ClientCapHandler;
import dev.xkmc.youkaishomecoming.content.capability.GrazeCapability;
import dev.xkmc.youkaishomecoming.content.entity.youkai.YoukaiEntity;
import dev.xkmc.youkaishomecoming.events.DanmakuGrazeEvent;
import dev.xkmc.youkaishomecoming.events.EffectEventHandlers;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import dev.xkmc.youkaishomecoming.init.registrate.YHAttributes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class GrazeHelper {
    public static int globalInvulTime = 0;
    public static int globalForbidTime = 0;

    public static void graze(Player entity, GrazingEntity e) {
        GrazeCapability graze = (GrazeCapability)GrazeCapability.HOLDER.get(entity);
        if (graze.isInvul()) {
            return;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new DanmakuGrazeEvent(entity, e))) {
            return;
        }
        if (graze.graze() && entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            YoukaisHomecoming.HANDLER.toClientPlayer((SimplePacketBase)new GrazeToClient().set(0), sp);
        }
    }

    @Nullable
    public static LivingEntity getTarget(Player player) {
        return ((GrazeCapability)GrazeCapability.HOLDER.get(player)).findAny(player).orElse(null);
    }

    public static void addSession(Player player, LivingEntity target) {
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (!EffectEventHandlers.isFullCharacter((LivingEntity)player)) {
            return;
        }
        GrazeCapability cap = (GrazeCapability)GrazeCapability.HOLDER.get(player);
        if (!(target instanceof YoukaiEntity)) {
            return;
        }
        YoukaiEntity e = (YoukaiEntity)target;
        if (e.targets.contains((LivingEntity)player)) {
            return;
        }
        cap.initSession(e);
    }

    public static boolean forbidDanmaku(Player player) {
        GrazeCapability cap = (GrazeCapability)GrazeCapability.HOLDER.get(player);
        return cap.isInvul() || cap.isWeak();
    }

    public static void onDanmakuKill(Player player, YoukaiEntity e) {
        ((GrazeCapability)GrazeCapability.HOLDER.get(player)).stopSession(e.m_20148_());
    }

    public static int getInitialResource(Player player) {
        return (Integer)YHModConfig.COMMON.initialResource.get() + (int)player.m_21133_((Attribute)YHAttributes.INITIAL_RESOURCE.get());
    }

    public static int getInitialPower(Player player) {
        return (Integer)YHModConfig.COMMON.initialPower.get() + (int)player.m_21133_((Attribute)YHAttributes.INITIAL_POWER.get());
    }

    public static int getMaxPower(Player player) {
        return (Integer)YHModConfig.COMMON.danmakuMaxPower.get() + (int)player.m_21133_((Attribute)YHAttributes.MAX_POWER.get());
    }

    public static double getGrazeEffectiveness(Player player) {
        return (Double)YHModConfig.COMMON.grazeEffectiveness.get() + player.m_21133_((Attribute)YHAttributes.GRAZE_EFFECTIVENESS.get());
    }

    public static int getMaxResource(Player player) {
        return (Integer)YHModConfig.COMMON.danmakuMaxResource.get() + (int)player.m_21133_((Attribute)YHAttributes.MAX_RESOURCE.get());
    }

    public static float getHitBoxDelta(Player player) {
        return (float)player.m_21133_((Attribute)YHAttributes.HITBOX.get());
    }

    @SerialClass
    public static class GrazeToClient
    extends SerialPacketBase {
        @SerialClass.SerialField
        public int type;

        public void handle(NetworkEvent.Context context) {
            if (this.type == 0) {
                ClientCapHandler.playGraze();
            } else {
                ClientCapHandler.playMiss();
            }
        }

        public GrazeToClient set(int i) {
            this.type = i;
            return this;
        }
    }
}

