/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.animal.common;

import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.youkaishomecoming.content.entity.animal.common.MobState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Mob;

public abstract class MobStateMachine<E extends Mob, S extends Enum<S>, M extends MobStateMachine<E, S, M>> {
    public static final int OFFSET = 80;
    protected final Class<S> cls;
    protected final S[] allStates;
    protected final E mob;
    private S state;
    private int tick;

    public MobStateMachine(E entity, Class<S> cls, S[] values) {
        this.cls = cls;
        this.mob = entity;
        this.allStates = values;
        this.state = this.allStates[0];
    }

    public M self() {
        return (M)((MobStateMachine)Wrappers.cast((Object)this));
    }

    public S state() {
        return this.state;
    }

    public void tick() {
        if (this.tick > 0) {
            --this.tick;
        } else if (((MobState)this.state).next() != null) {
            this.transitionTo(((MobState)this.state).next());
        }
    }

    public boolean transitionTo(byte id) {
        if (id >= 80 && id - 80 < this.allStates.length) {
            this.transitionTo(this.allStates[id - 80]);
            return true;
        }
        return false;
    }

    public void transitionTo(S data) {
        this.transitionTo(data, ((MobState)data).tick());
    }

    protected void transitionTo(S data, int tickRemain) {
        if (!this.mob.m_9236_().m_5776_()) {
            this.mob.m_9236_().m_7605_(this.mob, ((MobState)data).id());
        } else {
            List<AnimationState> old = ((MobState)this.state).anims(this.self());
            List<AnimationState> next = ((MobState)data).anims(this.self());
            ArrayList<AnimationState> discard = new ArrayList<AnimationState>(old);
            discard.removeAll(next);
            ArrayList<AnimationState> add = new ArrayList<AnimationState>(next);
            add.removeAll(old);
            for (AnimationState e : discard) {
                e.m_216973_();
            }
            for (AnimationState e : add) {
                e.m_216982_(((Mob)this.mob).f_19797_ - (((MobState)data).tick() - tickRemain));
            }
        }
        this.state = data;
        this.tick = tickRemain;
    }

    public void write(CompoundTag tag) {
        tag.m_128359_("MobState", ((Enum)this.state).name());
        tag.m_128405_("MobStateTick", this.tick);
    }

    public void read(CompoundTag tag) {
        String str = tag.m_128461_("MobState");
        try {
            this.state = Enum.valueOf(this.cls, str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tick = tag.m_128451_("MobStateTick");
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(((Enum)this.state).ordinal());
        buffer.writeInt(this.tick);
    }

    public void read(FriendlyByteBuf data) {
        this.state = this.allStates[data.readInt()];
        this.transitionTo(this.state, data.readInt());
    }
}

