/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.animal.crab;

import dev.xkmc.youkaishomecoming.content.entity.animal.crab.CrabEntity;
import dev.xkmc.youkaishomecoming.init.data.YHTagGen;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class CrabDigGoal
extends Goal {
    private final CrabEntity mob;
    private final Level level;
    protected int eatAnimationTick;
    protected int finishTick;

    public CrabDigGoal(CrabEntity mob) {
        this.mob = mob;
        this.level = mob.m_9236_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (!this.mob.states.canDig()) {
            return false;
        }
        if (this.mob.m_217043_().m_188503_(this.mob.prop.digWillingness()) != 0) {
            return false;
        }
        return this.canDig();
    }

    protected boolean canDig() {
        BlockPos blockpos = BlockPos.m_274446_((Position)this.mob.m_20182_());
        return this.level.m_8055_(blockpos.m_7495_()).m_204336_(YHTagGen.CRAB_DIGABLE);
    }

    public void m_8056_() {
        this.mob.states.startDigging();
        this.eatAnimationTick = this.m_183277_(64);
        this.finishTick = this.m_183277_(10);
        this.mob.m_21573_().m_26573_();
    }

    public void m_8041_() {
        this.eatAnimationTick = 0;
        this.finishTick = 0;
    }

    public boolean m_8045_() {
        return this.eatAnimationTick > 0;
    }

    public void m_8037_() {
        this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        BlockPos pos = BlockPos.m_274446_((Position)this.mob.m_20182_());
        BlockState down = this.level.m_8055_(pos.m_7495_());
        if (down.m_204336_(YHTagGen.CRAB_DIGABLE)) {
            if (this.eatAnimationTick > this.finishTick) {
                Level level = this.mob.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)level;
                    Vec3 vec = this.mob.m_20182_().m_82549_(Vec3.m_82503_((Vec2)new Vec2(0.0f, this.mob.m_146908_())).m_82490_((double)(this.mob.m_20205_() / 2.0f)));
                    sl.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, down), vec.f_82479_, vec.f_82480_ + (double)0.1f, vec.f_82481_, 10, 0.0, 0.0, 0.0, 0.05);
                    if (this.eatAnimationTick % this.finishTick == 0) {
                        sl.m_245803_((Entity)this.mob, this.mob.m_20183_(), SoundEvents.f_271174_, SoundSource.AMBIENT, 1.0f, 1.0f);
                    }
                }
            } else if (this.eatAnimationTick == this.finishTick) {
                this.mob.dig(down);
            }
        }
    }
}

