/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.animal.crab;

import dev.xkmc.youkaishomecoming.content.entity.animal.common.StateMachineMob;
import dev.xkmc.youkaishomecoming.content.entity.animal.crab.CrabDigGoal;
import dev.xkmc.youkaishomecoming.content.entity.animal.crab.CrabFlipGoal;
import dev.xkmc.youkaishomecoming.content.entity.animal.crab.CrabHideGoal;
import dev.xkmc.youkaishomecoming.content.entity.animal.crab.CrabMoveControl;
import dev.xkmc.youkaishomecoming.content.entity.animal.crab.CrabPanicGoal;
import dev.xkmc.youkaishomecoming.content.entity.animal.crab.CrabProperties;
import dev.xkmc.youkaishomecoming.content.entity.animal.crab.CrabRandomWalkGoal;
import dev.xkmc.youkaishomecoming.content.entity.animal.crab.CrabState;
import dev.xkmc.youkaishomecoming.content.entity.animal.crab.CrabStateMachine;
import dev.xkmc.youkaishomecoming.content.entity.animal.crab.CrabVariant;
import dev.xkmc.youkaishomecoming.content.entity.youkai.SyncedData;
import dev.xkmc.youkaishomecoming.init.data.YHBiomeTagsProvider;
import dev.xkmc.youkaishomecoming.init.loot.YHLootGen;
import dev.xkmc.youkaishomecoming.init.registrate.YHCriteriaTriggers;
import dev.xkmc.youkaishomecoming.init.registrate.YHItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class CrabEntity
extends WaterAnimal
implements Bucketable,
StateMachineMob {
    private static final SyncedData DATA = new SyncedData(CrabEntity::defineId);
    static final EntityDataAccessor<Integer> TRANSIENT_DATA = DATA.define(SyncedData.INT, 0, null);
    static final EntityDataAccessor<Integer> FLAGS = DATA.define(SyncedData.INT, 0, "flags");
    static final EntityDataAccessor<Integer> VARIANT = DATA.define(SyncedData.INT, 0, "variant");
    public final CrabStateMachine states = new CrabStateMachine(this);
    public final CrabProperties prop = new CrabProperties(this);
    CrabDigGoal dig;

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 4.0);
    }

    private static <T> EntityDataAccessor<T> defineId(EntityDataSerializer<T> ser) {
        return SynchedEntityData.m_135353_(CrabEntity.class, ser);
    }

    public CrabEntity(EntityType<? extends WaterAnimal> type, Level level) {
        super(type, level);
        this.f_21342_ = new CrabMoveControl((Mob)this);
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.LEFT;
    }

    protected void m_8099_() {
        this.dig = new CrabDigGoal(this);
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new CrabFlipGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new CrabHideGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new CrabPanicGoal(this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(5, (Goal)this.dig);
        this.f_21345_.m_25352_(10, (Goal)new CrabRandomWalkGoal((PathfinderMob)this, 1.0, 40));
    }

    protected PathNavigation m_6037_(Level level) {
        return new AmphibiousPathNavigation((Mob)this, level);
    }

    protected SyncedData data() {
        return DATA;
    }

    protected SynchedEntityData entityData() {
        return this.f_19804_;
    }

    public CrabStateMachine states() {
        return this.states;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.data().register(this.f_19804_);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.data().write(tag, this.f_19804_);
        this.states.write(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.data().read(tag, this.f_19804_);
        this.states.read(tag);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7822_(byte data) {
        if (this.states.transitionTo(data)) {
            return;
        }
        super.m_7822_(data);
    }

    protected void m_6475_(DamageSource source, float val) {
        super.m_6475_(source, val);
        this.states.onHurt();
    }

    public void m_8107_() {
        super.m_8107_();
        this.states.tick();
    }

    protected void m_6229_(int air) {
        this.m_20301_(300);
    }

    public void dig(BlockState down) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ResourceLocation table;
            ServerLevel sl = (ServerLevel)level;
            Holder biome = sl.m_204166_(this.f_19826_);
            boolean sand = false;
            if (down.m_204336_(BlockTags.f_13029_)) {
                sand = true;
            } else if (!down.m_204336_(Tags.Blocks.GRAVEL)) {
                return;
            }
            ResourceLocation resourceLocation = table = sand ? YHLootGen.CRAB_SAND_BASE : YHLootGen.CRAB_GRAVEL_BASE;
            if (biome.m_203656_(YHBiomeTagsProvider.CRAB_MUD)) {
                table = sand ? YHLootGen.CRAB_SAND_RIVER : YHLootGen.CRAB_GRAVEL_RIVER;
            } else if (biome.m_203656_(BiomeTags.f_207604_) || biome.m_203656_(BiomeTags.f_207603_)) {
                table = sand ? YHLootGen.CRAB_SAND_BEACH : YHLootGen.CRAB_GRAVEL_BEACH;
            }
            ObjectArrayList list = sl.m_7654_().m_278653_().m_278676_(table).m_287195_(new LootParams.Builder(sl).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287235_(LootContextParamSets.f_81416_));
            if (list.isEmpty()) {
                return;
            }
            ItemStack stack = ((ItemStack)list.get(this.f_19796_.m_188503_(list.size()))).m_255036_(1);
            this.m_21008_(InteractionHand.MAIN_HAND, stack);
            this.m_21409_(EquipmentSlot.MAINHAND, 1.0f);
            sl.m_5594_(null, this.f_19826_, SoundEvents.f_12019_, SoundSource.AMBIENT, 0.7f, 1.0f);
        }
    }

    protected boolean isValidItemToGrab(ItemStack stack) {
        if (!stack.m_41720_().m_142095_()) {
            return false;
        }
        if (stack.m_41720_() instanceof MobBucketItem) {
            return false;
        }
        return !stack.m_150930_(Items.f_42656_);
    }

    public void m_21564_(float val) {
        if (this.m_20096_()) {
            this.m_21570_(val);
        } else {
            super.m_21564_(val);
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_() && this.states().isFlipped()) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                this.states().flipBack();
                sl.m_5594_(null, this.f_19826_, SoundEvents.f_12019_, SoundSource.AMBIENT, 0.7f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && this.states.canGrab() && this.isValidItemToGrab(stack)) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                if (stack.m_150930_(Items.f_42447_) && player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    YHCriteriaTriggers.CRAB_GRAB.m_222618_(sp);
                }
                this.m_21008_(InteractionHand.MAIN_HAND, stack.m_41620_(1));
                this.m_21409_(EquipmentSlot.MAINHAND, 1.0f);
                this.states.transitionTo(CrabState.SWING);
                sl.m_245803_((Entity)this, this.f_19826_, SoundEvents.f_12018_, SoundSource.AMBIENT, 0.7f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        Optional ans = Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this);
        if (ans.isPresent()) {
            ItemStack drop = this.m_21205_();
            if (!drop.m_41619_()) {
                this.m_19983_(drop);
                this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
            return (InteractionResult)ans.get();
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6094_() {
        return !this.states().isHiding();
    }

    public EntityDimensions m_6972_(Pose pose) {
        EntityDimensions ans = super.m_6972_(pose);
        if (this.states().isHiding()) {
            ans = ans.m_20390_(1.0f, 0.1f);
        }
        return ans;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance ins, MobSpawnType type, @Nullable SpawnGroupData group, @Nullable CompoundTag data) {
        Holder biome = level.m_204166_(this.m_20183_());
        if (biome.m_203656_(YHBiomeTagsProvider.CRAB_MUD)) {
            this.prop.setVariant(CrabVariant.MUD);
        }
        return super.m_6518_(level, ins, type, group, data);
    }

    public void m_6872_(ItemStack stack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)stack);
        CompoundTag tag = stack.m_41784_();
        boolean b = this.m_27487_();
        this.m_27497_(false);
        this.data().write(tag, this.f_19804_);
        this.m_27497_(b);
    }

    public void m_142278_(CompoundTag tag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)tag);
        this.data().read(tag, this.f_19804_);
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public ItemStack m_28282_() {
        return YHItems.CRAB_BUCKET.asStack();
    }

    public boolean m_27487_() {
        return this.prop.isFromBucket();
    }

    public void m_27497_(boolean b) {
        this.prop.setFromBucket(b);
    }
}

