/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.animal.crab;

import dev.xkmc.youkaishomecoming.content.entity.animal.crab.CrabEntity;
import dev.xkmc.youkaishomecoming.content.entity.animal.crab.CrabState;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class CrabHideGoal
extends Goal {
    private final CrabEntity mob;
    private int relaxTick = 0;

    public CrabHideGoal(CrabEntity mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (!this.mob.states.canHide()) {
            return false;
        }
        if (this.mob.states.isHiding()) {
            return true;
        }
        if (this.mob.m_217043_().m_188503_(this.mob.prop.hideWillingness()) != 0) {
            return false;
        }
        return this.mob.dig.canDig();
    }

    public boolean m_8045_() {
        return this.mob.states.isHiding();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26573_();
        this.mob.states.startHiding();
        this.relaxTick = 0;
    }

    public void m_8037_() {
        Level level;
        ++this.relaxTick;
        if (!this.mob.states.mayStopHiding()) {
            return;
        }
        if (this.relaxTick < this.m_183277_(100)) {
            return;
        }
        int chance = this.m_183277_(this.mob.prop.hideTime()) - this.relaxTick;
        if (chance <= 1 || this.mob.m_217043_().m_188503_(chance) == 0) {
            this.mob.states.stopHiding();
        }
        if (((CrabState)this.mob.states.state()).isInHidingAnim() && (level = this.mob.m_9236_()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            BlockPos pos = BlockPos.m_274446_((Position)this.mob.m_20182_());
            BlockState down = sl.m_8055_(pos.m_7495_());
            Vec3 vec = this.mob.m_20182_().m_82549_(Vec3.m_82503_((Vec2)new Vec2(0.0f, this.mob.m_146908_())).m_82490_((double)(this.mob.m_20205_() / 2.0f)));
            sl.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, down), vec.f_82479_, vec.f_82480_ + (double)0.1f, vec.f_82481_, 10, 0.0, 0.0, 0.0, 0.05);
            if (this.relaxTick % this.m_183277_(10) == 0) {
                sl.m_245803_((Entity)this.mob, this.mob.m_20183_(), SoundEvents.f_271174_, SoundSource.AMBIENT, 1.0f, 1.0f);
            }
        }
    }
}

