/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.animal.crab;

import dev.xkmc.youkaishomecoming.content.entity.animal.common.MobStateMachine;
import dev.xkmc.youkaishomecoming.content.entity.animal.crab.CrabEntity;
import dev.xkmc.youkaishomecoming.content.entity.animal.crab.CrabState;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;

public class CrabStateMachine
extends MobStateMachine<CrabEntity, CrabState, CrabStateMachine> {
    public final AnimationState dig = new AnimationState();
    public final AnimationState swing = new AnimationState();
    public final AnimationState flip = new AnimationState();
    public final AnimationState hide = new AnimationState();
    public final AnimationState hideStart = new AnimationState();
    public final AnimationState hideEnd = new AnimationState();

    public CrabStateMachine(CrabEntity e) {
        super((Mob)e, CrabState.class, (Enum[])CrabState.values());
    }

    @Override
    public void tick() {
        if (((CrabState)this.state()).isHiding() && !((CrabEntity)this.mob).m_20096_()) {
            this.transitionTo(CrabState.IDLE);
        }
        super.tick();
    }

    public void onHurt() {
        if (this.state() != CrabState.FLIP) {
            if (((CrabEntity)this.mob).m_21223_() < ((CrabEntity)this.mob).m_21233_() * 0.5f || ((CrabEntity)this.mob).m_217043_().m_188501_() < 0.3f) {
                this.transitionTo(CrabState.FLIP);
            } else if (this.state() == CrabState.HIDE) {
                this.transitionTo(CrabState.IDLE);
            }
            ItemStack stack = ((CrabEntity)this.mob).m_21205_();
            if (!stack.m_41619_()) {
                ((CrabEntity)this.mob).m_19983_(stack);
                ((CrabEntity)this.mob).m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
        } else {
            this.transitionTo(CrabState.IDLE);
        }
    }

    @Override
    protected void transitionTo(CrabState data, int tickRemain) {
        super.transitionTo(data, tickRemain);
        ((CrabEntity)this.mob).m_6210_();
    }

    public boolean isFlipped() {
        return this.state() == CrabState.FLIP;
    }

    public void startDigging() {
        this.transitionTo(CrabState.DIG);
    }

    public boolean canGrab() {
        return this.state() == CrabState.IDLE;
    }

    public boolean canDig() {
        return ((CrabEntity)this.mob).m_21223_() == ((CrabEntity)this.mob).m_21233_() && this.state() == CrabState.IDLE && ((CrabEntity)this.mob).m_21205_().m_41619_();
    }

    public void flipBack() {
        this.transitionTo(CrabState.IDLE);
    }

    public boolean isHiding() {
        return ((CrabState)this.state()).isHiding();
    }

    public boolean canHide() {
        if (!((CrabEntity)this.mob).m_20096_()) {
            return false;
        }
        return this.state() == CrabState.IDLE || ((CrabState)this.state()).isHiding();
    }

    public void startHiding() {
        if (this.state() == CrabState.IDLE) {
            this.transitionTo(CrabState.HIDE_START);
        }
    }

    public boolean mayStopHiding() {
        return this.state() == CrabState.HIDE;
    }

    public void stopHiding() {
        this.transitionTo(CrabState.HIDE_END);
    }
}

