/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.animal.deer;

import dev.xkmc.youkaishomecoming.content.entity.animal.common.StateMachineMob;
import dev.xkmc.youkaishomecoming.content.entity.animal.deer.DeerProperties;
import dev.xkmc.youkaishomecoming.content.entity.animal.deer.DeerStateMachine;
import dev.xkmc.youkaishomecoming.content.entity.animal.deer.DeerVariant;
import dev.xkmc.youkaishomecoming.content.entity.animal.deer.goal.DeerBreedGoal;
import dev.xkmc.youkaishomecoming.content.entity.animal.deer.goal.DeerEatBlockGoal;
import dev.xkmc.youkaishomecoming.content.entity.animal.deer.goal.DeerFollowParentGoal;
import dev.xkmc.youkaishomecoming.content.entity.animal.deer.goal.DeerPanicGoal;
import dev.xkmc.youkaishomecoming.content.entity.animal.deer.goal.DeerRelaxGoal;
import dev.xkmc.youkaishomecoming.content.entity.animal.deer.goal.DeerStateNotifierGoal;
import dev.xkmc.youkaishomecoming.content.entity.animal.deer.goal.DeerTemptGoal;
import dev.xkmc.youkaishomecoming.content.entity.youkai.SyncedData;
import dev.xkmc.youkaishomecoming.init.data.YHBiomeTagsProvider;
import dev.xkmc.youkaishomecoming.init.food.YHFood;
import dev.xkmc.youkaishomecoming.init.registrate.YHEntities;
import dev.xkmc.youkaishomecoming.init.registrate.YHSounds;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.Lazy;

public class DeerEntity
extends Animal
implements StateMachineMob {
    private static final SyncedData DATA = new SyncedData(DeerEntity::defineId);
    private static final Lazy<Ingredient> FOOD_ITEMS = Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{YHFood.SAKURA_MOCHI.item}));
    static final EntityDataAccessor<Integer> TRANSIENT_DATA = DATA.define(SyncedData.INT, 0, null);
    static final EntityDataAccessor<Integer> FLAGS = DATA.define(SyncedData.INT, 0, "flags");
    static final EntityDataAccessor<Integer> EAT_STAGE = DATA.define(SyncedData.INT, 0, "eat_stage");
    static final EntityDataAccessor<Integer> VARIANT = DATA.define(SyncedData.INT, 0, "variant");
    public final DeerStateMachine states = new DeerStateMachine(this);
    public final DeerProperties prop = new DeerProperties(this);
    protected List<DeerStateNotifierGoal> notifiers;
    protected DeerPanicGoal panic;
    public DeerEatBlockGoal eat;

    private static <T> EntityDataAccessor<T> defineId(EntityDataSerializer<T> ser) {
        return SynchedEntityData.m_135353_(DeerEntity.class, ser);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public DeerEntity(EntityType<? extends DeerEntity> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.panic = new DeerPanicGoal(this, 1.25);
        this.eat = new DeerEatBlockGoal(this);
        this.notifiers = new ArrayList<DeerStateNotifierGoal>();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)this.panic);
        this.f_21345_.m_25352_(3, new DeerBreedGoal(this, 1.0).register(this.notifiers));
        this.f_21345_.m_25352_(4, new DeerTemptGoal(this, 1.2, (Ingredient)FOOD_ITEMS.get(), false).register(this.notifiers));
        this.f_21345_.m_25352_(5, new DeerFollowParentGoal(this, 1.1).register(this.notifiers));
        this.f_21345_.m_25352_(6, (Goal)this.eat);
        this.f_21345_.m_25352_(7, (Goal)new DeerRelaxGoal(this));
        this.f_21345_.m_25352_(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(13, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected SyncedData data() {
        return DATA;
    }

    protected SynchedEntityData entityData() {
        return this.f_19804_;
    }

    public DeerStateMachine states() {
        return this.states;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.data().register(this.f_19804_);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.data().write(tag, this.f_19804_);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.data().read(tag, this.f_19804_);
    }

    public void m_7822_(byte data) {
        if (this.states.transitionTo(data)) {
            return;
        }
        super.m_7822_(data);
    }

    protected void m_6475_(DamageSource source, float val) {
        super.m_6475_(source, val);
        this.states.onHurt();
    }

    public void m_8107_() {
        super.m_8107_();
        this.states.tick();
    }

    protected void m_30232_() {
        if (this.m_6162_()) {
            this.prop.setHorned(false);
        } else {
            this.prop.setHorned(this.prop.isMale());
        }
    }

    public void m_8035_() {
        this.m_5634_(1.0f);
        super.m_8035_();
        if (this.m_6162_()) {
            this.m_146758_(60);
        } else if (!this.prop.isHorned() && this.prop.isMale()) {
            int stage = this.prop.getEatAge();
            if (stage >= 3) {
                this.prop.setHorned(true);
                this.prop.setEatAge(0);
            } else {
                this.prop.setEatAge(stage + 1);
            }
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        EntityDimensions ans = super.m_6972_(pose);
        if (this.states().isRelaxed()) {
            ans = ans.m_20390_(1.0f, 0.7f);
        }
        return ans;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance ins, MobSpawnType type, @Nullable SpawnGroupData group, @Nullable CompoundTag data) {
        Holder biome;
        SpawnGroupData ans = super.m_6518_(level, ins, type, group, data);
        this.prop.setMale(level.m_213780_().m_188499_());
        if (!this.m_6162_()) {
            this.prop.setHorned(this.prop.isMale());
        }
        if ((biome = level.m_204166_(this.m_20183_())).m_203656_(YHBiomeTagsProvider.WHITE_GRAPE)) {
            this.prop.setVariant(DeerVariant.FALLOW);
        } else if (biome.m_203656_(YHBiomeTagsProvider.BLACK_GRAPE)) {
            this.prop.setVariant(DeerVariant.WHITELIPPED);
        } else {
            this.prop.setVariant(DeerVariant.NORMAL);
        }
        return ans;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)YHSounds.DEER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)YHSounds.DEER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)YHSounds.DEER_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12345_, 0.15f, 1.0f);
    }

    @Nullable
    public DeerEntity getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return (DeerEntity)YHEntities.DEER.create((Level)level);
    }

    public boolean m_6898_(ItemStack stack) {
        return ((Ingredient)FOOD_ITEMS.get()).test(stack);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    protected float m_6431_(Pose pose, EntityDimensions dim) {
        return dim.f_20378_ * 0.95f;
    }
}

