/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.animal.deer;

import dev.xkmc.youkaishomecoming.content.entity.animal.common.MobState;
import dev.xkmc.youkaishomecoming.content.entity.animal.deer.DeerEntity;
import dev.xkmc.youkaishomecoming.content.entity.animal.deer.DeerStateMachine;
import java.util.function.Function;
import net.minecraft.world.entity.AnimationState;
import org.jetbrains.annotations.Nullable;

public enum DeerState implements MobState<DeerEntity, DeerState, DeerStateMachine>
{
    IDLE(0, null, new Function[0]),
    RELAX(0, null, e -> e.relaxDur),
    EAT(34, IDLE, e -> e.eat),
    RELAX_START(22, RELAX, e -> e.relaxStart),
    RELAX_EAT(34, RELAX, e -> e.eat),
    RELAX_END(24, IDLE, e -> e.relaxEnd),
    ATTACK(0, IDLE, e -> e.attack),
    SMELL(0, IDLE, e -> e.smell);

    final int tick;
    @Nullable
    final DeerState next;
    final Function<DeerStateMachine, AnimationState>[] anims;

    private DeerState(int tick, DeerState next, Function<DeerStateMachine, AnimationState> ... anims) {
        this.tick = tick;
        this.next = next;
        this.anims = anims;
    }

    @Override
    public int tick() {
        return this.tick;
    }

    @Override
    @Nullable
    public DeerState next() {
        return this.next;
    }

    @Override
    public Function<DeerStateMachine, AnimationState>[] anims() {
        return this.anims;
    }

    public boolean mobile() {
        return this == IDLE;
    }

    public boolean isRelaxed() {
        return this == RELAX_START || this == RELAX || this == RELAX_EAT || this == RELAX_END;
    }
}

