/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.animal.deer;

import dev.xkmc.youkaishomecoming.content.entity.animal.common.MobStateMachine;
import dev.xkmc.youkaishomecoming.content.entity.animal.deer.DeerEntity;
import dev.xkmc.youkaishomecoming.content.entity.animal.deer.DeerState;
import dev.xkmc.youkaishomecoming.content.entity.animal.deer.goal.DeerStateNotifierGoal;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Mob;

public class DeerStateMachine
extends MobStateMachine<DeerEntity, DeerState, DeerStateMachine> {
    public final AnimationState smell = new AnimationState();
    public final AnimationState attack = new AnimationState();
    public final AnimationState eat = new AnimationState();
    public final AnimationState relaxStart = new AnimationState();
    public final AnimationState relaxDur = new AnimationState();
    public final AnimationState relaxEnd = new AnimationState();

    public DeerStateMachine(DeerEntity e) {
        super((Mob)e, DeerState.class, (Enum[])DeerState.values());
    }

    @Override
    protected void transitionTo(DeerState data, int tickRemain) {
        super.transitionTo(data, tickRemain);
        ((DeerEntity)this.mob).m_6210_();
    }

    public boolean isMobile() {
        return ((DeerState)this.state()).mobile();
    }

    public boolean isRelaxed() {
        return ((DeerState)this.state()).isRelaxed();
    }

    public boolean canRelax() {
        return this.state() == DeerState.IDLE || ((DeerState)this.state()).isRelaxed();
    }

    public void startRelax() {
        if (this.state() == DeerState.IDLE) {
            this.transitionTo(DeerState.RELAX_START);
        }
    }

    public boolean mayStopRelax() {
        return this.state() == DeerState.RELAX;
    }

    public void stopRelax() {
        this.transitionTo(DeerState.RELAX_END);
    }

    public boolean canEat() {
        return this.state() == DeerState.IDLE || this.state() == DeerState.RELAX;
    }

    public void startEating() {
        if (((DeerState)this.state()).isRelaxed()) {
            this.transitionTo(DeerState.RELAX_EAT);
        } else {
            this.transitionTo(DeerState.EAT);
        }
    }

    public void onHurt() {
        ((DeerEntity)this.mob).eat.m_8041_();
        if (this.state() != DeerState.IDLE) {
            this.transitionTo(DeerState.IDLE);
        }
    }

    public boolean mustStopRelax() {
        if (((DeerEntity)this.mob).notifiers == null) {
            return false;
        }
        for (DeerStateNotifierGoal e : ((DeerEntity)this.mob).notifiers) {
            if (!e.shouldStopRelax()) continue;
            return true;
        }
        return false;
    }
}

