/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.animal.deer.goal;

import dev.xkmc.youkaishomecoming.content.entity.animal.deer.DeerEntity;
import dev.xkmc.youkaishomecoming.content.entity.animal.deer.DeerVariant;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraftforge.event.ForgeEventFactory;

public class DeerEatBlockGoal
extends Goal {
    private static final Predicate<BlockState> IS_PINK_PETAL = BlockStatePredicate.m_61287_((Block)Blocks.f_271445_);
    private final DeerEntity mob;
    private final Level level;
    protected int eatAnimationTick;
    protected int finishTick;

    public DeerEatBlockGoal(DeerEntity mob) {
        this.mob = mob;
        this.level = mob.m_9236_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (!this.mob.states.canEat()) {
            return false;
        }
        if (this.mob.m_217043_().m_188503_(this.mob.prop.eatWillingness()) != 0) {
            return false;
        }
        return this.canEat();
    }

    protected boolean canEat() {
        BlockPos blockpos = BlockPos.m_274446_((Position)this.mob.m_20182_().m_82549_(this.mob.m_20156_()));
        if (IS_PINK_PETAL.test(this.level.m_8055_(blockpos))) {
            return true;
        }
        return this.level.m_8055_(blockpos.m_7495_()).m_60713_(Blocks.f_50440_);
    }

    public void m_8056_() {
        this.mob.states.startEating();
        this.eatAnimationTick = this.m_183277_(34);
        this.finishTick = this.m_183277_(10);
        this.level.m_7605_((Entity)this.mob, (byte)10);
        this.mob.m_21573_().m_26573_();
    }

    public void m_8041_() {
        this.eatAnimationTick = 0;
        this.finishTick = 0;
    }

    public boolean m_8045_() {
        return this.eatAnimationTick > 0;
    }

    public void m_8037_() {
        this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        if (this.eatAnimationTick == this.finishTick) {
            BlockPos pos = BlockPos.m_274446_((Position)this.mob.m_20182_().m_82549_(this.mob.m_20156_()));
            if (IS_PINK_PETAL.test(this.level.m_8055_(pos))) {
                if (ForgeEventFactory.getMobGriefingEvent((Level)this.level, (Entity)this.mob)) {
                    this.level.m_46961_(pos, false);
                    if (this.mob.prop.getVariant() == DeerVariant.NORMAL) {
                        this.mob.prop.setVariant(DeerVariant.SAKURA);
                    }
                }
                this.mob.m_8035_();
            } else {
                BlockPos down = pos.m_7495_();
                if (this.level.m_8055_(down).m_60713_(Blocks.f_50440_)) {
                    if (this.mob.prop.eatConsume() && ForgeEventFactory.getMobGriefingEvent((Level)this.level, (Entity)this.mob)) {
                        this.level.m_46796_(2001, down, Block.m_49956_((BlockState)Blocks.f_50440_.m_49966_()));
                        this.level.m_7731_(down, Blocks.f_50493_.m_49966_(), 2);
                    }
                    this.mob.m_8035_();
                }
            }
        }
    }
}

