/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.danmaku;

import dev.xkmc.fastprojectileapi.entity.ProjectileMovement;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.capability.GrazeHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuCommander;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuParticleHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.YHBaseDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.item.danmaku.DanmakuItem;
import dev.xkmc.youkaishomecoming.content.spell.mover.DanmakuMover;
import dev.xkmc.youkaishomecoming.content.spell.mover.MoverInfo;
import dev.xkmc.youkaishomecoming.content.spell.mover.MoverOwner;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.TrailAction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class ItemDanmakuEntity
extends YHBaseDanmakuEntity
implements ItemSupplier,
MoverOwner {
    @SerialClass.SerialField
    public int controlCode = 0;
    @SerialClass.SerialField
    public DanmakuMover mover = null;
    @SerialClass.SerialField
    public TrailAction afterExpiry = null;
    @SerialClass.SerialField
    public ItemStack stack = ItemStack.f_41583_;
    private boolean isErased = false;
    private Float sizeCache = null;
    private int lastGraze = 0;

    public ItemDanmakuEntity(EntityType<? extends ItemDanmakuEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends YHBaseDanmakuEntity>)pEntityType, pLevel);
    }

    public ItemDanmakuEntity(EntityType<? extends ItemDanmakuEntity> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        super(pEntityType, pX, pY, pZ, pLevel);
    }

    public ItemDanmakuEntity(EntityType<? extends ItemDanmakuEntity> pEntityType, LivingEntity pShooter, Level pLevel) {
        super(pEntityType, pShooter, pLevel);
    }

    public void setItem(ItemStack pStack) {
        this.stack = pStack.m_255036_(1);
        this.m_6210_();
    }

    public void setControlCode(int code) {
        this.controlCode = code;
    }

    @Override
    public TraceableEntity asTraceable() {
        return this;
    }

    @Override
    protected void terminate() {
        if (this.afterExpiry == null) {
            return;
        }
        CardHolder holder = null;
        Entity e = this.m_19749_();
        if (e instanceof CardHolder) {
            CardHolder h;
            holder = h = (CardHolder)e;
        }
        if (holder == null) {
            this.afterExpiry.execute(this.m_20182_(), this.m_20184_());
        } else {
            this.afterExpiry.execute(holder, this.m_20182_(), this.m_20184_());
        }
    }

    @Override
    protected ProjectileMovement updateVelocity(Vec3 vec, Vec3 pos) {
        Entity entity;
        if (this.mover != null) {
            return this.mover.move(new MoverInfo(this.f_19797_, pos, vec, this));
        }
        if (this.controlCode > 0 && (entity = this.m_19749_()) instanceof DanmakuCommander) {
            DanmakuCommander commander = (DanmakuCommander)entity;
            return commander.move(this.controlCode, this.f_19797_, vec);
        }
        return super.updateVelocity(vec, pos);
    }

    public ItemStack m_7846_() {
        return this.stack;
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.m_6210_();
    }

    @Override
    public void readSpawnData(FriendlyByteBuf data) {
        super.readSpawnData(data);
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return super.m_6972_(pPose).m_20388_(this.scale());
    }

    public boolean fullBright() {
        return true;
    }

    @Override
    public void markErased(boolean kill) {
        if (!this.isErased) {
            super.markErased(kill);
        }
        this.isErased = true;
    }

    @Override
    public boolean isValid() {
        return !this.isErased && super.isValid();
    }

    public float scale() {
        Item item;
        if (this.sizeCache == null && (item = this.m_7846_().m_41720_()) instanceof DanmakuItem) {
            DanmakuItem item2 = (DanmakuItem)item;
            this.sizeCache = Float.valueOf(item2.size);
        }
        return this.sizeCache == null ? 1.0f : this.sizeCache.floatValue();
    }

    @Override
    public void doGraze(Player entity) {
        if (this.f_19797_ < this.lastGraze) {
            return;
        }
        this.lastGraze = this.f_19797_ + 20;
        GrazeHelper.graze(entity, this);
    }

    @Override
    public void poof() {
        if (!this.m_9236_().m_5776_()) {
            return;
        }
        Item item = this.m_7846_().m_41720_();
        if (!(item instanceof DanmakuItem)) {
            return;
        }
        DanmakuItem item2 = (DanmakuItem)item;
        int col = item2.color.m_41071_();
        Vec3 pos = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
        DanmakuParticleHelper.ball(this.m_9236_(), pos, col, this.m_20205_() / 2.0f, this.f_19796_);
    }
}

