/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.danmaku;

import dev.xkmc.fastprojectileapi.entity.BaseProjectile;
import dev.xkmc.fastprojectileapi.entity.ProjectileMovement;
import dev.xkmc.fastprojectileapi.entity.SimplifiedProjectile;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.l2serial.serialization.codec.PacketCodec;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.IYHDanmaku;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class YHBaseDanmakuEntity
extends BaseProjectile
implements IYHDanmaku {
    @SerialClass.SerialField
    private int life = 0;
    @SerialClass.SerialField
    private boolean bypassWall = false;
    @SerialClass.SerialField
    private boolean bypassEntity = false;
    @SerialClass.SerialField
    public float damage = 0.0f;

    protected YHBaseDanmakuEntity(EntityType<? extends YHBaseDanmakuEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends BaseProjectile>)pEntityType, pLevel);
    }

    protected YHBaseDanmakuEntity(EntityType<? extends YHBaseDanmakuEntity> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        this(pEntityType, pLevel);
        this.m_6034_(pX, pY, pZ);
    }

    protected YHBaseDanmakuEntity(EntityType<? extends YHBaseDanmakuEntity> pEntityType, LivingEntity pShooter, Level pLevel) {
        this(pEntityType, pShooter.m_20185_(), pShooter.m_20188_() - (double)0.1f, pShooter.m_20189_(), pLevel);
        this.setOwner((Entity)pShooter);
    }

    public void setup(float damage, int life, boolean bypassWall, boolean bypassEntity, Vec3 initVec) {
        this.damage = damage;
        this.life = life;
        this.bypassWall = bypassWall;
        this.bypassEntity = bypassEntity;
        this.m_20256_(initVec);
        this.updateRotation(ProjectileMovement.of(initVec).rot());
    }

    @Override
    public SimplifiedProjectile self() {
        return this;
    }

    @Override
    public boolean checkBlockHit() {
        return !this.bypassWall;
    }

    @Override
    public int lifetime() {
        return this.life;
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("auto-serial", (Tag)Objects.requireNonNull(TagCodec.toTag((CompoundTag)new CompoundTag(), (Object)this)));
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("auto-serial")) {
            Wrappers.run(() -> TagCodec.fromTag((CompoundTag)nbt.m_128469_("auto-serial"), this.getClass(), (Object)this, f -> true));
        }
    }

    @Override
    public void writeSpawnData(FriendlyByteBuf buffer) {
        super.writeSpawnData(buffer);
        PacketCodec.to((FriendlyByteBuf)buffer, (Object)this);
    }

    @Override
    public void readSpawnData(FriendlyByteBuf data) {
        super.readSpawnData(data);
        PacketCodec.from((FriendlyByteBuf)data, this.getClass(), (Object)((YHBaseDanmakuEntity)Wrappers.cast((Object)this)));
    }

    @Override
    protected void onHitBlock(BlockHitResult pResult) {
        super.onHitBlock(pResult);
        if (!this.m_9236_().f_46443_) {
            this.m_146870_();
        }
    }

    @Override
    public float damage(Entity target) {
        return this.damage;
    }

    @Override
    public boolean canHitEntity(Entity target) {
        return super.canHitEntity(target) && this.shouldHurt(this.m_19749_(), target);
    }

    @Override
    public void onHitEntity(EntityHitResult result) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.hurtTarget(result);
        if (!this.bypassEntity) {
            this.m_146870_();
        }
    }
}

