/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.rumia;

import dev.xkmc.l2library.util.math.MathHelper;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.rumia.RumiaEntity;
import dev.xkmc.youkaishomecoming.events.EffectEventHandlers;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class RumiaStateMachine {
    private static final int PREPARE_TIME = 20;
    private static final int FLY_TIME = 60;
    private static final int BLOCK_TIME = 100;
    private static final int SUCCESS_DELAY = 100;
    private static final int BLOCK_DELAY = 200;
    private static final float SPEED = 2.0f;
    private static final float KNOCK = 3.0f;
    private static final float DANMAKU_SPEED = 0.8f;
    private static final UUID ATK = MathHelper.getUUIDFromString((String)"rumia_charge_attack");
    private final RumiaEntity rumia;
    @SerialClass.SerialField
    private RumiaStage stage = RumiaStage.NONE;
    @SerialClass.SerialField
    private int time = 0;
    @SerialClass.SerialField
    private int ballDelay = 0;

    RumiaStateMachine(RumiaEntity rumia) {
        this.rumia = rumia;
    }

    public void tick() {
        if (this.rumia.m_9236_().m_5776_()) {
            if (this.stage == RumiaStage.NONE && this.isCharged()) {
                this.stage = RumiaStage.PREPARE;
                this.time = 20;
            } else if (this.stage == RumiaStage.PREPARE) {
                if (this.time > 0) {
                    --this.time;
                    if (this.time == 0) {
                        this.stage = RumiaStage.NONE;
                    }
                }
            } else {
                this.time = 0;
                this.stage = RumiaStage.NONE;
            }
            return;
        }
        if (this.rumia.m_5448_() == null) {
            this.ballDelay = 100;
        } else if (this.ballDelay > 0) {
            --this.ballDelay;
        }
        if (this.time > 0) {
            --this.time;
            if (this.time == 0) {
                if (this.stage == RumiaStage.PREPARE) {
                    LivingEntity target = this.rumia.m_5448_();
                    if (target != null && target.m_6084_() && target.m_142066_()) {
                        Vec3 src = this.rumia.m_20182_().m_82520_(0.0, (double)this.rumia.m_20206_() * 0.5, 0.0);
                        Vec3 dst = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.5, 0.0);
                        Vec3 vec = dst.m_82546_(src).m_82541_().m_82490_(2.0);
                        this.rumia.m_20256_(vec);
                        this.stage = RumiaStage.FLY;
                        this.time = 60;
                    } else {
                        this.stage = RumiaStage.NONE;
                        this.setCharged(false);
                    }
                } else if (this.stage == RumiaStage.FLY) {
                    this.stage = RumiaStage.NONE;
                    this.setCharged(false);
                    this.ballDelay = 100;
                } else if (this.stage == RumiaStage.BLOCKED) {
                    this.stage = RumiaStage.NONE;
                    this.setBlocked(false);
                    this.ballDelay = 200;
                }
            }
        }
    }

    public void startChargeAttack(LivingEntity target) {
        if (this.stage != RumiaStage.NONE) {
            return;
        }
        if (this.ballDelay > 0) {
            return;
        }
        if (EffectEventHandlers.isFullCharacter(target)) {
            return;
        }
        this.rumia.m_21573_().m_26573_();
        this.stage = RumiaStage.PREPARE;
        this.time = 20;
        this.setCharged(true);
        this.rumia.m_20256_(Vec3.f_82478_);
    }

    public void onAttack(LivingEntity target) {
        if (this.stage != RumiaStage.FLY) {
            return;
        }
        if (target.m_6084_()) {
            target.m_20256_(this.rumia.m_20184_().m_82541_().m_82490_(3.0).m_82542_(1.0, 0.0, 1.0).m_82520_(0.0, 0.4, 0.0));
            target.f_19812_ = true;
        }
        this.rumia.m_20256_(Vec3.f_82478_);
        this.stage = RumiaStage.NONE;
        this.setCharged(false);
        this.ballDelay = 100;
    }

    public void onHurt(LivingEntity le, float amount) {
        if (this.stage == RumiaStage.BLOCKED) {
            if (amount >= 2.0f) {
                this.time = this.time / 2 + 1;
            }
        } else if (this.stage != RumiaStage.FLY && amount >= 2.0f) {
            this.shoot(le);
        }
    }

    private void shoot(LivingEntity target) {
        double dx = target.m_20185_() - this.rumia.m_20185_();
        double dy = target.m_20227_(0.5) - this.rumia.m_20227_(0.5);
        double dz = target.m_20189_() - this.rumia.m_20189_();
        Vec3 vec = new Vec3(dx, dy, dz).m_82541_();
        DanmakuHelper.Orientation ori = DanmakuHelper.getOrientation(vec);
        float dmg = (float)this.rumia.m_21133_(Attributes.f_22281_);
        int n = this.rumia.isEx() ? 24 : 12;
        for (int i = 0; i < n; ++i) {
            this.rumia.shoot(dmg, 40, ori.rotateDegrees(360.0f / (float)n * (float)i).m_82490_((double)0.8f), DyeColor.RED);
        }
    }

    public void onBlocked() {
        if (this.stage != RumiaStage.FLY) {
            return;
        }
        this.rumia.m_21573_().m_26573_();
        this.rumia.m_20256_(this.rumia.m_20184_().m_82490_(-0.5));
        this.setCharged(false);
        this.setBlocked(true);
        this.time = 100;
        this.stage = RumiaStage.BLOCKED;
        if (this.rumia.isEx()) {
            this.time /= 2;
        }
    }

    public boolean isCharged() {
        return this.rumia.getFlag(1);
    }

    public boolean isBlocked() {
        return this.rumia.getFlag(2);
    }

    private void setCharged(boolean charged) {
        AttributeInstance attr = this.rumia.m_21051_(Attributes.f_22281_);
        assert (attr != null);
        if (charged) {
            attr.m_22125_(new AttributeModifier(ATK, "rumia_charge_attack", 34.0, AttributeModifier.Operation.ADDITION));
        } else {
            attr.m_22120_(ATK);
        }
        this.rumia.setFlag(1, charged);
    }

    private void setBlocked(boolean blocked) {
        this.rumia.setFlag(2, blocked);
        this.rumia.m_6210_();
    }

    public static enum RumiaStage {
        NONE,
        PREPARE,
        FLY,
        BLOCKED;

    }
}

