/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.item.fluid;

import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import dev.xkmc.youkaishomecoming.content.item.fluid.IYHFluidHolder;
import dev.xkmc.youkaishomecoming.content.item.fluid.SlipBottleIngredient;
import dev.xkmc.youkaishomecoming.content.item.fluid.SlipBottleItem;
import dev.xkmc.youkaishomecoming.content.item.fluid.YHFluid;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fluids.FluidStack;

public abstract class BottleTexture {
    private static List<BottleTexture> LIST = new ArrayList<BottleTexture>();
    public final int index = LIST.size();

    public BottleTexture() {
        LIST.add(this);
    }

    public static Ingredient replace(Ingredient ing) {
        for (BottleTexture e : LIST) {
            if (!ing.test(e.holder().asStack(1))) continue;
            return new SlipBottleIngredient((Fluid)e.holder().source()).validate();
        }
        return ing;
    }

    public abstract IYHFluidHolder holder();

    public abstract String bottleModel();

    public static void buildBottleModel(DataGenContext<Item, SlipBottleItem> ctx, RegistrateItemModelProvider pvd) {
        ItemModelBuilder model = pvd.generated(ctx, new ResourceLocation[]{pvd.modLoc("item/sake_bottle")});
        model.override().predicate(YoukaisHomecoming.loc("slip"), 0.03125f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)pvd.getBuilder(ctx.getName() + "_overlay")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", pvd.modLoc("item/sake_bottle"))).texture("layer1", pvd.modLoc("item/sake_bottle_overlay"))).end();
        int n = LIST.size();
        for (BottleTexture e : LIST) {
            model.override().predicate(YoukaisHomecoming.loc("bottle"), ((float)e.index + 0.5f) / (float)n).model((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("item/" + e.bottleModel()))).end();
        }
    }

    public static float texture(ItemStack stack) {
        FluidStack fluid = SlipBottleItem.getFluid(stack);
        if (fluid.isEmpty()) {
            return 0.0f;
        }
        Fluid fluid2 = fluid.getFluid();
        if (!(fluid2 instanceof YHFluid)) {
            return 0.0f;
        }
        YHFluid liquid = (YHFluid)fluid2;
        BottleTexture set = liquid.type.bottleSet();
        if (set == null) {
            return 0.0f;
        }
        return (float)(set.index + 1) * 1.0f / (float)LIST.size();
    }
}

